/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class EntityReference<E extends Entity>
implements IDataSerializable {
    private World world;
    private E tracked_entity;
    private UUID entity_uuid = null_uuid;
    private OnFound<E> onFind = null;
    private static final UUID null_uuid = UUID.fromString("00000000-0000-0000-0000-000000000000");
    protected transient int fails = 0;

    public EntityReference() {
    }

    public EntityReference(World world) {
        this.world = world;
    }

    public EntityReference(E ent) {
        this.world = ((Entity)ent).field_70170_p;
        this.trackEntity(ent);
    }

    public EntityReference(OnFound<E> informer) {
        this.whenFound(informer);
    }

    public EntityReference<E> whenFound(OnFound<E> informer) {
        this.onFind = informer;
        return this;
    }

    public void setWorld(World w) {
        this.world = w;
    }

    public void trackEntity(E ent) {
        if (this.world == null && ent != null) {
            this.world = ((Entity)ent).field_70170_p;
        }
        if (ent != null && ((Entity)ent).field_70128_L) {
            ent = null;
        }
        this.tracked_entity = ent;
        this.entity_uuid = this.tracked_entity == null ? null_uuid : ent.func_110124_au();
    }

    public boolean trackingEntity() {
        return !null_uuid.equals(this.entity_uuid);
    }

    public E getEntity() {
        if (this.tracked_entity == null) {
            if (!this.trackingEntity()) {
                return null;
            }
            this.fetchEntity();
        }
        return this.tracked_entity;
    }

    public E getLocatedEntity() {
        return this.tracked_entity;
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        UUID orig_id = this.entity_uuid;
        this.entity_uuid = data.asSameShare(prefix + "entity_uuid").putUUID(this.entity_uuid);
        if (data.isReader() && this.tracked_entity != null && !orig_id.equals(this.entity_uuid)) {
            this.tracked_entity = null;
            this.fails = 0;
        }
        return this;
    }

    protected void fetchEntity() {
        if (this.world == null) {
            return;
        }
        if (this.fails++ > 4 && this.fails % 40 != 0) {
            return;
        }
        for (Entity ent : this.world.field_72996_f) {
            if (!this.entity_uuid.equals(ent.func_110124_au())) continue;
            this.tracked_entity = ent;
            this.fails = 0;
            if (this.onFind == null) break;
            this.onFind.found(this.tracked_entity);
            break;
        }
    }

    public boolean entityFound() {
        return this.tracked_entity != null;
    }

    public boolean trackedAndAlive() {
        if (!this.trackingEntity()) {
            return false;
        }
        if (!this.entityFound()) {
            return true;
        }
        return !((Entity)this.tracked_entity).field_70128_L;
    }

    public UUID getUUID() {
        return this.entity_uuid;
    }

    public static interface OnFound<E extends Entity> {
        public void found(E var1);
    }
}

