/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import factorization.api.Coord;
import factorization.ceramics.TileEntityGreenware;
import factorization.charge.TileEntityLeydenJar;
import factorization.common.FactoryType;
import factorization.shared.Core;
import factorization.shared.TileEntityCommon;
import factorization.util.ItemUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemFactorizationBlock
extends ItemBlock {
    public ItemFactorizationBlock(Block id) {
        super(id);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public boolean placeBlockAt(ItemStack is, EntityPlayer player, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int md) {
        Coord here = new Coord(w, x, y, z);
        FactoryType f = FactoryType.fromMd((byte)is.func_77960_j());
        if (f == null) {
            is.field_77994_a = 0;
            return false;
        }
        TileEntityCommon tec = f.makeTileEntity();
        if (tec == null) {
            return false;
        }
        here.setAsTileEntityLocation(tec);
        Coord placedAgainst = here.add(ForgeDirection.getOrientation((int)side).getOpposite());
        boolean good = tec.canPlaceAgainst(player, placedAgainst, side);
        if (!good) {
            return false;
        }
        if (super.placeBlockAt(is, player, w, x, y, z, side, hitX, hitY, hitZ, md)) {
            here.setAsTileEntityLocation(tec);
            tec.onPlacedBy(player, is, side, hitX, hitY, hitZ);
            tec.getBlockClass().enforce(here);
            here.setTE(tec);
            here.markBlockForUpdate();
            return true;
        }
        return false;
    }

    public IIcon func_77617_a(int damage) {
        return Core.registry.factory_block.func_149691_a(0, damage);
    }

    public int func_77647_b(int i) {
        return 15;
    }

    public String func_77667_c(ItemStack is) {
        int md = is.func_77960_j();
        FactoryType ft = FactoryType.fromMd((byte)md);
        return "factorization.factoryBlock." + (Object)((Object)ft);
    }

    public void func_77624_a(ItemStack is, EntityPlayer player, List infoList, boolean verbose) {
        NBTTagCompound tag;
        if (Core.registry.greenware_item != null && is.func_77969_a(Core.registry.greenware_item) && (tag = is.func_77978_p()) != null) {
            TileEntityGreenware teg = (TileEntityGreenware)FactoryType.CERAMIC.getRepresentative();
            teg.func_145839_a(tag);
            TileEntityGreenware.ClayState state = teg.getState();
            infoList.add(teg.parts.size() + " parts");
            infoList.add(state.toString());
        }
        if (ItemUtil.similar(is, Core.registry.leydenjar_item)) {
            int perc = 0;
            if (is.func_77942_o()) {
                FactoryType ft = FactoryType.LEYDENJAR;
                TileEntityLeydenJar jar = (TileEntityLeydenJar)ft.getRepresentative();
                jar.loadFromStack(is);
                perc = (int)(jar.getLevel() * 100.0);
            }
            infoList.add(StatCollector.func_74837_a((String)"factorization.factoryBlock.LEYDENJAR.perc", (Object[])new Object[]{perc}));
        }
        Core.brand(is, player, infoList, verbose);
    }

    public boolean func_77651_p() {
        return true;
    }
}

