/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.IEntityMessage;
import factorization.api.Quaternion;
import factorization.api.VectorUV;
import factorization.api.datahelpers.DataInByteBuf;
import factorization.artifact.ContainerForge;
import factorization.common.Command;
import factorization.common.FactoryType;
import factorization.shared.Core;
import factorization.shared.FzNetDispatch;
import factorization.shared.Sound;
import factorization.shared.TileEntityCommon;
import factorization.util.DataUtil;
import factorization.utiligoo.ItemGoo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class NetworkFactorization {
    public static final ItemStack EMPTY_ITEMSTACK = new ItemStack(Blocks.field_150350_a);
    private static byte message_type_count = 0;

    private void writeObjects(ByteBuf output, Object ... items) throws IOException {
        for (Object item : items) {
            if (item == null) {
                throw new RuntimeException("Argument is null!");
            }
            if (item instanceof Integer) {
                output.writeInt(((Integer)item).intValue());
                continue;
            }
            if (item instanceof Byte) {
                output.writeByte((int)((Byte)item).byteValue());
                continue;
            }
            if (item instanceof Short) {
                output.writeShort((int)((Short)item).shortValue());
                continue;
            }
            if (item instanceof String) {
                ByteBufUtils.writeUTF8String((ByteBuf)output, (String)((String)item));
                continue;
            }
            if (item instanceof Boolean) {
                output.writeBoolean(((Boolean)item).booleanValue());
                continue;
            }
            if (item instanceof Float) {
                output.writeFloat(((Float)item).floatValue());
                continue;
            }
            if (item instanceof Double) {
                output.writeDouble(((Double)item).doubleValue());
                continue;
            }
            if (item instanceof ItemStack) {
                ItemStack is = (ItemStack)item;
                if (is == EMPTY_ITEMSTACK) {
                    is = null;
                }
                ByteBufUtils.writeItemStack((ByteBuf)output, (ItemStack)is);
                continue;
            }
            if (item instanceof VectorUV) {
                VectorUV v = (VectorUV)item;
                output.writeFloat((float)v.x);
                output.writeFloat((float)v.y);
                output.writeFloat((float)v.z);
                continue;
            }
            if (item instanceof DeltaCoord) {
                DeltaCoord dc = (DeltaCoord)item;
                dc.write(output);
                continue;
            }
            if (item instanceof Quaternion) {
                Quaternion q = (Quaternion)item;
                q.write(output);
                continue;
            }
            if (item instanceof byte[]) {
                byte[] b = (byte[])item;
                output.writeBytes(b);
                continue;
            }
            if (item instanceof MessageType) {
                MessageType mt = (MessageType)((Object)item);
                mt.write(output);
                continue;
            }
            if (item instanceof NBTTagCompound) {
                NBTTagCompound tag = (NBTTagCompound)item;
                ByteBufUtils.writeTag((ByteBuf)output, (NBTTagCompound)tag);
                continue;
            }
            throw new RuntimeException("Don't know how to serialize " + item.getClass() + " (" + item + ")");
        }
    }

    public void prefixTePacket(ByteBuf output, Coord src, MessageType messageType) throws IOException {
        messageType.write(output);
        output.writeInt(src.x);
        output.writeInt(src.y);
        output.writeInt(src.z);
    }

    public FMLProxyPacket TEmessagePacket(Coord src, MessageType messageType, Object ... items) {
        try {
            ByteBuf output = Unpooled.buffer();
            this.prefixTePacket(output, src, messageType);
            this.writeObjects(output, items);
            return FzNetDispatch.generate(output);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public FMLProxyPacket playerMessagePacket(MessageType messageType, Object ... items) {
        try {
            ByteBuf output = Unpooled.buffer();
            messageType.write(output);
            this.writeObjects(output, items);
            return FzNetDispatch.generate(output);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void prefixEntityPacket(ByteBuf output, Entity to, MessageType messageType) throws IOException {
        messageType.write(output);
        output.writeInt(to.func_145782_y());
    }

    public FMLProxyPacket entityPacket(ByteBuf output) throws IOException {
        return FzNetDispatch.generate(output);
    }

    public FMLProxyPacket entityPacket(Entity to, MessageType messageType, Object ... items) {
        try {
            ByteBuf output = Unpooled.buffer();
            this.prefixEntityPacket(output, to, messageType);
            this.writeObjects(output, items);
            return this.entityPacket(output);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void sendCommand(EntityPlayer player, Command cmd, int arg) {
        ByteBuf out = Unpooled.buffer();
        MessageType.factorizeCmdChannel.write(out);
        out.writeByte((int)cmd.id);
        out.writeInt(arg);
        FzNetDispatch.addPacket(FzNetDispatch.generate(out), player);
    }

    public void sendPlayerMessage(EntityPlayer player, MessageType messageType, Object ... msg) {
        FzNetDispatch.addPacket(this.playerMessagePacket(messageType, msg), player);
    }

    public void broadcastMessage(EntityPlayer who, Coord src, MessageType messageType, Object ... msg) {
        if (who != null) {
            FMLProxyPacket toSend = this.TEmessagePacket(src, messageType, msg);
            FzNetDispatch.addPacket(toSend, who);
        } else {
            FMLProxyPacket toSend = this.TEmessagePacket(src, messageType, msg);
            FzNetDispatch.addPacketFrom((Packet)toSend, src);
        }
    }

    public void broadcastPacket(EntityPlayer who, Coord src, FMLProxyPacket toSend) {
        if (who != null) {
            FzNetDispatch.addPacket(toSend, who);
        } else {
            FzNetDispatch.addPacketFrom((Packet)toSend, src);
        }
    }

    void handleTE(ByteBuf input, MessageType messageType, EntityPlayer player) {
        try {
            World world = player.field_70170_p;
            int x = input.readInt();
            int y = input.readInt();
            int z = input.readInt();
            Coord here = new Coord(world, x, y, z);
            if (!here.blockExists() && world.field_72995_K) {
                return;
            }
            if (messageType == MessageType.DescriptionRequest && !world.field_72995_K) {
                TileEntityCommon tec = here.getTE(TileEntityCommon.class);
                if (tec != null) {
                    FzNetDispatch.addPacket(tec.getDescriptionPacket(), player);
                }
                return;
            }
            if (messageType == MessageType.RedrawOnClient && world.field_72995_K) {
                world.func_147471_g(x, y, z);
                return;
            }
            if (messageType == MessageType.FactoryType && world.field_72995_K) {
                byte ftId = input.readByte();
                FactoryType ft = FactoryType.fromMd(ftId);
                if (ft == null) {
                    Core.logSevere("Got invalid FactoryType ID %s", ftId);
                    return;
                }
                TileEntityCommon spawn = here.getTE(TileEntityCommon.class);
                if (spawn != null && spawn.getFactoryType() != ft) {
                    world.func_147475_p(x, y, z);
                    spawn = null;
                }
                if (spawn == null) {
                    spawn = ft.makeTileEntity();
                    if (spawn == null) {
                        Core.logSevere("Tried to spawn FactoryType with no associated TE %s", new Object[]{ft});
                        return;
                    }
                    spawn.func_145834_a(world);
                    world.func_147455_a(x, y, z, (TileEntity)spawn);
                }
                DataInByteBuf data = new DataInByteBuf(input, Side.CLIENT);
                spawn.putData(data);
                spawn.spawnPacketReceived();
                if (spawn.redrawOnSync()) {
                    here.redraw();
                }
                return;
            }
            if (messageType == null) {
                return;
            }
            TileEntityCommon tec = here.getTE(TileEntityCommon.class);
            if (tec == null) {
                this.handleForeignMessage(world, x, y, z, tec, messageType, input);
                return;
            }
            boolean handled = here.w.field_72995_K ? tec.handleMessageFromServer(messageType, input) : tec.handleMessageFromClient(messageType, input);
            if (!handled) {
                this.handleForeignMessage(world, x, y, z, tec, messageType, input);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void handleForeignMessage(World world, int x, int y, int z, TileEntity ent, MessageType messageType, ByteBuf input) throws IOException {
        if (world.field_72995_K) {
            Coord here = new Coord(world, x, y, z);
            switch (messageType) {
                case PlaySound: {
                    Sound.receive(here, input);
                    break;
                }
                default: {
                    if (here.blockExists()) break;
                    Core.logFine("Got message to unloaded chunk: " + (Object)((Object)messageType) + " for " + here, new Object[0]);
                }
            }
        }
    }

    boolean handleForeignEntityMessage(Entity ent, MessageType messageType, ByteBuf input) throws IOException {
        if (messageType == MessageType.EntityParticles) {
            Random rand = new Random();
            double px = rand.nextGaussian() * 0.02;
            double py = rand.nextGaussian() * 0.02;
            double pz = rand.nextGaussian() * 0.02;
            int count = input.readByte();
            String type = ByteBufUtils.readUTF8String((ByteBuf)input);
            for (int i = 0; i < count; ++i) {
                ent.field_70170_p.func_72869_a(type, ent.field_70165_t + (double)(rand.nextFloat() * ent.field_70130_N) * 2.0 - (double)ent.field_70130_N, ent.field_70163_u + 0.5 + (double)(rand.nextFloat() * ent.field_70131_O), ent.field_70161_v + (double)(rand.nextFloat() * ent.field_70130_N) * 2.0 - (double)ent.field_70130_N, px, py, pz);
            }
            return true;
        }
        if (messageType == MessageType.UtilityGooState) {
            ItemGoo.handlePacket(input);
            return true;
        }
        return false;
    }

    void handleCmd(ByteBuf data, EntityPlayer player) {
        byte s = data.readByte();
        int arg = data.readInt();
        Command.fromNetwork(player, s, arg);
    }

    void handleEntity(MessageType messageType, ByteBuf input, EntityPlayer player) {
        try {
            World world = player.field_70170_p;
            int entityId = input.readInt();
            Entity to = world.func_73045_a(entityId);
            if (to == null) {
                if (Core.dev_environ) {
                    Core.logFine("Packet to unknown entity #%s: %s", new Object[]{entityId, messageType});
                }
                return;
            }
            if (!(to instanceof IEntityMessage)) {
                if (!player.field_70170_p.field_72995_K) {
                    Core.logSevere("Sending the server messages to non-IEntityMessages is not allowed, %s!", player);
                    return;
                }
                if (!this.handleForeignEntityMessage(to, messageType, input)) {
                    Core.logFine("Packet to inappropriate entity #%s: %s", new Object[]{entityId, messageType});
                }
                return;
            }
            IEntityMessage iem = (IEntityMessage)to;
            boolean handled = world.field_72995_K ? iem.handleMessageFromServer(messageType, input) : iem.handleMessageFromClient(messageType, input);
            if (!handled && !this.handleForeignEntityMessage(to, messageType, input)) {
                Core.logFine("Got unhandled message: " + (Object)((Object)messageType) + " for " + iem, new Object[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void handlePlayer(MessageType mt, ByteBuf input, EntityPlayer player) {
        if (mt == MessageType.ArtifactForgeName) {
            String name = ByteBufUtils.readUTF8String((ByteBuf)input);
            String lore = ByteBufUtils.readUTF8String((ByteBuf)input);
            if (player.field_71070_bA instanceof ContainerForge) {
                ContainerForge forge = (ContainerForge)player.field_71070_bA;
                forge.forge.name = name;
                forge.forge.lore = lore;
                forge.forge.func_70296_d();
                forge.func_75142_b();
            }
        } else if (mt == MessageType.ArtifactForgeError) {
            String err = ByteBufUtils.readUTF8String((ByteBuf)input);
            if (player.field_71070_bA instanceof ContainerForge) {
                ContainerForge forge = (ContainerForge)player.field_71070_bA;
                forge.forge.error_message = err;
                input.readBytes(forge.forge.warnings);
            }
        }
    }

    public static ItemStack nullItem(ItemStack is) {
        return is == null ? EMPTY_ITEMSTACK : is;
    }

    public static ItemStack denullItem(ItemStack is) {
        if (is == null) {
            return null;
        }
        if (DataUtil.getId(is) == DataUtil.getId(Blocks.field_150350_a)) {
            return null;
        }
        return is;
    }

    static /* synthetic */ byte access$008() {
        byte by = message_type_count;
        message_type_count = (byte)(by + 1);
        return by;
    }

    public static enum MessageType {
        factorizeCmdChannel,
        PlaySound,
        EntityParticles(true),
        DrawActive,
        FactoryType,
        DescriptionRequest,
        DataHelperEdit,
        RedrawOnClient,
        DataHelperEditOnEntity(true),
        OpenDataHelperGui,
        OpenDataHelperGuiOnEntity(true),
        TileEntityMessageOnEntity(true),
        BarrelDescription,
        BarrelItem,
        BarrelCount,
        BarrelDoubleClickHack,
        BatteryLevel,
        LeydenjarLevel,
        MirrorDescription,
        TurbineWater,
        TurbineSpeed,
        HeaterHeat,
        LaceratorSpeed,
        MixerSpeed,
        FanturpellerSpeed,
        CrystallizerInfo,
        WireFace,
        SculptDescription,
        SculptNew,
        SculptMove,
        SculptRemove,
        SculptState,
        ExtensionInfo,
        RocketState,
        ServoRailDecor,
        ServoRailEditComment,
        CompressionCrafter,
        CompressionCrafterBeginCrafting,
        CompressionCrafterBounds,
        ScissorState,
        GeneratorParticles,
        BoilerHeat,
        ShaftGenState,
        MillVelocity,
        MisanthropicSpawn,
        MisanthropicCharge,
        servo_brief(true),
        servo_item(true),
        servo_complete(true),
        servo_stopped(true),
        entity_sync(true),
        UtilityGooState(true),
        ArtifactForgeName(false, true),
        ArtifactForgeError(false, true);

        public boolean isEntityMessage;
        public boolean isPlayerMessage;
        private static final MessageType[] valuesCache;
        private final byte id = NetworkFactorization.access$008();

        private MessageType() {
            this(false, false);
        }

        private MessageType(boolean isEntity, boolean isPlayer) {
            if (this.id < 0) {
                throw new IllegalArgumentException("Too many message types!");
            }
            this.isEntityMessage = isEntity;
            this.isPlayerMessage = isPlayer;
        }

        private MessageType(boolean isEntity) {
            this(true, false);
        }

        private static MessageType fromId(byte id) {
            if (id < 0 || id >= valuesCache.length) {
                return null;
            }
            return valuesCache[id];
        }

        public static MessageType read(ByteBuf in) {
            byte b = in.readByte();
            return MessageType.fromId(b);
        }

        public void write(ByteBuf out) {
            out.writeByte((int)this.id);
        }

        static {
            valuesCache = MessageType.values();
        }
    }
}

