/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import factorization.api.Quaternion;
import factorization.shared.Core;
import factorization.util.SpaceUtil;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelFormatException;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.lwjgl.opengl.GL11;

public class ObjectModel {
    private final ResourceLocation modelLocation;
    private int render_list = -1;
    private WavefrontObject isbrh_model = null;
    public static final double modelScale = 0.0625;

    public ObjectModel(ResourceLocation modelLocation) {
        this.modelLocation = modelLocation;
        Core.loadBus(this);
    }

    public void render(IIcon icon) {
        WavefrontObject model;
        if (this.render_list == 0) {
            return;
        }
        if (this.render_list == -1 && (model = this.readModel()) != null) {
            this.recordModel(model, icon);
        }
        GL11.glCallList((int)this.render_list);
    }

    public boolean renderISBRH(RenderBlocks rb, IIcon icon, Block block, int x, int y, int z) {
        if (this.isbrh_model == null) {
            this.isbrh_model = this.readModel();
        }
        if (this.isbrh_model == null) {
            return false;
        }
        if (rb.field_147840_d != null) {
            icon = rb.field_147840_d;
        }
        Tessellator.field_78398_a.func_78376_a(255, 255, 255);
        int brightness = block.func_149677_c(rb.field_147845_a, x, y, z);
        Tessellator.field_78398_a.func_78380_c(brightness);
        ModelTessellator tess = new ModelTessellator(icon);
        tess.func_78373_b((double)x + 0.5, y, (double)z + 0.5);
        this.isbrh_model.tessellateAll((Tessellator)tess);
        return true;
    }

    public boolean renderBrightISBRH(RenderBlocks rb, IIcon icon, Block block, int x, int y, int z) {
        if (this.isbrh_model == null) {
            this.isbrh_model = this.readModel();
        }
        if (this.isbrh_model == null) {
            return false;
        }
        if (rb.field_147840_d != null) {
            icon = rb.field_147840_d;
        }
        Tessellator.field_78398_a.func_78376_a(255, 255, 255);
        Tessellator.field_78398_a.func_78380_c(0xF000F0);
        ModelTessellator tess = new ModelTessellator(icon);
        tess.func_78373_b((double)x + 0.5, y, (double)z + 0.5);
        this.isbrh_model.tessellateAll((Tessellator)tess);
        return true;
    }

    public boolean renderRotatedISBRH(RenderBlocks rb, IIcon icon, Block block, int x, int y, int z, Quaternion quat) {
        if (this.isbrh_model == null) {
            this.isbrh_model = this.readModel();
        }
        if (this.isbrh_model == null) {
            return false;
        }
        if (rb.field_147840_d != null) {
            icon = rb.field_147840_d;
        }
        Tessellator.field_78398_a.func_78376_a(255, 255, 255);
        int brightness = block.func_149677_c(rb.field_147845_a, x, y, z);
        Tessellator.field_78398_a.func_78380_c(brightness);
        RotatedModelTessellator tess = new RotatedModelTessellator(icon, quat);
        tess.func_78373_b((double)x + 0.5, y, (double)z + 0.5);
        this.isbrh_model.tessellateAll((Tessellator)tess);
        return true;
    }

    public void render() {
        WavefrontObject model;
        if (this.render_list == 0) {
            return;
        }
        if (this.render_list == -1 && (model = this.readModel()) != null) {
            this.recordModel(model);
        }
        GL11.glCallList((int)this.render_list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WavefrontObject readModel() {
        WavefrontObject objectModel = null;
        try {
            InputStream input = null;
            try {
                input = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.modelLocation).func_110527_b();
                if (input == null) {
                    Core.logWarning("Missing 3D model: " + this.modelLocation, new Object[0]);
                    this.render_list = 0;
                    WavefrontObject wavefrontObject = null;
                    return wavefrontObject;
                }
                objectModel = new WavefrontObject(this.modelLocation.toString(), input);
                input.close();
                input = null;
                return objectModel;
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (IOException e) {
            Core.logWarning("Failed to load model %s", this.modelLocation);
            e.printStackTrace();
            return null;
        }
        catch (ModelFormatException e) {
            Core.logWarning("Failed to load model %s", this.modelLocation);
            e.printStackTrace();
            return null;
        }
    }

    private void recordModel(WavefrontObject objectModel, final IIcon icon) {
        if (objectModel == null) {
            return;
        }
        Tessellator subsetTessellator = new Tessellator(){

            public void func_78385_a(double u, double v) {
                super.func_78385_a((double)icon.func_94214_a(u * 16.0), (double)icon.func_94207_b(v * 16.0));
            }
        };
        this.render_list = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)this.render_list, (int)4864);
        GL11.glScaled((double)0.0625, (double)0.0625, (double)0.0625);
        subsetTessellator.func_78382_b();
        objectModel.tessellateAll(subsetTessellator);
        subsetTessellator.func_78381_a();
        double s = 16.0;
        GL11.glScaled((double)s, (double)s, (double)s);
        GL11.glEndList();
    }

    private void recordModel(WavefrontObject objectModel) {
        this.render_list = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)this.render_list, (int)4864);
        double modelScale = 0.0625;
        GL11.glScaled((double)modelScale, (double)modelScale, (double)modelScale);
        Tessellator.field_78398_a.func_78382_b();
        objectModel.tessellateAll(Tessellator.field_78398_a);
        Tessellator.field_78398_a.func_78381_a();
        modelScale = 1.0 / modelScale;
        GL11.glScaled((double)modelScale, (double)modelScale, (double)modelScale);
        GL11.glEndList();
    }

    @SubscribeEvent
    public void resourcePackChanged(TextureStitchEvent.Post event) {
        if (this.render_list != -1 && this.render_list != 0) {
            GLAllocation.func_74523_b((int)this.render_list);
        }
        this.render_list = -1;
        this.isbrh_model = null;
    }

    private static class RotatedModelTessellator
    extends Tessellator {
        final IIcon icon;
        final Quaternion quat;
        final Vec3 vec = SpaceUtil.newVec();

        private RotatedModelTessellator(IIcon icon, Quaternion quat) {
            this.icon = icon;
            this.quat = quat;
        }

        public void func_78385_a(double u, double v) {
            Tessellator.field_78398_a.func_78385_a((double)this.icon.func_94214_a(u * 16.0), (double)this.icon.func_94207_b(v * 16.0));
        }

        public void func_78377_a(double x, double y, double z) {
            this.vec.field_72450_a = x;
            this.vec.field_72448_b = y;
            this.vec.field_72449_c = z;
            this.quat.applyRotation(this.vec);
            Tessellator.field_78398_a.func_78377_a(this.vec.field_72450_a * 0.0625 + this.field_78408_v, this.vec.field_72448_b * 0.0625 + this.field_78407_w, this.vec.field_72449_c * 0.0625 + this.field_78417_x);
        }

        public void func_78375_b(float x, float y, float z) {
            this.vec.field_72450_a = x;
            this.vec.field_72448_b = y;
            this.vec.field_72449_c = z;
            this.quat.applyRotation(this.vec);
            Tessellator.field_78398_a.func_78375_b((float)this.vec.field_72450_a, (float)this.vec.field_72448_b, (float)this.vec.field_72449_c);
        }
    }

    private static class ModelTessellator
    extends Tessellator {
        final IIcon icon;

        private ModelTessellator(IIcon icon) {
            this.icon = icon;
        }

        public void func_78385_a(double u, double v) {
            Tessellator.field_78398_a.func_78385_a((double)this.icon.func_94214_a(u * 16.0), (double)this.icon.func_94207_b(v * 16.0));
        }

        public void func_78377_a(double x, double y, double z) {
            Tessellator.field_78398_a.func_78377_a(x * 0.0625 + this.field_78408_v, y * 0.0625 + this.field_78407_w, z * 0.0625 + this.field_78417_x);
        }

        public void func_78375_b(float x, float y, float z) {
            Tessellator.field_78398_a.func_78375_b(x, y, z);
        }
    }
}

