/*
 * Decompiled with CFR 0.152.
 */
package factorization.shared;

import factorization.api.Coord;
import factorization.api.ICoord;
import factorization.api.IFactoryType;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.common.FactoryType;
import factorization.shared.NetworkFactorization;
import factorization.shared.TileEntityCommon;
import factorization.util.InvUtil;
import factorization.util.ItemUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class TileEntityFactorization
extends TileEntityCommon
implements IInventory,
ISidedInventory,
ICoord,
IFactoryType {
    public byte draw_active;
    public byte facing_direction = (byte)3;
    protected transient boolean need_logic_check = true;

    @Override
    public abstract FactoryType getFactoryType();

    protected void makeNoise() {
    }

    protected abstract void doLogic();

    protected int getLogicSpeed() {
        return 4;
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side, float hitX, float hitY, float hitZ) {
        super.onPlacedBy(player, is, side, hitX, hitY, hitZ);
        if (player == null) {
            return;
        }
        this.facing_direction = (byte)side;
    }

    protected void needLogic() {
        this.need_logic_check = true;
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        this.dropContents();
    }

    public void dropContents() {
        Coord here = this.getCoord();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            InvUtil.spawnItemStack(here, this.func_70301_a(i));
        }
    }

    public ItemStack func_70298_a(int i, int amount) {
        ItemStack target = ItemUtil.normalize(this.func_70301_a(i));
        if (target == null) {
            return null;
        }
        if (target.field_77994_a <= amount) {
            this.func_70299_a(i, null);
            return target;
        }
        ItemStack ret = target.func_77979_a(amount);
        if (target.field_77994_a == 0) {
            this.func_70299_a(i, null);
        }
        return ret;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.needLogic();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return 64.0 >= player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
    }

    public final void func_70295_k_() {
    }

    public final void func_70305_f() {
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        this.draw_active = data.as(Share.VISIBLE, "draw_active_byte").putByte(this.draw_active);
        this.facing_direction = data.as(Share.VISIBLE, "facing").putByte(this.facing_direction);
    }

    public final void putSlots(DataHelper data) {
        if (!data.isNBT()) {
            return;
        }
        NBTTagCompound tag = data.getTag();
        if (data.isWriter()) {
            this.writeSlotsToNBT(tag);
        } else {
            this.readSlotsFromNBT(tag);
        }
    }

    private void readSlotsFromNBT(NBTTagCompound tag) {
        NBTTagList invlist = tag.func_150295_c("Items", 10);
        for (int i = 0; i < invlist.func_74745_c(); ++i) {
            NBTTagCompound comp = invlist.func_150305_b(i);
            this.func_70299_a(comp.func_74762_e("Slot"), ItemStack.func_77949_a((NBTTagCompound)comp));
        }
    }

    private void writeSlotsToNBT(NBTTagCompound tag) {
        NBTTagList invlist = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            NBTTagCompound comp = new NBTTagCompound();
            comp.func_74768_a("Slot", i);
            stack.func_77955_b(comp);
            invlist.func_74742_a((NBTBase)comp);
        }
        tag.func_74782_a("Items", (NBTBase)invlist);
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return true;
    }

    public void drawActive(int add_time) {
        int new_active = this.draw_active + add_time;
        if (new_active < 0) {
            new_active = 0;
        }
        if (new_active > 32) {
            new_active = 32;
        }
        if (this.draw_active != new_active) {
            this.draw_active = (byte)new_active;
            if (!this.field_145850_b.field_72995_K) {
                this.broadcastMessage(null, NetworkFactorization.MessageType.DrawActive, this.draw_active);
            }
        }
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            if (this.draw_active > 0) {
                this.makeNoise();
                this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.draw_active = (byte)(this.draw_active - 1);
            }
        } else {
            byte by = this.draw_active = this.draw_active > 0 ? (byte)(this.draw_active - 1) : (byte)0;
            if (this.need_logic_check && 0L == this.field_145850_b.func_82737_E() % (long)this.getLogicSpeed()) {
                this.need_logic_check = false;
                this.doLogic();
            }
        }
    }

    @Override
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.DrawActive) {
            this.draw_active = input.readByte();
            this.getCoord().redraw();
            return true;
        }
        return false;
    }
}

