/*
 * Decompiled with CFR 0.152.
 */
package factorization.sockets;

import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.Quaternion;
import factorization.fzds.DeltaChunk;
import factorization.fzds.HammerEnabled;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.servo.TileEntityServoRail;
import factorization.sockets.ISocketHolder;
import factorization.sockets.TileEntitySocketBase;
import factorization.util.SpaceUtil;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class RayTracer {
    final TileEntitySocketBase base;
    final ISocketHolder socket;
    final Coord trueCoord;
    final FzOrientation trueOrientation;
    final boolean powered;
    boolean lookAround = false;
    boolean onlyFirstBlock = false;
    boolean checkEnts = false;
    boolean checkFzds = true;
    boolean checkFzdsFirst = false;
    boolean fzdsMovesTe = true;
    AxisAlignedBB entBox = null;
    boolean fzdsPass = false;

    public RayTracer(TileEntitySocketBase base, ISocketHolder socket, Coord at, FzOrientation orientation, boolean powered) {
        this.base = base;
        this.socket = socket;
        this.trueCoord = at;
        this.trueOrientation = orientation;
        this.powered = powered;
    }

    public RayTracer onlyFrontBlock() {
        this.onlyFirstBlock = true;
        return this;
    }

    public RayTracer lookAround() {
        this.lookAround = true;
        return this;
    }

    public RayTracer checkEnts() {
        this.checkEnts = true;
        return this;
    }

    public RayTracer checkFzdsFirst() {
        this.checkFzdsFirst = true;
        this.checkFzds = false;
        return this;
    }

    boolean checkReal() {
        this.fzdsPass = false;
        return this.runPass(this.trueOrientation, this.trueCoord, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkFzds() {
        if (!HammerEnabled.ENABLED) {
            return false;
        }
        this.fzdsPass = true;
        if (this.trueCoord.w != DeltaChunk.getServerShadowWorld()) {
            return false;
        }
        Coord shadowBaseLocation = new Coord(this.base);
        for (IDeltaChunk idc : DeltaChunk.getSlicesContainingPoint(this.trueCoord)) {
            FzOrientation orientation = this.shadowOrientation(idc);
            if (orientation == FzOrientation.UNKNOWN) continue;
            Coord at = new Coord(this.base);
            Vec3 v = SpaceUtil.newVec();
            at.setAsVector(v);
            v.field_72450_a += 0.5 + (double)this.trueOrientation.top.offsetX;
            v.field_72448_b += 0.5 + (double)this.trueOrientation.top.offsetY;
            v.field_72449_c += 0.5 + (double)this.trueOrientation.top.offsetZ;
            v = idc.shadow2real(v);
            idc.shadow2real(at);
            AxisAlignedBB box = SpaceUtil.createAABB(v, v);
            box.field_72338_b += 2.0;
            double x = v.field_72450_a;
            double y = v.field_72448_b;
            double z = v.field_72449_c;
            Coord target = new Coord(at.w, (int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
            target.adjust(orientation.facing.getOpposite());
            orientation = orientation.getSwapped();
            try {
                if (this.fzdsMovesTe) {
                    target.setAsTileEntityLocation(this.base);
                }
                if (!this.runPass(orientation, target, idc)) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                if (this.fzdsMovesTe) {
                    shadowBaseLocation.setAsTileEntityLocation(this.base);
                }
            }
        }
        return false;
    }

    public boolean trace() {
        if (this.checkFzdsFirst && this.checkFzds()) {
            return true;
        }
        this.entBox = null;
        if (this.checkReal()) {
            return true;
        }
        this.entBox = null;
        return this.checkFzds && this.checkFzds();
    }

    FzOrientation shadowOrientation(IDeltaChunk idc) {
        Quaternion rot = idc.getRotation();
        Vec3 topVec = SpaceUtil.fromDirection(this.trueOrientation.top);
        Vec3 faceVec = SpaceUtil.fromDirection(this.trueOrientation.facing);
        rot.applyRotation(topVec);
        rot.applyRotation(faceVec);
        ForgeDirection top = SpaceUtil.round(topVec, ForgeDirection.UNKNOWN);
        ForgeDirection facing = SpaceUtil.round(faceVec, top);
        FzOrientation to = FzOrientation.fromDirection(top);
        if (to == FzOrientation.UNKNOWN) {
            return FzOrientation.fromDirection(facing);
        }
        FzOrientation tofo = to.pointTopTo(facing);
        if (tofo == FzOrientation.UNKNOWN) {
            return to;
        }
        return tofo;
    }

    boolean runPass(FzOrientation orientation, Coord coord, IDeltaChunk idc) {
        Coord targetBlock;
        ForgeDirection top = orientation.top;
        ForgeDirection face = orientation.facing;
        ForgeDirection right = face.getRotation(top);
        if (this.checkEnts) {
            if (this.entBox == null) {
                this.entBox = this.base.getEntityBox(this.socket, coord, top, 0.0);
                if (idc != null) {
                    this.entBox = idc.shadow2real(this.entBox);
                }
            }
            for (Entity entity : this.getEntities(coord, top, idc)) {
                if (entity == this.socket || !this.base.handleRay(this.socket, new MovingObjectPosition(entity), coord.w, false, this.powered)) continue;
                return true;
            }
        }
        if (this.mopBlock(targetBlock = coord.add(top), top.getOpposite())) {
            return true;
        }
        if (this.onlyFirstBlock) {
            return false;
        }
        if (this.mopBlock(targetBlock.add(top), top.getOpposite())) {
            return true;
        }
        if (this.mopBlock(coord, top)) {
            return true;
        }
        if (!this.lookAround) {
            return false;
        }
        if (this.mopBlock(targetBlock.add(face), face.getOpposite())) {
            return true;
        }
        if (this.mopBlock(targetBlock.add(face.getOpposite()), face)) {
            return true;
        }
        if (this.mopBlock(targetBlock.add(right), right.getOpposite())) {
            return true;
        }
        return this.mopBlock(targetBlock.add(right.getOpposite()), right);
    }

    boolean mopBlock(Coord target, ForgeDirection side) {
        if (this.base != this.socket && target.getTE(TileEntityServoRail.class) != null) {
            return false;
        }
        boolean isThis = this.base == this.socket && target.isAt(this.base);
        Vec3 hitVec = Vec3.func_72443_a((double)(this.base.field_145851_c + side.offsetX), (double)(this.base.field_145848_d + side.offsetY), (double)(this.base.field_145849_e + side.offsetZ));
        return this.base.handleRay(this.socket, target.createMop(side, hitVec), target.w, isThis, this.powered);
    }

    Iterable<Entity> getEntities(Coord coord, ForgeDirection top, IDeltaChunk idc) {
        if (idc == null) {
            Entity ent = null;
            if (this.socket instanceof Entity) {
                ent = (Entity)this.socket;
            }
            return coord.w.func_72839_b(ent, this.entBox);
        }
        Vec3 min = SpaceUtil.newVec();
        Vec3 max = SpaceUtil.newVec();
        SpaceUtil.setMin(this.entBox, min);
        SpaceUtil.setMax(this.entBox, max);
        AxisAlignedBB realBox = SpaceUtil.newBox();
        SpaceUtil.setMin(this.entBox, idc.shadow2real(min));
        SpaceUtil.setMax(this.entBox, idc.shadow2real(max));
        return coord.w.func_72839_b(null, realBox);
    }
}

