/*
 * Decompiled with CFR 0.152.
 */
package factorization.sockets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.IChargeConductor;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.DataInByteBuf;
import factorization.api.datahelpers.DataInByteBufClientEdited;
import factorization.api.datahelpers.DataOutByteBuf;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.common.FzConfig;
import factorization.notify.Notice;
import factorization.servo.LoggerDataHelper;
import factorization.servo.RenderServoMotor;
import factorization.servo.ServoMotor;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.FzNetDispatch;
import factorization.shared.NetworkFactorization;
import factorization.shared.Sound;
import factorization.shared.TileEntityCommon;
import factorization.sockets.GuiDataConfig;
import factorization.sockets.ISocketHolder;
import factorization.sockets.SocketEmpty;
import factorization.util.FzUtil;
import factorization.util.InvUtil;
import factorization.util.ItemUtil;
import factorization.util.PlayerUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public abstract class TileEntitySocketBase
extends TileEntityCommon
implements ISocketHolder,
IDataSerializable {
    public ForgeDirection facing = ForgeDirection.UP;
    protected ItemStack[] parts = new ItemStack[3];
    private static float[] pitch = new float[]{90.0f, -90.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    private static float[] yaw = new float[]{0.0f, 0.0f, 180.0f, 0.0f, 90.0f, -90.0f, 0.0f};

    @Override
    public final BlockClass getBlockClass() {
        return BlockClass.Socket;
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side, float hitX, float hitY, float hitZ) {
        super.onPlacedBy(player, is, side, hitX, hitY, hitZ);
        this.facing = ForgeDirection.getOrientation((int)side);
    }

    public void migrate1to2() {
        FactoryType ft;
        ArrayList<ItemStack> legacyParts = new ArrayList<ItemStack>(3);
        TileEntitySocketBase self = this;
        do {
            legacyParts.add(self.getCreatingItem());
        } while ((ft = self.getParentFactoryType()) != null && (self = (TileEntitySocketBase)ft.getRepresentative()) != null);
        Collections.reverse(legacyParts);
        for (int i = 0; i < legacyParts.size(); ++i) {
            this.parts[i] = (ItemStack)legacyParts.get(i);
        }
    }

    @Override
    public final void putData(DataHelper data) throws IOException {
        this.facing = data.as(Share.VISIBLE, "fc").putEnum(this.facing);
        this.parts = data.as(Share.PRIVATE, "socketParts").putItemArray(this.parts);
        this.serialize("", data);
    }

    public boolean sanitize(ServoMotor motor) {
        LoggerDataHelper dh = new LoggerDataHelper(motor);
        try {
            this.serialize("", dh);
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
        return dh.hadError;
    }

    protected AxisAlignedBB getEntityBox(ISocketHolder socket, Coord c, ForgeDirection top, double d) {
        int one = 1;
        AxisAlignedBB ab = AxisAlignedBB.func_72330_a((double)(c.x + top.offsetX), (double)(c.y + top.offsetY), (double)(c.z + top.offsetZ), (double)(c.x + one + top.offsetX), (double)(c.y + one + top.offsetY), (double)(c.z + one + top.offsetZ));
        if (d != 0.0) {
            ab.field_72340_a -= d;
            ab.field_72338_b -= d;
            ab.field_72339_c -= d;
            ab.field_72336_d += d - d * (double)top.offsetX;
            ab.field_72337_e += d - d * (double)top.offsetY;
            ab.field_72334_f += d - d * (double)top.offsetZ;
        }
        return ab;
    }

    @Override
    public final ForgeDirection[] getValidRotations() {
        return full_rotation_array;
    }

    @Override
    public final boolean rotate(ForgeDirection axis) {
        if (this.getClass() != SocketEmpty.class) {
            return false;
        }
        if (axis == this.facing) {
            return false;
        }
        this.facing = axis;
        return true;
    }

    @Override
    public boolean isBlockSolidOnSide(int side) {
        return side == this.facing.getOpposite().ordinal();
    }

    @Override
    public final void sendMessage(NetworkFactorization.MessageType msgType, Object ... msg) {
        this.broadcastMessage(null, msgType, msg);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ForgeDirection dir) {
        if (dir == this.facing || dir.getOpposite() == this.facing) {
            return BlockIcons.socket$face;
        }
        return BlockIcons.socket$side;
    }

    protected boolean isBlockPowered() {
        if (FzConfig.sockets_ignore_front_redstone) {
            for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
                if (fd == this.facing || this.field_145850_b.func_72878_l(this.field_145851_c + fd.offsetX, this.field_145848_d + fd.offsetY, this.field_145849_e + fd.offsetZ, fd.ordinal()) <= 0) continue;
                return true;
            }
            return false;
        }
        return this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0;
    }

    @Override
    public boolean dumpBuffer(List<ItemStack> buffer) {
        if (buffer.size() == 0) {
            return false;
        }
        ItemStack is = buffer.get(0);
        if (is == null) {
            buffer.remove(0);
            return true;
        }
        Coord here = this.getCoord();
        here.adjust(this.facing.getOpposite());
        IInventory invTe = here.getTE(IInventory.class);
        if (invTe == null) {
            return true;
        }
        InvUtil.FzInv inv = InvUtil.openInventory(invTe, this.facing);
        if (inv == null) {
            return true;
        }
        int origSize = is.field_77994_a;
        int newSize = 0;
        if (inv.push(is) == null) {
            buffer.remove(0);
        } else {
            newSize = is.field_77994_a;
        }
        if (origSize != newSize) {
            this.func_70296_d();
        }
        return !buffer.isEmpty();
    }

    public void func_145845_h() {
        this.genericUpdate(this, this.getCoord(), this.isBlockPowered());
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        this.uninstall();
        FactoryType ft = this.getFactoryType();
        Coord at = this.getCoord();
        while (ft != null) {
            TileEntitySocketBase sb = (TileEntitySocketBase)ft.getRepresentative();
            ItemStack is = sb.getCreatingItem();
            if (is != null) {
                at.spawnItem(ItemStack.func_77944_b((ItemStack)is));
            }
            ft = sb.getParentFactoryType();
        }
    }

    @Override
    public ItemStack getPickedBlock() {
        if (this instanceof SocketEmpty) {
            return FactoryType.SOCKET_EMPTY.itemStack();
        }
        ItemStack is = this.getCreatingItem();
        return is == null ? null : ItemStack.func_77944_b((ItemStack)is);
    }

    @Override
    public ItemStack getDroppedBlock() {
        return FactoryType.SOCKET_EMPTY.itemStack();
    }

    protected EntityPlayer getFakePlayer() {
        int i;
        EntityPlayer player = PlayerUtil.makePlayer(this.getCoord(), "socket");
        player.field_70170_p = this.field_145850_b;
        player.field_70169_q = player.field_70165_t = (double)this.field_145851_c + 0.5 + (double)this.facing.offsetX;
        player.field_70167_r = player.field_70163_u = (double)this.field_145848_d + 0.5 - (double)player.func_70047_e() + (double)this.facing.offsetY;
        player.field_70166_s = player.field_70161_v = (double)this.field_145849_e + 0.5 + (double)this.facing.offsetZ;
        for (i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            player.field_71071_by.field_70462_a[i] = null;
        }
        i = this.facing.ordinal();
        player.field_70125_A = player.field_70127_C = pitch[i];
        player.field_70177_z = player.field_70126_B = yaw[i];
        player.field_70721_aZ = 0.0f;
        return player;
    }

    protected IInventory getBackingInventory(ISocketHolder socket) {
        if (socket == this) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c - this.facing.offsetX, this.field_145848_d - this.facing.offsetY, this.field_145849_e - this.facing.offsetZ);
            if (te instanceof IInventory) {
                return (IInventory)te;
            }
            return null;
        }
        if (socket instanceof IInventory) {
            return (IInventory)socket;
        }
        return null;
    }

    @Override
    public boolean extractCharge(int amount) {
        if (this instanceof IChargeConductor) {
            IChargeConductor cc = (IChargeConductor)((Object)this);
            return cc.getCharge().tryTake(amount) >= amount;
        }
        return false;
    }

    @Override
    public Vec3 getPos() {
        return this.getCoord().createVector();
    }

    public void genericUpdate(ISocketHolder socket, Coord coord, boolean powered) {
    }

    @Override
    public abstract FactoryType getFactoryType();

    public abstract ItemStack getCreatingItem();

    public abstract FactoryType getParentFactoryType();

    public abstract boolean canUpdate();

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.OpenDataHelperGui) {
            if (!this.field_145850_b.field_72995_K) {
                return false;
            }
            DataInByteBuf dip = new DataInByteBuf(input, Side.CLIENT);
            this.serialize("", dip);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiDataConfig(this));
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMessageFromClient(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (super.handleMessageFromClient(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.DataHelperEdit) {
            DataInByteBufClientEdited di = new DataInByteBufClientEdited(input);
            this.serialize("", di);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean handleRay(ISocketHolder socket, MovingObjectPosition mop, World mopWorld, boolean mopIsThis, boolean powered) {
        return true;
    }

    public void uninstall() {
    }

    @Override
    public boolean activate(EntityPlayer player, ForgeDirection side) {
        ItemStack held = player.func_70694_bm();
        if (held != null && held.func_77973_b() == Core.registry.logicMatrixProgrammer) {
            if (!this.getFactoryType().hasGui) {
                if (this.getClass() == SocketEmpty.class) {
                    this.facing = (ForgeDirection)FzUtil.shiftEnum((Enum)this.facing, (Enum[])ForgeDirection.VALID_DIRECTIONS, (int)1);
                    if (this.field_145850_b.field_72995_K) {
                        new Coord(this).redraw();
                    }
                    return true;
                }
                return false;
            }
            if (this.field_145850_b.field_72995_K) {
                return true;
            }
            ByteBuf buf = Unpooled.buffer();
            DataOutByteBuf dop = new DataOutByteBuf(buf, Side.SERVER);
            try {
                Coord coord = this.getCoord();
                Core.network.prefixTePacket(buf, coord, NetworkFactorization.MessageType.OpenDataHelperGui);
                this.serialize("", dop);
                Core.network.broadcastPacket(player, coord, FzNetDispatch.generate(buf));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
        if (held != null) {
            boolean isValidItem = false;
            if (ItemUtil.identical(this.getCreatingItem(), held)) {
                return false;
            }
            for (FactoryType ft : FactoryType.values()) {
                TileEntitySocketBase rep;
                ItemStack creator;
                TileEntityCommon tec = ft.getRepresentative();
                if (tec == null || !(tec instanceof TileEntitySocketBase) || (creator = (rep = (TileEntitySocketBase)tec).getCreatingItem()) == null || !ItemUtil.couldMerge(held, creator)) continue;
                isValidItem = true;
                if (this.field_145850_b.field_72995_K) break;
                if (rep.getParentFactoryType() != this.getFactoryType()) {
                    rep.mentionPrereq(this, player);
                    return false;
                }
                TileEntityCommon upgrade = ft.makeTileEntity();
                if (upgrade == null) continue;
                this.replaceWith((TileEntitySocketBase)upgrade, this);
                if (!player.field_71075_bZ.field_75098_d) {
                    --held.field_77994_a;
                }
                Sound.socketInstall.playAt(this);
                return true;
            }
            if (isValidItem) {
                return false;
            }
        }
        return false;
    }

    public void mentionPrereq(ISocketHolder holder, EntityPlayer player) {
        FactoryType pft = this.getParentFactoryType();
        if (pft == null) {
            return;
        }
        TileEntityCommon tec = pft.getRepresentative();
        if (!(tec instanceof TileEntitySocketBase)) {
            return;
        }
        ItemStack is = ((TileEntitySocketBase)tec).getCreatingItem();
        if (is == null) {
            return;
        }
        String msg = "Needs {ITEM_NAME}";
        new Notice(holder, msg, new String[0]).withItem(is).send(player);
    }

    protected void replaceWith(TileEntitySocketBase replacement, ISocketHolder socket) {
        this.func_145843_s();
        replacement.facing = this.facing;
        if (socket == this) {
            Coord at = this.getCoord();
            at.setTE(replacement);
            replacement.getBlockClass().enforce(at);
            at.syncAndRedraw();
        } else if (socket instanceof ServoMotor) {
            ServoMotor motor = (ServoMotor)socket;
            motor.socket = replacement;
            motor.syncWithSpawnPacket();
        }
    }

    public boolean activateOnServo(EntityPlayer player, ServoMotor motor) {
        if (this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
            return false;
        }
        ItemStack held = player.func_70694_bm();
        if (held == null) {
            return false;
        }
        if (held.func_77973_b() != Core.registry.logicMatrixProgrammer) {
            return false;
        }
        if (!this.getFactoryType().hasGui) {
            return false;
        }
        ByteBuf buf = Unpooled.buffer();
        DataOutByteBuf dop = new DataOutByteBuf(buf, Side.SERVER);
        try {
            Coord coord = this.getCoord();
            Core.network.prefixEntityPacket(buf, motor, NetworkFactorization.MessageType.OpenDataHelperGuiOnEntity);
            this.serialize("", dop);
            Core.network.broadcastPacket(player, coord, Core.network.entityPacket(buf));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void onEnterNewBlock() {
    }

    @SideOnly(value=Side.CLIENT)
    public void renderTesr(ServoMotor motor, float partial) {
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(ServoMotor motor, Tessellator tess) {
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInServo(ServoMotor motor, float partial) {
        float s = 0.75f;
        GL11.glScalef((float)s, (float)s, (float)s);
        float d = -0.5f;
        float y = -0.125f;
        GL11.glTranslatef((float)d, (float)y, (float)d);
        GL11.glDisable((int)2896);
        GL11.glPushMatrix();
        this.renderTesr(motor, partial);
        GL11.glPopMatrix();
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        this.renderStatic(motor, tess);
        tess.func_78381_a();
        GL11.glTranslatef((float)(-d), (float)(-y), (float)(-d));
        GL11.glEnable((int)2896);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItemOnServo(RenderServoMotor render, ServoMotor motor, ItemStack is, float partial) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.40625f, (float)0.28125f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        render.renderItem(is);
        GL11.glPopMatrix();
    }

    public void installedOnServo(ServoMotor servoMotor) {
    }
}

