/*
 * Decompiled with CFR 0.152.
 */
package factorization.sockets.fanturpeller;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.IDataSerializable;
import factorization.api.datahelpers.Share;
import factorization.common.FactoryType;
import factorization.common.FzConfig;
import factorization.fzds.DeltaChunk;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.mechanics.MechanicsController;
import factorization.notify.Notice;
import factorization.servo.RenderServoMotor;
import factorization.servo.ServoMotor;
import factorization.shared.Core;
import factorization.sockets.ISocketHolder;
import factorization.sockets.fanturpeller.SocketFanturpeller;
import factorization.util.InvUtil;
import factorization.util.NumUtil;
import factorization.util.SpaceUtil;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class BlowEntities
extends SocketFanturpeller
implements IEntitySelector {
    short dropDelay = 0;
    ArrayList<ItemStack> buffer = new ArrayList(1);
    private AxisAlignedBB area = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    private AxisAlignedBB death_area = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    boolean found_player = false;

    @Override
    public String getInfo() {
        String msg = (this.isSucking ? "Suck" : "Blow") + " entities";
        if (!this.buffer.isEmpty()) {
            msg = msg + "\nBuffered output";
        }
        return msg;
    }

    @Override
    public IDataSerializable serialize(String prefix, DataHelper data) throws IOException {
        super.serialize(prefix, data);
        this.dropDelay = data.as(Share.PRIVATE, "dropDelay").putShort(this.dropDelay);
        this.buffer = data.as(Share.PRIVATE, "murderBuff").putItemList(this.buffer);
        return this;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.SOCKET_BLOWER;
    }

    @Override
    protected boolean shouldFeedJuice() {
        return this.buffer.isEmpty();
    }

    @Override
    int getRequiredCharge() {
        return 1 + this.target_speed * this.target_speed;
    }

    void addCoord(double x, double y, double z) {
        if (x < 0.0) {
            this.area.field_72340_a += x;
        }
        if (x > 0.0) {
            this.area.field_72336_d += x;
        }
        if (y < 0.0) {
            this.area.field_72338_b += y;
        }
        if (y > 0.0) {
            this.area.field_72337_e += y;
        }
        if (z < 0.0) {
            this.area.field_72339_c += z;
        }
        if (z > 0.0) {
            this.area.field_72334_f += z;
        }
    }

    @Override
    protected void fanturpellerUpdate(ISocketHolder socket, Coord coord, boolean powered) {
        if (powered) {
            return;
        }
        if (!this.shouldDoWork()) {
            return;
        }
        if (!this.isSucking && !this.field_145850_b.field_72995_K) {
            this.dropItems(coord, socket);
        }
        if (!this.field_145850_b.field_72995_K && socket.dumpBuffer(this.buffer)) {
            return;
        }
        if (socket == this) {
            coord.adjust(this.facing);
        }
        this.area.field_72340_a = this.death_area.field_72340_a = (double)coord.x;
        this.area.field_72338_b = this.death_area.field_72338_b = (double)coord.y;
        this.area.field_72339_c = this.death_area.field_72339_c = (double)coord.z;
        this.area.field_72336_d = this.death_area.field_72336_d = (double)(coord.x + 1);
        this.area.field_72337_e = this.death_area.field_72337_e = (double)(coord.y + 1);
        this.area.field_72334_f = this.death_area.field_72334_f = (double)(coord.z + 1);
        if (socket == this) {
            coord.adjust(this.facing.getOpposite());
        }
        byte side_range = this.target_speed;
        int front_range = 3 + this.target_speed * this.target_speed;
        if (this.isSucking) {
            ++front_range;
        }
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            if (forgeDirection == this.facing) {
                this.addCoord(forgeDirection.offsetX * front_range, forgeDirection.offsetY * front_range, forgeDirection.offsetZ * front_range);
                continue;
            }
            if (forgeDirection.getOpposite() == this.facing) continue;
            this.addCoord(forgeDirection.offsetX * side_range, forgeDirection.offsetY * side_range, forgeDirection.offsetZ * side_range);
        }
        double s = 0.025;
        ForgeDirection dir = this.isSucking ? this.facing.getOpposite() : this.facing;
        this.found_player = false;
        this.iterateEntities(front_range, s, dir, this.area, this.death_area, this.field_145850_b);
        if (this.field_145850_b == DeltaChunk.getWorld(this.field_145850_b)) {
            for (IDeltaChunk idc : DeltaChunk.getSlicesContainingPoint(coord)) {
                this.iterateFzdsEntities(front_range, s, dir, idc);
            }
        }
        if (this.field_145850_b.field_72995_K) {
            int n;
            int n2;
            s *= 8.0;
            if (this.isSucking) {
                s *= -1.0;
            }
            if ((n2 = this.target_speed - 1) <= 0) {
                n = 1;
                if (this.field_145850_b.field_73012_v.nextBoolean()) {
                    return;
                }
            }
            ForgeDirection d = this.facing;
            float ds = this.isSucking ? 3.0f : 0.0f;
            for (int i = 0; i < n; ++i) {
                double x = this.pick(this.area.field_72340_a, this.area.field_72336_d) + (double)((float)d.offsetX * ds);
                double y = this.pick(this.area.field_72338_b, this.area.field_72337_e) + (double)((float)d.offsetY * ds);
                double z = this.pick(this.area.field_72339_c, this.area.field_72334_f) + (double)((float)d.offsetZ * ds);
                this.field_145850_b.func_72869_a("cloud", x, y, z, (double)this.facing.offsetX * s, (double)this.facing.offsetY * s, (double)this.facing.offsetZ * s);
            }
        }
    }

    private void iterateFzdsEntities(int front_range, double s, ForgeDirection dir, IDeltaChunk idc) {
        this.iterateEntities(front_range, s, idc.shadow2real(dir), idc.shadow2real(this.area), idc.shadow2real(this.death_area), idc.field_70170_p);
        if (!this.field_145850_b.field_72995_K && Core.dev_environ && idc.getController() instanceof MechanicsController) {
            Vec3 force = SpaceUtil.fromDirection(dir);
            double forceScale = (double)this.target_speed / 20.0;
            if (this.isSucking) {
                forceScale *= -1.0;
            }
            SpaceUtil.incrScale(force, forceScale);
            MechanicsController.push(idc, this.getCoord(), force);
        }
    }

    private void iterateEntities(int front_range, double s, ForgeDirection dir, AxisAlignedBB box, AxisAlignedBB deathBox, World w) {
        boolean rising = dir.offsetY == (this.isSucking ? -1 : 1);
        for (Entity ent : w.func_94576_a(null, box, (IEntitySelector)this)) {
            if (rising) {
                this.waftEntity(ent);
            }
            this.suckEntity(ent, front_range, dir, s);
            if (!w.field_72995_K && this.isSucking && ent.field_70121_D != null && ent.field_70121_D.func_72326_a(deathBox)) {
                this.murderEntity(ent);
            }
            ent.field_70143_R *= 0.8f;
            if (!rising || !this.found_player || !(ent instanceof EntityPlayerMP)) continue;
            EntityPlayerMP player = (EntityPlayerMP)ent;
            player.field_71135_a.field_147365_f = 0;
        }
    }

    double pick(double min, double max) {
        double d = max - min;
        return min + d * this.field_145850_b.field_73012_v.nextDouble();
    }

    void suckEntity(Entity ent, int front_range, ForgeDirection dir, double s) {
        double ms = s;
        double distSq = ent.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
        if ((ms /= distSq / (double)(front_range * 10)) > 0.15) {
            ms = 0.15;
        }
        double dx = ms * (double)dir.offsetX;
        double dy = ms * (double)dir.offsetY;
        double dz = ms * (double)dir.offsetZ;
        if (this.isSucking || dir == ForgeDirection.UP) {
            double diff;
            if (dir.offsetX == 0) {
                diff = ent.field_70165_t - (double)this.field_145851_c - 0.5;
                dx -= diff * ms;
            }
            if (dir.offsetY == 0) {
                diff = ent.field_70163_u - (double)this.field_145848_d - 0.5;
                dy -= diff * ms;
            }
            if (dir.offsetZ == 0) {
                diff = ent.field_70161_v - (double)this.field_145849_e - 0.5;
                dz -= diff * ms;
            }
            if (ent.field_70181_x < dy) {
                ent.field_70181_x = dy;
            }
        }
        ent.func_70091_d(dx, dy, dz);
    }

    void waftEntity(Entity ent) {
        double damp = 0.5;
        ent.field_70159_w *= damp;
        ent.field_70179_y *= damp;
        if (ent.field_70181_x < 0.05) {
            ent.field_70181_x = (ent.field_70181_x + 0.05) / 2.0;
        }
    }

    void murderEntity(Entity ent) {
        if (ent.field_70128_L) {
            return;
        }
        if (ent instanceof EntityItem) {
            EntityItem ei = (EntityItem)ent;
            this.buffer.add(ei.func_92059_d());
            ent.func_70106_y();
            return;
        }
        if (ent instanceof EntityGhast) {
            if (ent.getClass() != EntityGhast.class) {
                return;
            }
            EntityGhast ghast = (EntityGhast)ent;
            if (this.field_145850_b.func_82737_E() % 30L == 0L) {
                ghast.func_70097_a(DamageSource.field_76377_j, 1.0f);
                ghast.field_70795_b = ghast.field_70165_t;
                ghast.field_70796_c = ghast.field_70163_u;
                ghast.field_70793_d = ghast.field_70161_v;
                ghast.field_70797_a = 40;
                if (ghast.field_70128_L) {
                    this.buffer.add(new ItemStack(Items.field_151073_bk));
                }
            }
            if (!this.field_145850_b.field_72995_K && ghast.func_110143_aJ() > 0.0f) {
                ghast.field_70177_z = (float)((double)ghast.field_70177_z + this.field_145850_b.field_73012_v.nextGaussian() * 12.0);
            }
        } else if (ent instanceof EntityChicken) {
            EntityChicken chicken = (EntityChicken)ent;
            if (chicken.func_110143_aJ() <= 1.0f) {
                chicken.func_70106_y();
                this.buffer.add(new ItemStack(Items.field_151110_aK));
            } else {
                chicken.func_70097_a(DamageSource.field_76377_j, 1.0f);
            }
        } else if (ent instanceof EntityBat) {
            EntityBat bat = (EntityBat)ent;
            bat.func_70097_a(DamageSource.field_76377_j, 1.0f);
        }
    }

    public boolean func_82704_a(Entity entity) {
        if (entity instanceof EntityItem) {
            return true;
        }
        if (this.target_speed <= 1) {
            return false;
        }
        if (entity instanceof EntityLiving || entity instanceof IProjectile || entity instanceof EntityTNTPrimed || entity instanceof EntityFallingBlock) {
            return true;
        }
        if (FzConfig.fanturpeller_works_on_players && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            this.found_player = true;
            return !player.field_71075_bZ.field_75098_d && !player.func_70093_af();
        }
        return false;
    }

    private void dropItems(Coord coord, ISocketHolder socket) {
        if (this.dropDelay > 0) {
            this.dropDelay = (short)(this.dropDelay - 1);
            return;
        }
        this.dropDelay = (short)40;
        InvUtil.FzInv back = null;
        if (socket == this) {
            coord.adjust(this.facing.getOpposite());
            back = InvUtil.openInventory(coord.getTE(IInventory.class), this.facing);
            coord.adjust(this.facing);
        } else {
            back = InvUtil.openInventory((Entity)socket, false);
        }
        if (back == null) {
            return;
        }
        ItemStack is = back.pullWithLimit(1);
        back.onInvChanged();
        if (is == null) {
            this.dropDelay = (short)120;
            return;
        }
        coord.adjust(this.facing);
        coord.spawnItem(is);
        coord.adjust(this.facing.getOpposite());
    }

    @Override
    protected void onRemove() {
        super.onRemove();
        Coord here = this.getCoord();
        for (ItemStack item : this.buffer) {
            InvUtil.spawnItemStack(here, item);
        }
    }

    @Override
    public boolean activate(EntityPlayer player, ForgeDirection side) {
        if (!this.buffer.isEmpty()) {
            new Notice(this, "Buffered output", new String[0]).send(player);
            return false;
        }
        return super.activate(player, side);
    }

    @Override
    public void click(EntityPlayer entityplayer) {
        InvUtil.emptyBuffer(entityplayer, this.buffer, this);
    }

    @Override
    public void installedOnServo(ServoMotor servoMotor) {
        super.installedOnServo(servoMotor);
        servoMotor.resizeInventory(3);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderItemOnServo(RenderServoMotor render, ServoMotor motor, ItemStack is, float partial) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.3125f, (float)0.0f);
        float turn = this.scaleRotation(NumUtil.interp(this.prevFanRotation, this.fanRotation, partial));
        GL11.glRotatef((float)(-turn), (float)0.0f, (float)1.0f, (float)0.0f);
        float s = 0.5625f;
        GL11.glScalef((float)s, (float)s, (float)s);
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)22.5f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.125f);
        render.renderItem(is);
        GL11.glPopMatrix();
        for (int i = 1; i < motor.func_70302_i_(); ++i) {
            is = motor.func_70301_a(i);
            if (is == null) continue;
            GL11.glPushMatrix();
            float r = 360 * i / 2 + 58;
            GL11.glRotatef((float)r, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.5625f);
            GL11.glRotatef((float)r, (float)0.0f, (float)1.0f, (float)0.0f);
            render.renderItem(is);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }
}

