/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth;

import com.google.common.base.Strings;
import factorization.truth.Tokenizer;
import factorization.truth.api.DocReg;
import factorization.truth.api.ITokenizer;
import factorization.truth.api.ITypesetCommand;
import factorization.truth.api.ITypesetter;
import factorization.truth.api.TruthError;
import java.util.Locale;

public abstract class AbstractTypesetter
implements ITypesetter {
    public final String domain;

    public AbstractTypesetter(String domain) {
        this.domain = domain;
    }

    @Override
    public String getVariable(String name) {
        return DocReg.getVariable(name);
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public void write(String text) throws TruthError {
        if (Strings.isNullOrEmpty((String)text)) {
            return;
        }
        Tokenizer tokenizer = new Tokenizer(text);
        block5: while (tokenizer.nextToken()) {
            String token = tokenizer.token;
            if (token.isEmpty()) continue;
            switch (tokenizer.type) {
                default: {
                    throw new TruthError("Unknown tokentype: " + tokenizer.token);
                }
                case WORD: {
                    this.runWord(token);
                    continue block5;
                }
                case PARAMETER: {
                    this.write(token);
                    continue block5;
                }
                case COMMAND: 
            }
            String cmdName = token.toLowerCase(Locale.ROOT);
            ITypesetCommand cmd = DocReg.commands.get(cmdName);
            if (cmd == null) {
                throw new TruthError("Unknown command: " + cmdName);
            }
            this.runCommand(cmd, tokenizer);
        }
    }

    public abstract void writeErrorMessage(String var1);

    protected abstract void runWord(String var1);

    protected abstract void runCommand(ITypesetCommand var1, ITokenizer var2) throws TruthError;
}

