/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth;

import factorization.truth.AbstractTypesetter;
import factorization.truth.WordPage;
import factorization.truth.api.AbstractPage;
import factorization.truth.api.IClientTypesetter;
import factorization.truth.api.ITokenizer;
import factorization.truth.api.ITypesetCommand;
import factorization.truth.api.IWord;
import factorization.truth.api.TruthError;
import factorization.truth.word.ItemWord;
import factorization.truth.word.TextWord;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StringUtils;

public class ClientTypesetter
extends AbstractTypesetter
implements IClientTypesetter {
    final FontRenderer font;
    final int pageWidth;
    final int pageHeight;
    public ArrayList<AbstractPage> pages = new ArrayList();
    private ArrayList<AbstractPage> afterBuffer = new ArrayList();
    public ArrayList<IWord> segmentStart = null;
    public String active_link = null;
    public String active_style = "";
    WordPage current;

    public ClientTypesetter(String domain, FontRenderer font, int pageWidth, int pageHeight) {
        super(domain);
        this.font = font;
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
    }

    @Override
    public void write(IWord w) {
        if (w.getLink() == null) {
            if (this.active_link != null) {
                w.setLink(this.active_link);
            } else if (w instanceof ItemWord) {
                ((ItemWord)w).setDefaultLink();
            }
        }
        if (!StringUtils.func_151246_b((String)this.active_style)) {
            w.setStyle(this.active_style);
        }
        WordPage page = this.getCurrentPage();
        int len = w.getWidth(this.font);
        if (len + page.lineLen > this.pageWidth) {
            page.nl();
        }
        int total_height = 0;
        for (ArrayList<IWord> line : page.text) {
            int[] padding = page.getVerticalPadding(line);
            int paddingTop = padding[0];
            int paddingBottom = padding[1];
            total_height += paddingTop + paddingBottom;
        }
        if (total_height + w.getPaddingAbove() + w.getWordHeight() > this.pageHeight) {
            WordPage oldPage = page;
            ArrayList<IWord> oldSeg = this.segmentStart;
            this.newPage();
            page = this.current;
            if (oldSeg != null) {
                int n = oldPage.text.lastIndexOf(oldSeg);
                while (oldPage.text.size() > n) {
                    page.text.add(oldPage.text.remove(n));
                }
            }
        }
        page.add(w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String text, String link, String style) throws TruthError {
        String prev_link = this.active_link;
        String prev_style = this.active_style;
        if (link != null) {
            this.active_link = link;
        }
        this.active_style = this.active_style + style;
        try {
            this.write(text);
        }
        finally {
            this.active_link = prev_link;
            this.active_style = prev_style;
        }
    }

    void emptyBuffer() {
        this.pages.addAll(this.afterBuffer);
        this.afterBuffer.clear();
    }

    @Override
    public void newPage() {
        this.emptyBuffer();
        this.current = new WordPage(this.font);
        this.pages.add(this.current);
        this.segmentStart = null;
    }

    @Override
    public WordPage getCurrentPage() {
        if (this.current == null) {
            this.newPage();
        }
        return this.current;
    }

    @Override
    public void addPage(AbstractPage page) {
        this.pages.add(page);
    }

    @Override
    public int getPageWidth() {
        return this.pageWidth;
    }

    @Override
    public int getPageHeight() {
        return this.pageHeight;
    }

    public ArrayList<AbstractPage> getPages() {
        this.emptyBuffer();
        return this.pages;
    }

    @Override
    public void writeErrorMessage(String msg) {
        try {
            this.write(msg.replace("\\", "\\\\ "), null, "" + EnumChatFormatting.RED);
        }
        catch (TruthError truthError) {
            truthError.printStackTrace();
        }
    }

    @Override
    protected void runWord(String word) {
        this.write(new TextWord(word));
    }

    @Override
    protected void runCommand(ITypesetCommand cmd, ITokenizer tokenizer) throws TruthError {
        cmd.callClient(this, tokenizer);
    }

    @Override
    public void write(ItemStack stack) {
        this.write(new ItemWord(stack));
    }

    @Override
    public void write(ItemStack[] stacks) {
        this.write(new ItemWord(stacks));
    }

    @Override
    public void write(Collection<ItemStack> stacks) {
        this.write(new ItemWord(stacks));
    }
}

