/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth;

import factorization.truth.ClientTypesetter;
import factorization.truth.Document;
import factorization.truth.DocumentationModule;
import factorization.truth.WordPage;
import factorization.truth.api.AbstractPage;
import factorization.truth.api.IWord;
import factorization.truth.api.TruthError;
import factorization.truth.gen.recipe.RecipeViewer;
import factorization.truth.minecraft.GuiButtonNextPage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class DocViewer
extends GuiScreen {
    final String domain;
    final String name;
    int startPageIndex;
    Document doc;
    AbstractPage page;
    GuiButton nextPage;
    GuiButton prevPage;
    GuiButton backButton;
    GuiButton homeButton;
    private final PersistentState state;
    public static HashMap<String, PersistentState> per_domain_state = new HashMap();
    int orig_scale = -1;
    boolean hot = true;
    int startMouseX;
    int startMouseY;
    long last_delay = Long.MAX_VALUE;

    int getPageWidth(int pageNum) {
        return this.field_146294_l * 40 / 100;
    }

    int getPageLeft(int pageNum) {
        int avail = this.field_146294_l - this.getPageWidth(pageNum) * 2;
        if (pageNum == 0) {
            return avail / 3;
        }
        return this.getPageWidth(pageNum) + avail * 2 / 3;
    }

    int getPageTop(int pageNum) {
        return this.field_146295_m * 5 / 100;
    }

    int getPageHeight(int pageNum) {
        return this.field_146295_m * 90 / 100;
    }

    public DocViewer(String domain, String name) {
        this.domain = domain;
        this.name = name;
        this.startPageIndex = -1;
        this.state = this.getStateFor(domain);
    }

    public DocViewer(String domain, HistoryPage hist) {
        this.domain = domain;
        this.name = hist.docName;
        this.startPageIndex = hist.offset;
        this.state = this.getStateFor(domain);
    }

    public DocViewer(String domain) {
        this.domain = domain;
        this.state = this.getStateFor(domain);
        this.name = this.state.current_page;
        this.startPageIndex = this.state.current_index;
    }

    private PersistentState getStateFor(String domain) {
        if (per_domain_state.containsKey(domain)) {
            return per_domain_state.get(domain);
        }
        PersistentState ret = new PersistentState();
        per_domain_state.put(domain, ret);
        return ret;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.orig_scale == -1) {
            this.field_146297_k = Minecraft.func_71410_x();
            this.orig_scale = this.field_146297_k.field_71474_y.field_74335_Z;
            if (this.orig_scale != 1 && this.orig_scale != 2) {
                this.field_146297_k.field_71474_y.field_74335_Z = 2;
            }
            this.field_146297_k.func_147108_a((GuiScreen)this);
            return;
        }
        this.doc = this.getDocument(this.name);
        if (this.doc == null || this.doc.pages.isEmpty()) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        this.page = this.doc.pages.get(0);
        if (this.startPageIndex != -1) {
            if (this.startPageIndex < this.doc.pages.size()) {
                this.page = this.doc.pages.get(this.startPageIndex);
            }
            this.startPageIndex = 0;
        }
        int row = this.getPageHeight(0);
        int arrow_half = 8;
        this.prevPage = new GuiButtonNextPage(2, this.getPageLeft(0) - 12, row - arrow_half, false);
        this.field_146292_n.add(this.prevPage);
        this.nextPage = new GuiButtonNextPage(1, this.getPageLeft(1) + this.getPageWidth(1) - 23 + 12, row - arrow_half, true);
        this.field_146292_n.add(this.nextPage);
        this.backButton = new GuiButton(3, 79, row, 50, 20, "Back");
        this.field_146292_n.add(this.backButton);
        this.homeButton = new GuiButton(4, 158, row, 50, 20, "Home");
        this.field_146292_n.add(this.homeButton);
        this.state.current_page = this.doc.name;
    }

    Document getDocument(String name) {
        ClientTypesetter ts = new ClientTypesetter(this.domain, this.field_146297_k.field_71466_p, this.getPageWidth(0), this.getPageHeight(0) - 26);
        try {
            ts.write(DocumentationModule.readDocument(this.domain, name));
        }
        catch (TruthError truthError) {
            ts.writeErrorMessage(truthError.getMessage());
        }
        return new Document(name, (ArrayList<AbstractPage>)ts.getPages());
    }

    AbstractPage getPage(int d) {
        if (this.doc == null) {
            return null;
        }
        if (d == 0) {
            return this.page;
        }
        int i = this.doc.pages.indexOf(this.page) + d;
        if (i < 0) {
            return null;
        }
        if (i >= this.doc.pages.size()) {
            return null;
        }
        return this.doc.pages.get(i);
    }

    int getCurrentPageIndex() {
        int i = 0;
        for (AbstractPage pg : this.doc.pages) {
            if (pg == this.page) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        float cs;
        int pass;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
        this.hot = false;
        this.func_146276_q_();
        this.backButton.field_146125_m = !this.state.the_pageHistory.isEmpty();
        this.homeButton.field_146125_m = !this.name.equals("index");
        this.prevPage.field_146125_m = this.doc.pages.indexOf(this.page) > 0;
        this.nextPage.field_146125_m = this.doc.pages.indexOf(this.page) + 2 < this.doc.pages.size();
        for (pass = 1; pass >= 0; --pass) {
            int paddingVert = 8 + pass;
            int paddingHoriz = 12 + pass;
            int x0 = this.getPageLeft(0) - paddingHoriz;
            int x1 = this.getPageLeft(1) + this.getPageWidth(1) + paddingHoriz;
            int y0 = this.getPageTop(0) - paddingVert;
            int y1 = this.getPageHeight(0) + paddingVert;
            if (pass == 1) {
                GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            } else if (this.state.dark_color_scheme) {
                GL11.glColor3f((float)0.075f, (float)0.075f, (float)0.1125f);
            } else {
                GL11.glColor3f((float)0.925f, (float)0.925f, (float)0.8875f);
            }
            GL11.glDisable((int)3553);
            GL11.glBegin((int)7);
            GL11.glVertex3f((float)x0, (float)y0, (float)0.0f);
            GL11.glVertex3f((float)x0, (float)y1, (float)0.0f);
            GL11.glVertex3f((float)x1, (float)y1, (float)0.0f);
            GL11.glVertex3f((float)x1, (float)y0, (float)0.0f);
            GL11.glEnd();
        }
        int paddingVert = 8;
        int paddingHoriz = 12;
        int x0 = this.getPageLeft(0) + this.getPageWidth(0) + paddingHoriz;
        int x1 = this.getPageLeft(1) - paddingHoriz;
        int y0 = this.getPageTop(0) - paddingVert;
        int y1 = this.getPageHeight(0) + paddingVert;
        if (this.state.dark_color_scheme) {
            cs = 0.75f;
            GL11.glColor3f((float)(0.075f * cs), (float)(0.075f * cs), (float)(0.1125f * cs));
        } else {
            cs = 1.75f;
            GL11.glColor3f((float)(1.0f - 0.075f * cs), (float)(1.0f - 0.075f * cs), (float)(1.0f - 0.1125f * cs));
        }
        GL11.glBegin((int)7);
        GL11.glVertex3f((float)x0, (float)y0, (float)0.0f);
        GL11.glVertex3f((float)x0, (float)y1, (float)0.0f);
        GL11.glVertex3f((float)x1, (float)y1, (float)0.0f);
        GL11.glVertex3f((float)x1, (float)y0, (float)0.0f);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        for (pass = 0; pass <= 1; ++pass) {
            this.drawPage(0, mouseX, mouseY, pass);
            this.drawPage(1, mouseX, mouseY, pass);
        }
        GL11.glPopMatrix();
    }

    void drawPage(int id, int mouseX, int mouseY, int pass) {
        WordPage p;
        AbstractPage page = this.getPage(id);
        if (page == null) {
            return;
        }
        IWord hovered = null;
        String hoveredLink = null;
        if (page instanceof WordPage && (hovered = (p = (WordPage)page).click(mouseX - this.getPageLeft(id), mouseY - this.getPageTop(id))) != null) {
            hoveredLink = hovered.getLink();
        }
        if (pass == 0) {
            page.draw(this, this.getPageLeft(id), this.getPageTop(id), hoveredLink);
        } else if (pass == 1 && hovered != null) {
            hovered.drawHover(mouseX, mouseY);
        }
    }

    public static void drawItem(ItemStack is, int x, int y, FontRenderer font) {
        GL11.glEnable((int)2929);
        TextureManager tm = Minecraft.func_71410_x().func_110434_K();
        GuiContainer.field_146296_j.func_82406_b(font, tm, is, x, y);
        GuiContainer.field_146296_j.func_77021_b(font, tm, is, x, y);
    }

    public static void drawItemTip(ItemStack is, int x, int y) {
        DocViewer me = DocViewer.get();
        if (me != null) {
            me.func_146285_a(is, x, y);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        if (this.hot) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, button);
        if (button == 1) {
            this.func_146284_a(this.backButton);
            return;
        }
        for (int i = 0; i <= 1; ++i) {
            WordPage p;
            IWord link;
            AbstractPage thisPage = this.getPage(i);
            if (!(thisPage instanceof WordPage) || (link = (p = (WordPage)thisPage).click(mouseX - this.getPageLeft(i), mouseY - this.getPageTop(i))) == null) continue;
            if (link.onClick()) {
                return;
            }
            if (link.getLink() == null) continue;
            if (link.getLink().equals(this.name)) {
                return;
            }
            DocViewer newDoc = new DocViewer(this.domain, link.getLink());
            this.state.addNewHistoryEntry(this.name, this.getCurrentPageIndex());
            this.field_146297_k.func_147108_a((GuiScreen)newDoc);
            return;
        }
    }

    public void func_146274_d() {
        int scroll = Mouse.getEventDWheel();
        if (scroll == 0) {
            super.func_146274_d();
        } else if (scroll > 0) {
            this.func_146284_a(this.prevPage);
        } else if (scroll < 0) {
            this.func_146284_a(this.nextPage);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (!button.field_146124_l) {
            return;
        }
        if (button == this.nextPage) {
            AbstractPage n = this.getPage(2);
            if (n != null) {
                this.page = n;
            }
        } else if (button == this.prevPage) {
            AbstractPage n = this.getPage(-2);
            if (n != null) {
                this.page = n;
            }
        } else if (button == this.backButton) {
            DocViewer newDoc = new DocViewer(this.domain, this.state.popLastPage());
            this.field_146297_k.func_147108_a((GuiScreen)newDoc);
        } else if (button == this.homeButton && !this.name.equals("index")) {
            this.state.addNewHistoryEntry(this.name, this.getCurrentPageIndex());
            this.field_146297_k.func_147108_a((GuiScreen)new DocViewer(this.domain, "index"));
        }
    }

    protected void func_73869_a(char chr, int keySym) {
        if (keySym == 14 || chr == 'z') {
            this.func_146284_a(this.backButton);
        } else if (keySym == 209 || chr == ' ') {
            this.func_146284_a(this.nextPage);
        } else if (keySym == 201) {
            this.func_146284_a(this.prevPage);
        } else if (keySym == 199) {
            this.func_146284_a(this.homeButton);
        } else if (chr == 'r') {
            this.func_73866_w_();
        } else if (chr == 's') {
            this.state.dark_color_scheme ^= true;
        } else if (keySym == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiInventory((EntityPlayer)this.field_146297_k.field_71439_g));
        } else if (chr == 'l') {
            RecipeViewer.resetCache();
            this.func_73866_w_();
        } else {
            super.func_73869_a(chr, keySym);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int button, long heldTime) {
        if (heldTime < this.last_delay) {
            this.startMouseX = mouseX;
            this.startMouseY = mouseY;
        }
        for (int i = 0; i <= 1; ++i) {
            AbstractPage p = this.getPage(i);
            if (p == null || this.getPageLeft(i) > this.startMouseX || this.getPageLeft(i) + this.getPageWidth(i) < this.startMouseX || this.getPageTop(i) >= this.startMouseY || this.getPageTop(i) + this.getPageHeight(i) <= this.startMouseY) continue;
            if (heldTime < this.last_delay) {
                p.mouseDragStart();
            }
            p.mouseDrag(this.startMouseX - mouseX, this.startMouseY - mouseY);
        }
        this.last_delay = heldTime;
    }

    public void func_146281_b() {
        if (this.orig_scale != -1) {
            this.field_146297_k.field_71474_y.field_74335_Z = this.orig_scale;
            this.orig_scale = -1;
        }
        for (AbstractPage page : this.doc.pages) {
            page.closed();
        }
        this.state.current_index = this.doc.pages.indexOf(this.getPage(0));
    }

    public boolean func_73868_f() {
        return false;
    }

    public FontRenderer getFont() {
        return this.field_146289_q;
    }

    public boolean isDark() {
        return this.state.dark_color_scheme;
    }

    public static DocViewer get() {
        GuiScreen ret = Minecraft.func_71410_x().field_71462_r;
        if (ret instanceof DocViewer) {
            return (DocViewer)ret;
        }
        return null;
    }

    public static boolean dark() {
        DocViewer me = DocViewer.get();
        if (me == null) {
            return false;
        }
        return me.isDark();
    }

    public static class HistoryPage {
        String docName;
        int offset;

        public HistoryPage(String docName, int offset) {
            this.docName = docName;
            this.offset = offset;
        }
    }

    public static class PersistentState {
        public boolean dark_color_scheme = false;
        public Deque<HistoryPage> the_pageHistory = new ArrayDeque<HistoryPage>();
        public String current_page = "index";
        public int current_index = 0;

        public HistoryPage popLastPage() {
            if (this.the_pageHistory.isEmpty()) {
                return new HistoryPage("index", 0);
            }
            return this.the_pageHistory.pollLast();
        }

        public void addNewHistoryEntry(String name, int page) {
            this.the_pageHistory.add(new HistoryPage(name, page));
        }
    }
}

