/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth;

import com.google.common.io.Closeables;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.common.FzConfig;
import factorization.coremodhooks.HookTargetsClient;
import factorization.coremodhooks.UnhandledGuiKeyEvent;
import factorization.shared.Core;
import factorization.truth.DocViewer;
import factorization.truth.DocWorld;
import factorization.truth.FzdocSerialize;
import factorization.truth.api.DocReg;
import factorization.truth.api.IDocBook;
import factorization.truth.api.IDocModule;
import factorization.truth.api.IManwich;
import factorization.truth.api.ITypesetCommand;
import factorization.truth.cmd.CmdCheckMods;
import factorization.truth.cmd.CmdDash;
import factorization.truth.cmd.CmdFigure;
import factorization.truth.cmd.CmdFor;
import factorization.truth.cmd.CmdGenerate;
import factorization.truth.cmd.CmdHeader;
import factorization.truth.cmd.CmdIfHtml;
import factorization.truth.cmd.CmdImg;
import factorization.truth.cmd.CmdInclude;
import factorization.truth.cmd.CmdItem;
import factorization.truth.cmd.CmdLeftpage;
import factorization.truth.cmd.CmdLink;
import factorization.truth.cmd.CmdLocal;
import factorization.truth.cmd.CmdMacro;
import factorization.truth.cmd.CmdNewpage;
import factorization.truth.cmd.CmdNl;
import factorization.truth.cmd.CmdP;
import factorization.truth.cmd.CmdSegEnd;
import factorization.truth.cmd.CmdSegStart;
import factorization.truth.cmd.CmdSlash;
import factorization.truth.cmd.CmdSpace;
import factorization.truth.cmd.CmdStyle;
import factorization.truth.cmd.CmdTitle;
import factorization.truth.cmd.CmdTopic;
import factorization.truth.cmd.CmdUrl;
import factorization.truth.cmd.CmdVpad;
import factorization.truth.export.ExportHtml;
import factorization.truth.gen.BiomeViewer;
import factorization.truth.gen.EnchantViewer;
import factorization.truth.gen.EventbusViewer;
import factorization.truth.gen.FluidViewer;
import factorization.truth.gen.ItemListViewer;
import factorization.truth.gen.ModDependViewer;
import factorization.truth.gen.OreDictionaryViewer;
import factorization.truth.gen.TesrViewer;
import factorization.truth.gen.TreasureViewer;
import factorization.truth.gen.WorldgenViewer;
import factorization.truth.gen.recipe.RecipeViewer;
import factorization.util.DataUtil;
import factorization.util.FzUtil;
import factorization.util.PlayerUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

@Mod(modid="factorization.truth", name="Truth", version="0.8.109")
public class DocumentationModule
implements IDocModule {
    public static final String modid = "factorization.truth";
    public static DocumentationModule instance;
    static HashMap<String, ArrayList<ItemStack>> nameCache;
    public static IResourceManager overrideResourceManager;

    public DocumentationModule() {
        instance = this;
        DocReg.module = instance;
    }

    @Mod.EventHandler
    public void init(FMLPreInitializationEvent event) {
        FzUtil.setCoreParent(event);
        DocReg.registerGenerator("items", new ItemListViewer());
        DocReg.registerGenerator("recipes", new RecipeViewer());
        DocReg.registerGenerator("enchants", new EnchantViewer());
        DocReg.registerGenerator("treasure", new TreasureViewer());
        DocReg.registerGenerator("biomes", new BiomeViewer());
        DocReg.registerGenerator("fluids", new FluidViewer());
        DocReg.registerGenerator("oredictionary", new OreDictionaryViewer());
        DocReg.registerGenerator("mods", new ModDependViewer());
        DocReg.registerGenerator("worldgen", new WorldgenViewer());
        DocReg.registerGenerator("eventbus", new EventbusViewer());
        DocReg.registerGenerator("tesrs", new TesrViewer());
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            Core.loadBus(new DocKeyListener());
        }
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            DocReg.setVariable("mod:" + mod.getModId(), mod.getName());
        }
        DocumentationModule.registerCommands();
    }

    private static void reg(String name, ITypesetCommand cmd) {
        DocReg.registerCommand("\\" + name, cmd);
    }

    private static void registerCommands() {
        DocumentationModule.reg("include", new CmdInclude());
        DocumentationModule.reg("lmp", new CmdMacro("\\link{lmp}{LMP}"));
        DocumentationModule.reg("p", new CmdP());
        DocumentationModule.reg("-", new CmdDash());
        DocumentationModule.reg("", new CmdSpace());
        DocumentationModule.reg(" ", new CmdSpace());
        DocumentationModule.reg("\\", new CmdSlash());
        DocumentationModule.reg("nl", new CmdNl());
        DocumentationModule.reg("newpage", new CmdNewpage());
        DocumentationModule.reg("leftpage", new CmdLeftpage());
        DocumentationModule.reg("b", new CmdStyle(EnumChatFormatting.BOLD, "b"));
        DocumentationModule.reg("i", new CmdStyle(EnumChatFormatting.ITALIC, "i"));
        DocumentationModule.reg("u", new CmdStyle(EnumChatFormatting.UNDERLINE, "u"));
        DocumentationModule.reg("title", new CmdTitle());
        DocumentationModule.reg("h1", new CmdHeader());
        DocumentationModule.reg("link", new CmdLink(false));
        DocumentationModule.reg("index", new CmdLink(true));
        DocumentationModule.reg("#", new CmdItem());
        DocumentationModule.reg("img", new CmdImg());
        DocumentationModule.reg("figure", new CmdFigure());
        DocumentationModule.reg("generate", new CmdGenerate());
        DocumentationModule.reg("seg", new CmdSegStart());
        DocumentationModule.reg("endseg", new CmdSegEnd());
        DocumentationModule.reg("topic", new CmdTopic());
        DocumentationModule.reg("checkmods", new CmdCheckMods());
        DocumentationModule.reg("vpad", new CmdVpad());
        DocumentationModule.reg("ifhtml", new CmdIfHtml());
        DocumentationModule.reg("url", new CmdUrl());
        DocumentationModule.reg("local", new CmdLocal());
        DocumentationModule.reg("for", new CmdFor());
    }

    public static ArrayList<ItemStack> lookup(String name) {
        return DocumentationModule.getNameItemCache().get(name);
    }

    public static HashMap<String, ArrayList<ItemStack>> getNameItemCache() {
        if (nameCache == null) {
            DocumentationModule.loadCache();
        }
        return nameCache;
    }

    private static void loadCache() {
        ArrayList items = new ArrayList();
        for (Item it : Item.field_150901_e) {
            if (it == null) continue;
            try {
                it.func_150895_a(it, it.func_77640_w(), items);
            }
            catch (Throwable t) {
                Core.logWarning("Error getting sub-items from item: " + it + " " + DataUtil.getName(it), new Object[0]);
                t.printStackTrace();
            }
        }
        nameCache = new HashMap(items.size());
        for (ItemStack is : items) {
            if (is == null) continue;
            try {
                String itemName = is.func_77977_a();
                ArrayList<Object> list = nameCache.get(itemName);
                if (list == null) {
                    list = new ArrayList();
                    nameCache.put(itemName, list);
                }
                list.add(is);
            }
            catch (Throwable t) {
                Core.logSevere("Error getting names from item: " + is.func_77973_b() + " " + DataUtil.getName(is.func_77973_b()), new Object[0]);
                t.printStackTrace();
            }
        }
    }

    @Mod.EventHandler
    public void serverStarts(FMLServerStartingEvent event) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT && (Core.dev_environ || Boolean.getBoolean("fz.registerDocCommands"))) {
            event.registerServerCommand((ICommand)new FzdocSerialize());
            event.registerServerCommand((ICommand)new ExportHtml());
        }
    }

    static String encodeNBT(NBTTagCompound tag) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(new GZIPOutputStream(baos));
        CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)dos);
        dos.close();
        byte[] compressedData = baos.toByteArray();
        ByteBuf enc = Base64.encode((ByteBuf)Unpooled.copiedBuffer((byte[])compressedData));
        return new String(enc.array());
    }

    static NBTTagCompound decodeNBT(String contents) throws IOException {
        ByteBuf decoded = Base64.decode((ByteBuf)Unpooled.copiedBuffer((byte[])contents.getBytes()));
        ByteBufInputStream bais = new ByteBufInputStream(decoded);
        return CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(new GZIPInputStream((InputStream)bais)));
    }

    @SideOnly(value=Side.CLIENT)
    public static DocWorld loadWorld(String text) {
        try {
            HookTargetsClient.clientWorldLoadEventAbort.set(Boolean.TRUE);
            NBTTagCompound tag = DocumentationModule.decodeNBT(text);
            DocWorld docWorld = new DocWorld(tag);
            return docWorld;
        }
        catch (IOException e) {
            e.printStackTrace();
            DocWorld docWorld = null;
            return docWorld;
        }
        finally {
            HookTargetsClient.clientWorldLoadEventAbort.remove();
        }
    }

    public static ResourceLocation getResourceForName(String domain, String name) {
        return new ResourceLocation(domain, "doc/" + name + ".txt");
    }

    public static InputStream getDocumentResource(String domain, String name) {
        try {
            IResourceManager irm = overrideResourceManager != null ? overrideResourceManager : Minecraft.func_71410_x().func_110442_L();
            IResource src = irm.func_110536_a(DocumentationModule.getResourceForName(domain, name));
            return src.func_110527_b();
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                return null;
            }
            e.printStackTrace();
            return null;
        }
    }

    public static String readDocument(String domain, String name) {
        try {
            return DocumentationModule.dispatchDocument(domain, name);
        }
        catch (Throwable e) {
            e.printStackTrace();
            String txt = e.getMessage();
            for (StackTraceElement ste : e.getStackTrace()) {
                txt = txt + "\n\n    at " + ste.getFileName() + "(" + ste.getFileName() + ":" + ste.getLineNumber() + ")";
            }
            return "\\5*5*5*2*2 Internal Server Error\n\nAn error was encountered while trying to execute your request.\n\n" + txt;
        }
    }

    private static String readContents(String name, InputStream is) throws IOException {
        int length;
        if (is == null) {
            return "\\101*2*2 Not Found: " + name;
        }
        StringBuilder build = new StringBuilder();
        byte[] buf = new byte[1024];
        while ((length = is.read(buf)) != -1) {
            build.append(new String(buf, 0, length));
        }
        return build.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String dispatchDocument(String domain, String name) throws IOException {
        if (name.startsWith("cgi/")) {
            return "\\generate{" + name.replace("cgi/", "") + "}";
        }
        InputStream is = null;
        try {
            is = DocumentationModule.getDocumentResource(domain, name);
            String string = DocumentationModule.readContents(name, is);
            return string;
        }
        finally {
            Closeables.close((Closeable)is, (boolean)false);
        }
    }

    public static String textifyItem(ItemStack is) {
        String name = is.func_77977_a();
        return "\\#{" + name + "} " + is.func_82833_r();
    }

    public static Slot getSlotUnderMouse() {
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71462_r instanceof GuiContainer)) {
            return null;
        }
        GuiContainer screen = (GuiContainer)mc.field_71462_r;
        int mouseX = Mouse.getEventX() * screen.field_146294_l / mc.field_71443_c;
        int mouseY = screen.field_146295_m - Mouse.getEventY() * screen.field_146295_m / mc.field_71440_d - 1;
        return screen.func_146975_c(mouseX, mouseY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void openPageForHilightedItem() {
        Slot slot = DocumentationModule.getSlotUnderMouse();
        ItemStack stack = slot == null ? null : slot.func_75211_c();
        this.openBookForItem(stack, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean openBookForItem(ItemStack is, boolean forceOpen) {
        boolean found;
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null) {
            return false;
        }
        String found_domain = DocReg.default_lookup_domain;
        boolean bl = found = forceOpen || PlayerUtil.isPlayerCreative((EntityPlayer)player) || !FzConfig.require_book_for_manual;
        if (!found) {
            for (ItemStack manual : player.field_71071_by.field_70462_a) {
                if (manual == null || !(manual.func_77973_b() instanceof IDocBook)) continue;
                found_domain = ((IDocBook)manual.func_77973_b()).getDocumentationDomain();
                found = true;
                break;
            }
        }
        if (!found) {
            IManwich first = null;
            for (IManwich manwich : DocReg.manwiches) {
                if (first == null) {
                    first = manwich;
                }
                if (manwich.hasManual((EntityPlayer)player) <= 0) continue;
                found = true;
                found_domain = manwich.getManwichDomain((EntityPlayer)player);
                break;
            }
            if (!found) {
                if (first != null) {
                    first.recommendManwich((EntityPlayer)player);
                }
                return false;
            }
        }
        if (is == null) {
            mc.func_147108_a((GuiScreen)new DocViewer(found_domain));
            return true;
        }
        String name = is.func_77977_a();
        for (String domain : DocReg.indexed_domains) {
            InputStream topic_index = DocumentationModule.getDocumentResource(domain, "topic_index");
            if (topic_index == null) {
                return false;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(topic_index));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    String[] bits = line.split("\t");
                    if (bits.length < 2 || !bits[0].equalsIgnoreCase(name)) continue;
                    String filename = bits[1];
                    mc.func_147108_a((GuiScreen)new DocViewer(domain, filename));
                    boolean bl2 = true;
                    return bl2;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                FzUtil.closeNoisily("closing topic_index", topic_index);
            }
        }
        mc.func_147108_a((GuiScreen)new DocViewer(DocReg.default_recipe_domain, "cgi/recipes/" + name));
        return true;
    }

    @Mod.EventHandler
    public void handleImc(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            try {
                RecipeViewer.handleImc(message);
                this.handleImc(message);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void handleImc(FMLInterModComms.IMCMessage message) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        if (!message.key.equals("DocVar")) {
            return;
        }
        String[] parts = message.getStringValue().split("=", 2);
        String key = parts[0];
        String val = parts[1];
        if (key.endsWith("+")) {
            key = key.replace("+", "");
            DocReg.appendVariable(key, val);
        } else {
            DocReg.setVariable(key, val);
        }
    }

    static {
        nameCache = null;
        overrideResourceManager = null;
    }

    public static class DocKeyListener {
        boolean hasNei = Loader.isModLoaded((String)"NotEnoughItems");

        @SubscribeEvent
        public void keyPress(UnhandledGuiKeyEvent event) {
            if (event.chr == '?') {
                DocReg.module.openPageForHilightedItem();
            } else if (!(event.chr != 'r' && event.chr != 'R' || this.hasNei)) {
                DocReg.module.openPageForHilightedItem();
            }
        }
    }
}

