/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth;

import factorization.shared.Core;
import factorization.truth.DocViewer;
import factorization.truth.DocWorld;
import factorization.truth.api.AbstractPage;
import factorization.util.RenderUtil;
import factorization.weird.TileEntityDayBarrel;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class FigurePage
extends AbstractPage {
    DocWorld figure;
    double rotationX = 135.0;
    double rotationY = 45.0;
    int display_list = -1;
    double origRotationX;
    double origRotationY;
    WorldRenderer wr = null;
    EntityLivingBase eyeball;

    public FigurePage(DocWorld figure) {
        this.figure = figure;
        this.eyeball = new EntityLiving((World)figure){};
    }

    @Override
    public void mouseDragStart() {
        this.origRotationX = this.rotationX;
        this.origRotationY = this.rotationY;
    }

    @Override
    public void mouseDrag(int dx, int dy) {
        this.rotationX = this.origRotationX + (double)dy;
        this.rotationY = this.origRotationY - (double)dx;
    }

    @Override
    public void draw(DocViewer doc, int ox, int oy, String hovered) {
        RenderUtil.checkGLError("FigurePage -- before render");
        if (this.wr == null) {
            GL11.glPushAttrib((int)1048575);
            this.wr = new WorldRenderer((World)this.figure, new ArrayList(), 0, 0, 0, this.getRenderList());
            this.wr.field_78939_q = true;
            this.wr.func_147892_a(this.eyeball);
            GL11.glPopAttrib();
            RenderUtil.checkGLError("FigurePage -- update worldrenderer");
        }
        this.wr.field_78927_l = true;
        doc.field_146297_k.field_71446_o.func_110577_a(Core.blockAtlas);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)ox, (float)oy, (float)200.0f);
        GL11.glTranslated((double)(doc.getPageWidth(0) / 2), (double)(doc.getPageHeight(0) / 2), (double)0.0);
        float diag = this.figure.diagonal;
        float s = (float)(doc.getPageWidth(0) / 2) / diag;
        GL11.glScalef((float)s, (float)s, (float)s);
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotated((double)this.rotationX, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)this.rotationY, (double)0.0, (double)1.0, (double)0.0);
        s = -diag / 2.0f;
        GL11.glTranslated((double)s, (double)s, (double)s);
        if (Minecraft.func_71379_u()) {
            GL11.glShadeModel((int)7425);
        }
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)32826);
        GL11.glDisable((int)2896);
        for (int i = 0; i < 2; ++i) {
            if (i == 1) {
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glEnable((int)3042);
            }
            GL11.glCallList((int)this.wr.func_78909_a(i));
        }
        GL11.glPopAttrib();
        GL11.glPushAttrib((int)1048575);
        TileEntityRendererDispatcher ter = TileEntityRendererDispatcher.field_147556_a;
        TileEntityRendererDispatcher.field_147552_d = 0.0;
        TileEntityRendererDispatcher.field_147555_c = 0.0;
        TileEntityRendererDispatcher.field_147554_b = 0.0;
        for (TileEntity te : this.figure.tileEntities) {
            ter.func_147549_a(te, (double)te.field_145851_c, (double)te.field_145848_d, (double)te.field_145849_e, 0.0f);
        }
        GL11.glPopAttrib();
        GL11.glPushAttrib((int)1048575);
        RenderManager rm = RenderManager.field_78727_a;
        for (Entity ent : this.figure.entities) {
            double x = ent.field_70165_t - (double)this.figure.orig.x;
            double y = ent.field_70163_u - (double)this.figure.orig.y;
            double z = ent.field_70161_v - (double)this.figure.orig.z;
            RenderManager.field_78725_b = ent.field_70165_t;
            RenderManager.field_78726_c = ent.field_70163_u;
            RenderManager.field_78723_d = ent.field_70161_v;
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            rm.func_147937_a(ent, 0.0f);
            GL11.glPopMatrix();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
        RenderUtil.checkGLError("FigurePage -- after rendering everything");
    }

    int getRenderList() {
        if (this.display_list == -1) {
            this.display_list = GLAllocation.func_74526_a((int)3);
            if (this.display_list == -1) {
                Core.logWarning("GL display list allocation failed!", new Object[0]);
            }
        }
        return this.display_list;
    }

    @Override
    public void closed() {
        if (this.display_list == -1) {
            return;
        }
        GLAllocation.func_74523_b((int)this.display_list);
        this.display_list = -1;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        TileEntityDayBarrel.addFinalizedDisplayList(this.display_list);
    }
}

