/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth;

import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.ICoordFunction;
import factorization.notify.Notice;
import factorization.truth.DocWorld;
import factorization.truth.DocumentationModule;
import factorization.util.FzUtil;
import factorization.util.PlayerUtil;
import factorization.util.SpaceUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

final class FzdocSerialize
implements ICommand {
    FzdocSerialize() {
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof ICommand) {
            ICommand other = (ICommand)arg0;
            return this.func_71517_b().compareTo(other.func_71517_b());
        }
        return 0;
    }

    public String func_71517_b() {
        return "fzdoc-figure";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/fzdoc-serialize generates an FZDoc \\figure command";
    }

    public List func_71514_a() {
        return null;
    }

    public boolean func_71519_b(ICommandSender icommandsender) {
        return icommandsender instanceof EntityPlayer && PlayerUtil.isCommandSenderOpped(icommandsender);
    }

    public List func_71516_a(ICommandSender icommandsender, String[] astring) {
        return null;
    }

    public boolean func_82358_a(String[] astring, int i) {
        return false;
    }

    public void func_71515_b(ICommandSender icommandsender, String[] astring) {
        Block gold;
        if (!(icommandsender instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)icommandsender;
        Coord peak = new Coord((Entity)player).add(ForgeDirection.DOWN);
        if (!peak.is(gold = Blocks.field_150340_R)) {
            this.msg((ICommandSender)player, "Not on a gold block");
            return;
        }
        int ySize = 0;
        Coord at = peak.copy();
        while (at.is(gold)) {
            at.adjust(ForgeDirection.DOWN);
            --ySize;
        }
        at.adjust(ForgeDirection.UP);
        Coord bottom = at.copy();
        int xSize = this.measure(bottom, ForgeDirection.EAST, ForgeDirection.WEST, gold);
        int zSize = this.measure(bottom, ForgeDirection.SOUTH, ForgeDirection.NORTH, gold);
        if (xSize * ySize * zSize == 0) {
            this.msg((ICommandSender)player, "Invalid dimensions");
            return;
        }
        if (Math.abs(xSize) > 15) {
            this.msg((ICommandSender)player, "X axis is too large");
            return;
        }
        if (Math.abs(ySize) > 15) {
            this.msg((ICommandSender)player, "Y ayis is too large");
            return;
        }
        if (Math.abs(zSize) > 15) {
            this.msg((ICommandSender)player, "Z azis is too large");
            return;
        }
        Coord far = bottom.add(xSize, 0, zSize);
        Coord max = peak.add((int)Math.signum(xSize), 0, (int)Math.signum(zSize));
        Coord min = far.add((int)(-Math.signum(xSize)), 0, (int)(-Math.signum(zSize)));
        Coord.sort(min, max);
        new Notice(max, "max", new String[0]).sendToAll();
        new Notice(min, "min", new String[0]).sendToAll();
        DocWorld dw = this.copyChunkToWorld(min, max);
        NBTTagCompound worldTag = new NBTTagCompound();
        dw.writeToTag(worldTag);
        try {
            String encoded = DocumentationModule.encodeNBT(worldTag);
            String cmd = "\\figure{\n" + encoded + "}";
            cmd = cmd.replace("\u0000", "");
            System.out.println(cmd);
            FzUtil.copyStringToClipboard(cmd);
            this.msg((ICommandSender)player, "\\figure command copied to the clipboard");
        }
        catch (Throwable t) {
            this.msg((ICommandSender)player, "An error occured");
            t.printStackTrace();
        }
    }

    DocWorld copyChunkToWorld(final Coord min, Coord max) {
        final DocWorld w = new DocWorld();
        final DeltaCoord start = new DeltaCoord(0, 0, 0);
        Coord.iterateCube(min, max, new ICoordFunction(){

            @Override
            public void handle(Coord here) {
                if (here.isAir()) {
                    return;
                }
                DeltaCoord dc = here.difference(min).add(start);
                w.setIdMdTe(dc, here.getId(), here.getMd(), here.getTE());
            }
        });
        DeltaCoord d = max.difference(min);
        d.y /= 2;
        w.diagonal = (int)(d.magnitude() + 1.0);
        this.copyEntities(w, min, max);
        w.orig.set(min);
        return w;
    }

    void copyEntities(DocWorld dw20, Coord min, Coord max) {
        AxisAlignedBB ab = Coord.aabbFromRange(min, max);
        List ents = min.w.func_72839_b(null, ab);
        for (Entity ent : ents) {
            if (ent instanceof EntityPlayer) continue;
            dw20.addEntity(ent);
        }
    }

    void msg(ICommandSender player, String msg) {
        player.func_145747_a((IChatComponent)new ChatComponentText(msg));
    }

    int measure(Coord bottom, ForgeDirection east, ForgeDirection west, Block gold) {
        Coord at = bottom.copy();
        ForgeDirection d = bottom.add(east).is(gold) ? east : west;
        int size = 0;
        while (at.is(gold)) {
            at.adjust(d);
            ++size;
        }
        return size * SpaceUtil.sign(d);
    }
}

