/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth;

import factorization.truth.DocViewer;
import factorization.truth.api.AbstractPage;
import factorization.truth.api.IWord;
import factorization.truth.word.TextWord;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;

public class WordPage
extends AbstractPage {
    public ArrayList<ArrayList<IWord>> text = new ArrayList();
    public static int TEXT_HEIGHT = 9;
    int lineLen = 0;
    FontRenderer font;

    WordPage(FontRenderer font) {
        this.font = font;
        if (font != null) {
            TEXT_HEIGHT = font.field_78288_b;
        }
        this.nl();
    }

    void add(IWord word) {
        if (word instanceof TextWord) {
            TextWord tw = (TextWord)word;
            if (tw.text.equals("\t")) {
                word = new TextWord("    ");
                word.setLink(tw.getLink());
                word.setStyle(tw.getStyle());
            } else if (this.lineLen == 0 && tw.text.trim().isEmpty()) {
                return;
            }
        }
        this.text.get(this.text.size() - 1).add(word);
        if (this.font != null) {
            this.lineLen += word.getWidth(this.font);
        }
    }

    public void nl() {
        ArrayList<TextWord> newLine = new ArrayList<TextWord>();
        newLine.add(new TextWord(""));
        this.text.add(newLine);
        this.lineLen = 0;
    }

    IWord click(int relativeX, int relativeY) {
        int y = 0;
        for (ArrayList<IWord> line : this.text) {
            int paddingBottom;
            if (y > relativeY) break;
            int[] padding = this.getVerticalPadding(line);
            int paddingTop = padding[0];
            int yChange = paddingTop + (paddingBottom = padding[1]);
            if (y + yChange < relativeY) {
                y += yChange;
                continue;
            }
            y += paddingTop;
            int x = 0;
            for (IWord word : line) {
                int width = word.getWidth(this.font);
                if (x <= relativeX && relativeX <= x + width) {
                    return word;
                }
                if ((x += width) <= relativeX) continue;
                break;
            }
            y += paddingBottom;
        }
        return null;
    }

    int[] getVerticalPadding(ArrayList<IWord> line) {
        int padUp = 0;
        int padDown = 0;
        for (IWord word : line) {
            padUp = Math.max(word.getPaddingAbove(), padUp);
            padDown = Math.max(word.getWordHeight(), padDown);
        }
        return new int[]{padUp, padDown};
    }

    @Override
    public void draw(DocViewer doc, int ox, int oy, String hoveredLink) {
        int y = 0;
        try {
            for (ArrayList<IWord> line : this.text) {
                int x = 0;
                int[] padding = this.getVerticalPadding(line);
                int paddingTop = padding[0];
                int paddingBottom = padding[1];
                y += paddingTop;
                for (IWord word : line) {
                    boolean hover = hoveredLink != null && hoveredLink.equals(word.getLink());
                    x += word.draw(ox + x, oy + y, hover, this.font);
                }
                y += paddingBottom;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

