/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth.cmd;

import factorization.truth.DocumentationModule;
import factorization.truth.api.IClientTypesetter;
import factorization.truth.api.IHtmlTypesetter;
import factorization.truth.api.ITokenizer;
import factorization.truth.api.ITypesetCommand;
import factorization.truth.api.ITypesetter;
import factorization.truth.api.TruthError;
import factorization.truth.word.ItemWord;
import factorization.util.DataUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CmdItem
implements ITypesetCommand {
    ItemWord getWord(ITypesetter out, ITokenizer tokenizer) throws TruthError {
        ArrayList<Object> items;
        String itemName = tokenizer.getParameter("No item specified");
        String stackSizeS = tokenizer.getOptionalParameter();
        if (stackSizeS == null) {
            items = DocumentationModule.lookup(itemName);
        } else {
            String dmgS = tokenizer.getOptionalParameter();
            if (dmgS == null) {
                dmgS = "0";
            }
            int dmg = Integer.parseInt(dmgS);
            int stackSize = Integer.parseInt(stackSizeS);
            items = new ArrayList();
            Block b = DataUtil.getBlockFromName(itemName);
            Item it = DataUtil.getItemFromName(itemName);
            if (b != null) {
                items.add(new ItemStack(b, stackSize, dmg));
            } else if (it != null) {
                items.add(new ItemStack(it, stackSize, dmg));
            } else {
                throw new TruthError("Could not find block or item: " + itemName);
            }
        }
        if (items == null || items.isEmpty()) {
            throw new TruthError(itemName + " no such item");
        }
        if (items.size() == 1) {
            return new ItemWord((ItemStack)items.get(0));
        }
        ItemStack[] theItems = items.toArray(new ItemStack[items.size()]);
        return new ItemWord(theItems);
    }

    @Override
    public void callClient(IClientTypesetter out, ITokenizer tokenizer) throws TruthError {
        out.write(this.getWord(out, tokenizer));
    }

    @Override
    public void callHTML(IHtmlTypesetter out, ITokenizer tokenizer) throws TruthError {
        ItemWord word = this.getWord(out, tokenizer);
        out.putItem(word.getItem(), word.getLink());
    }
}

