/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth.export;

import factorization.truth.AbstractTypesetter;
import factorization.truth.api.IHtmlTypesetter;
import factorization.truth.api.ITokenizer;
import factorization.truth.api.ITypesetCommand;
import factorization.truth.api.IWord;
import factorization.truth.api.TruthError;
import factorization.truth.word.Word;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class HtmlConversionTypesetter
extends AbstractTypesetter
implements IHtmlTypesetter {
    PrintStream out;
    final String root;
    static String found_icon = null;

    public HtmlConversionTypesetter(String domain, OutputStream out, String root) {
        super(domain);
        this.out = new PrintStream(out);
        this.root = root;
    }

    @Override
    public void html(String text) {
        this.out.print(text);
    }

    public static String esc(String s) {
        return s.replace("&", "&amp;").replace(">", "&gt;");
    }

    @Override
    public String img(String img) {
        if (!img.contains(":")) {
            img = "minecraft:" + img;
        }
        String[] parts = img.split(":", 2);
        String domain = parts[0];
        String path = parts[1];
        if (!path.endsWith(".png")) {
            path = path + ".png";
        }
        return this.root + "resources/" + domain + "/textures/" + path;
    }

    @Override
    public void writeErrorMessage(String msg) {
        this.html("<span class=\"manualerror\">" + msg + "</s>");
    }

    @Override
    protected void runWord(String word) {
        this.html(word);
    }

    @Override
    protected void runCommand(ITypesetCommand cmd, ITokenizer tokenizer) throws TruthError {
        cmd.callHTML(this, tokenizer);
    }

    @Override
    public void putItem(ItemStack theItem, String link) {
        String imgType = null;
        IIcon iconIndex = null;
        if (theItem != null) {
            imgType = theItem.func_94608_d() == 1 ? "items" : "blocks";
            iconIndex = theItem.func_77954_c();
        }
        if (iconIndex == null) {
            imgType = "items";
            found_icon = "factorization:transparent_item";
        } else {
            found_icon = iconIndex.func_94215_i();
            if (!found_icon.contains(":")) {
                found_icon = "minecraft:" + found_icon;
            }
        }
        String[] parts = found_icon.split(":", 2);
        String namespace = parts[0];
        String path = parts[1];
        found_icon = namespace + ":" + imgType + "/" + path;
        this.html("<img class=\"" + imgType + "\" src=\"" + this.img(found_icon) + "\" />");
        found_icon = null;
    }

    @Override
    public String getRoot() {
        return this.root;
    }

    @Override
    public void write(ItemStack stack) {
        this.putItem(stack, null);
    }

    @Override
    public void write(ItemStack[] stacks) {
        if (stacks.length > 0) {
            this.putItem(stacks[0], null);
        }
    }

    @Override
    public void write(Collection<ItemStack> stacks) {
        block0: {
            Iterator<ItemStack> iterator = stacks.iterator();
            if (!iterator.hasNext()) break block0;
            ItemStack stack = iterator.next();
            this.putItem(stack, null);
        }
    }

    @Override
    public void write(IWord word) {
        ((Word)word).writeHtml(this);
    }
}

