/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth.gen;

import com.google.common.base.Splitter;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import factorization.truth.api.IDocGenerator;
import factorization.truth.api.ITypesetter;
import factorization.truth.api.TruthError;
import factorization.truth.word.ClipboardWord;
import factorization.truth.word.TextWord;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.minecraftforge.common.MinecraftForge;

public class EventbusViewer
implements IDocGenerator {
    Splitter split = Splitter.on((Pattern)Pattern.compile("(?=[.=A-Z])"));

    @Override
    public void process(ITypesetter out, String arg) throws TruthError {
        if ("".equals(arg)) {
            arg = null;
        }
        this.inspectBus(out, MinecraftForge.EVENT_BUS, "Forge Event Bus", arg);
        this.inspectBus(out, FMLCommonHandler.instance().bus(), "FML Event Bus", arg);
        this.inspectBus(out, MinecraftForge.ORE_GEN_BUS, "Ore Gen Bus", arg);
        this.inspectBus(out, MinecraftForge.TERRAIN_GEN_BUS, "Terrain Gen Bus", arg);
    }

    void inspectBus(ITypesetter out, EventBus bus, String busName, String matchEvent) throws TruthError {
        block12: {
            ArrayList eventTypes;
            block11: {
                ConcurrentHashMap listeners = (ConcurrentHashMap)ReflectionHelper.getPrivateValue(EventBus.class, (Object)bus, (String[])new String[]{"listeners"});
                if (listeners == null) {
                    out.write("Reflection failed!");
                    return;
                }
                HashSet<Method> methodsSet = new HashSet<Method>();
                HashSet eventTypesSet = new HashSet();
                for (Map.Entry entry : listeners.entrySet()) {
                    Object eventHandler = entry.getKey();
                    ArrayList eventListeners = (ArrayList)entry.getValue();
                    for (Method method : eventHandler.getClass().getMethods()) {
                        if (method.getAnnotation(SubscribeEvent.class) == null) continue;
                        methodsSet.add(method);
                        eventTypesSet.add(method.getParameterTypes()[0]);
                    }
                }
                ArrayList methods = new ArrayList(methodsSet);
                Collections.sort(methods, new Comparator<Method>(){

                    @Override
                    public int compare(Method o1, Method o2) {
                        int c = o1.getClass().getCanonicalName().compareTo(o2.getClass().getCanonicalName());
                        if (c != 0) {
                            return c;
                        }
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                eventTypes = new ArrayList(eventTypesSet);
                Collections.sort(eventTypes, new Comparator<Class<?>>(){

                    @Override
                    public int compare(Class<?> o1, Class<?> o2) {
                        return o1.getCanonicalName().compareTo(o2.getCanonicalName());
                    }
                });
                if (matchEvent == null) break block11;
                boolean first = true;
                for (Method m : methodsSet) {
                    SubscribeEvent a;
                    String eventTypeName = m.getParameterTypes()[0].getCanonicalName();
                    if (!matchEvent.equals(eventTypeName)) continue;
                    if (first) {
                        out.write("\\newpage");
                        out.write("\\title{" + busName + "}\\nl");
                        this.outSplit(out, matchEvent, "cgi/eventbus/" + matchEvent);
                        out.write("\n\n");
                        first = false;
                    }
                    if ((a = m.getAnnotation(SubscribeEvent.class)).priority() == EventPriority.NORMAL && !a.receiveCanceled()) {
                        out.write("@SubscribeEvent\\nl");
                    } else {
                        out.write(a.toString().replace("cpw.mods.fml.common.eventhandler.", "") + "\\nl");
                    }
                    String handlerName = m.getDeclaringClass().getCanonicalName();
                    this.outSplit(out, handlerName + "." + m.getName(), null);
                    out.write(" [");
                    out.write(new ClipboardWord("/scrap BusRemove " + handlerName + " " + m.getName()));
                    out.write("]\n\n");
                }
                break block12;
            }
            if (eventTypes.isEmpty()) break block12;
            out.write("\\newpage");
            out.write("\\title{Events: " + busName + "}\n\n");
            for (Class<?> eventType : eventTypes) {
                String simpleName;
                String canonicalName = eventType.getCanonicalName();
                if (eventType.isMemberClass()) {
                    Class<?> highest = eventType;
                    while (highest.getEnclosingClass() != null) {
                        highest = highest.getEnclosingClass();
                    }
                    String hc = highest.getCanonicalName();
                    int start = hc.length();
                    String ec = canonicalName;
                    simpleName = ec.substring(start -= highest.getSimpleName().length());
                } else {
                    simpleName = eventType.getSimpleName();
                }
                this.outSplit(out, simpleName, "cgi/eventbus/" + canonicalName);
                out.write("\\nl");
            }
        }
    }

    void outSplit(ITypesetter out, String text, String link) {
        for (String t : this.split.split((CharSequence)text)) {
            TextWord word = new TextWord(t);
            word.setLink(link);
            out.write(word);
        }
    }
}

