/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth.gen;

import com.google.common.collect.HashMultimap;
import factorization.truth.DocumentationModule;
import factorization.truth.api.IDocGenerator;
import factorization.truth.api.ITypesetter;
import factorization.truth.api.TruthError;
import factorization.util.LangUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;

public class ItemListViewer
implements IDocGenerator {
    @Override
    public void process(ITypesetter sb, String arg) throws TruthError {
        if (arg.equalsIgnoreCase("all")) {
            this.listAll(sb, null);
            return;
        }
        CreativeTabs found = null;
        for (CreativeTabs ct : CreativeTabs.field_78032_a) {
            if (!ct.func_78013_b().equalsIgnoreCase(arg)) continue;
            found = ct;
            break;
        }
        if (found != null) {
            this.listAll(sb, found);
        } else {
            this.listTabs(sb);
        }
    }

    void listTabs(ITypesetter sb) throws TruthError {
        String ret = "";
        ret = ret + "\\title{Item Categories}\n\n";
        ret = ret + "\n\n\\link{cgi/items/all}{All Items}";
        for (CreativeTabs ct : CreativeTabs.field_78032_a) {
            if (ct == CreativeTabs.field_78027_g || ct == CreativeTabs.field_78036_m) continue;
            String text = ct.func_78013_b();
            ret = ret + "\\nl\\link{cgi/items/" + text + "}{" + LangUtil.translateThis("itemGroup." + text) + "}";
        }
        sb.write(ret);
    }

    void listAll(ITypesetter out, CreativeTabs ct) throws TruthError {
        if (ct == null) {
            out.write("\\title{All Items}");
        } else {
            String title = ct.func_78013_b();
            title = LangUtil.translateThis("itemGroup." + title);
            out.write("\\title{" + title + "}");
        }
        out.write("\n\n");
        int size = DocumentationModule.getNameItemCache().size();
        HashMultimap found = HashMultimap.create((int)size, (int)1);
        ArrayList<String> toSort = new ArrayList<String>();
        for (Map.Entry<String, ArrayList<ItemStack>> pair : DocumentationModule.getNameItemCache().entrySet()) {
            ArrayList<ItemStack> items = pair.getValue();
            for (ItemStack is : items) {
                if (ct != null && is.func_77973_b().func_77640_w() != ct) continue;
                String name = is.func_82833_r();
                if (!found.containsKey((Object)name)) {
                    toSort.add(name);
                }
                found.put((Object)name, (Object)is);
            }
        }
        Collections.sort(toSort, String.CASE_INSENSITIVE_ORDER);
        for (String name : toSort) {
            for (ItemStack is : found.get((Object)name)) {
                if (is == null) continue;
                out.write(is);
                out.write(" ");
                out.write(name);
                out.write("\n\n");
            }
        }
    }
}

