/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth.gen;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import factorization.truth.api.IDocGenerator;
import factorization.truth.api.ITypesetter;
import factorization.truth.api.TruthError;

public class ModDependViewer
implements IDocGenerator {
    @Override
    public void process(ITypesetter out, String arg) throws TruthError {
        if ("".equals(arg)) {
            this.listMods(out);
        } else {
            this.showMod(out, arg);
        }
    }

    private void showMod(ITypesetter out, String arg) throws TruthError {
        String link;
        ModContainer mod = null;
        for (ModContainer it : Loader.instance().getActiveModList()) {
            if (!it.getModId().equals(arg)) continue;
            mod = it;
            break;
        }
        if (mod == null) {
            out.write("Mod not found: " + arg);
            return;
        }
        out.write(String.format("\\title{%s}\n\n", mod.getName()));
        out.write("Modid: " + arg + "\n\n");
        if (!mod.getDependencies().isEmpty()) {
            out.write("\\b{Dependencies}\n\n");
            for (ArtifactVersion version : mod.getDependencies()) {
                link = String.format("\\link{cgi/mods/%s}{%s}", version.getLabel(), version.getLabel());
                out.write(link + ": " + version.getRangeString() + "\\nl");
            }
        }
        if (!mod.getDependants().isEmpty()) {
            out.write("\\b{Dependents}\n\n");
            for (ArtifactVersion version : mod.getDependants()) {
                link = String.format("\\link{cgi/mods/%s}{%s}", version.getLabel(), version.getLabel());
                out.write(link + ": " + version.getRangeString() + "\\nl");
            }
        }
    }

    private void listMods(ITypesetter out) throws TruthError {
        out.write("\\title{Installed Mods}\n\n");
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            out.write(String.format("\\link{cgi/mods/%s}{%s}\n\n", mod.getModId(), mod.getName()));
        }
    }
}

