/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth.gen;

import factorization.truth.api.IDocGenerator;
import factorization.truth.api.ITypesetter;
import factorization.truth.api.TruthError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryViewer
implements IDocGenerator {
    @Override
    public void process(ITypesetter out, String arg) throws TruthError {
        Arrays.asList(OreDictionary.getOreNames());
        ArrayList names = new ArrayList();
        Collections.addAll(names, OreDictionary.getOreNames());
        Collections.sort(names);
        ArrayList<String> bountiful = new ArrayList<String>();
        ArrayList<String> empties = new ArrayList<String>();
        ArrayList<String> singles = new ArrayList<String>();
        for (String name : names) {
            ArrayList ores = OreDictionary.getOres((String)name);
            if (ores == null || ores.isEmpty()) {
                empties.add(name);
                continue;
            }
            if (ores.size() == 1) {
                singles.add(name);
                continue;
            }
            bountiful.add(name);
        }
        boolean prev = false;
        if (!bountiful.isEmpty()) {
            prev = true;
            for (String name : bountiful) {
                this.show(out, name);
            }
        }
        if (!singles.isEmpty()) {
            if (prev) {
                out.write("\\newpage");
            }
            prev = true;
            for (String name : singles) {
                this.show(out, name);
            }
        }
        if (!empties.isEmpty()) {
            if (prev) {
                out.write("\\newpage");
            }
            prev = true;
            out.write("\\title{Empty Lists}");
            for (String name : empties) {
                out.write("\\nl");
                out.write(name);
            }
        }
    }

    void show(ITypesetter out, String name) throws TruthError {
        ArrayList ores = OreDictionary.getOres((String)name);
        out.write("\\seg");
        out.write(String.format("\\nl %s: ", name));
        for (ItemStack is : ores) {
            out.write(is);
        }
        out.write("\\endseg");
    }
}

