/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth.gen.recipe;

import factorization.truth.api.IObjectWriter;
import factorization.truth.gen.recipe.RecipeViewer;
import factorization.truth.gen.recipe.ReflectionExpression;
import factorization.truth.word.LocalizedWord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StringUtils;

public class GuidedReflectionWriter<T>
implements IObjectWriter<T> {
    final ReflectionExpression[] input;
    final ReflectionExpression[] catalyst;
    final ReflectionExpression[] output;
    final String text;

    public static void register(NBTTagCompound tag) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        GuidedReflectionWriter writer = new GuidedReflectionWriter(tag);
        String label = tag.func_74779_i("category").split("\\|")[0];
        RecipeViewer.instance.guiders.put(label, writer);
    }

    private GuidedReflectionWriter(NBTTagCompound tag) throws NoSuchMethodException, NoSuchFieldException {
        this.input = this.read(tag, "input");
        this.catalyst = this.read(tag, "catalyst");
        this.output = this.read(tag, "output");
        this.text = tag.func_74779_i("text");
    }

    ReflectionExpression[] read(NBTTagCompound tag, String keyName) throws NoSuchMethodException, NoSuchFieldException {
        ArrayList<ReflectionExpression> out = new ArrayList<ReflectionExpression>();
        NBTTagList list = tag.func_150295_c(keyName, 8);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            String s = list.func_150307_f(i);
            out.add(new ReflectionExpression(s));
        }
        return out.toArray(new ReflectionExpression[out.size()]);
    }

    @Override
    public void writeObject(List out, T val, IObjectWriter<Object> generic) {
        this.write(this.output, out, val, generic);
        this.write(this.input, out, val, generic);
        this.write(this.catalyst, out, val, generic);
        if (!StringUtils.func_151246_b((String)this.text)) {
            out.add(this.text);
        }
    }

    private void write(ReflectionExpression[] exprList, List out, T val, IObjectWriter<Object> generic) {
        boolean maybeGeneric = exprList == this.output && this.output.length == 1;
        for (ReflectionExpression expr : exprList) {
            Object v;
            try {
                v = expr.get(val);
            }
            catch (Throwable t) {
                t.printStackTrace();
                out.add("<ERR>");
                continue;
            }
            if (expr.prefix != null) {
                out.add(new LocalizedWord(expr.prefix));
                out.add(": ");
            }
            if (v == null) {
                v = "null";
            }
            if (v instanceof String) {
                out.add(v);
                out.add("\\nl");
                continue;
            }
            ItemStack is = null;
            if (maybeGeneric) {
                Object next;
                Collection c;
                if (v instanceof ItemStack) {
                    is = (ItemStack)v;
                } else if (v instanceof ItemStack[]) {
                    ItemStack[] array = (ItemStack[])v;
                    if (array.length > 0) {
                        is = array[0];
                    }
                } else if (v instanceof Collection && (c = (Collection)v).size() == 1 && (next = c.iterator().next()) instanceof ItemStack) {
                    is = (ItemStack)next;
                }
            }
            if (is != null) {
                RecipeViewer.genericRecipePrefix(out, is);
                continue;
            }
            generic.writeObject(out, v, generic);
            out.add("\\nl");
        }
    }
}

