/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth.gen.recipe;

import cpw.mods.fml.common.event.FMLInterModComms;
import factorization.shared.Core;
import factorization.truth.DocumentationModule;
import factorization.truth.api.DocReg;
import factorization.truth.api.IDocGenerator;
import factorization.truth.api.IObjectWriter;
import factorization.truth.api.ITypesetter;
import factorization.truth.api.TruthError;
import factorization.truth.gen.recipe.GuidedReflectionWriter;
import factorization.truth.gen.recipe.StandardObjectWriters;
import factorization.truth.word.ItemWord;
import factorization.truth.word.Word;
import factorization.util.ItemUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeViewer
implements IDocGenerator,
IObjectWriter<Object> {
    static RecipeViewer instance;
    HashMap<String, ArrayList<ArrayList>> recipeCategories = null;
    HashMap<String, IObjectWriter<Object>> guiders = new HashMap();
    ArrayList<String> categoryOrder = new ArrayList();
    int recursion;
    static int MAX_RECURSION;

    public RecipeViewer() {
        if (instance == null) {
            instance = this;
        }
    }

    public static void resetCache() {
        if (instance == null) {
            return;
        }
        RecipeViewer.instance.recipeCategories = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(ITypesetter out, String arg) throws TruthError {
        StandardObjectWriters.setup();
        if (this.recipeCategories == null || Boolean.getBoolean("fz.forceRecipeRefresh")) {
            this.categoryOrder.clear();
            this.recipeCategories = new HashMap();
            Core.logInfo("Loading recipe list", new Object[0]);
            this.loadRecipes();
            Core.logInfo("Done", new Object[0]);
        }
        if (arg == null || arg.equalsIgnoreCase("categories") || arg.isEmpty()) {
            out.write("\\title{Recipe Categories}\n\n");
            for (String cat : this.categoryOrder) {
                out.write(String.format("\\link{cgi/recipes/category/%s}{\\local{%s}}\\nl", cat, cat));
            }
            return;
        } else if (arg.startsWith("category/")) {
            String cat = arg.replace("category/", "");
            if (!this.recipeCategories.containsKey(cat)) throw new TruthError("Category not found: " + arg);
            ArrayList<ArrayList> recipeList = this.recipeCategories.get(cat);
            this.writeRecipes(out, null, false, cat, recipeList, null);
            return;
        } else {
            ArrayList<Object> matchers = null;
            boolean mustBeResult = false;
            if (!arg.equalsIgnoreCase("all")) {
                if (arg.startsWith("for/")) {
                    mustBeResult = true;
                    arg = arg.replace("for/", "");
                }
                if ((matchers = DocumentationModule.getNameItemCache().get(arg)) == null || matchers.size() == 0) {
                    throw new TruthError("Couldn't find item: " + arg);
                }
                out.write("\\nl");
            }
            if (matchers == null) {
                matchers = new ArrayList();
                matchers.add(null);
            }
            HashSet<ArrayList> previously_found = new HashSet<ArrayList>();
            for (ItemStack itemStack : matchers) {
                for (String cat : this.categoryOrder) {
                    ArrayList<ArrayList> recipeList;
                    int got = this.writeRecipes(out, itemStack, mustBeResult, cat, recipeList = this.recipeCategories.get(cat), previously_found);
                    if (got <= 0) continue;
                    out.write("\\nl");
                }
            }
        }
    }

    int writeRecipes(ITypesetter out, ItemStack matching, boolean mustBeResult, String categoryName, ArrayList<ArrayList> recipes, HashSet<ArrayList> previously_found) throws TruthError {
        int got = 0;
        if (matching == null) {
            for (ArrayList recipe : recipes) {
                this.writeRecipe(out, recipe);
                ++got;
            }
        } else {
            boolean first = true;
            for (ArrayList recipe : recipes) {
                if (!this.recipeMatches(recipe, matching, mustBeResult) || previously_found != null && !previously_found.add(recipe)) continue;
                if (first) {
                    first = false;
                    if (categoryName != null) {
                        out.write("\\u{\\local{" + categoryName + "}}\n\n");
                    }
                }
                this.writeRecipe(out, recipe);
                ++got;
            }
        }
        return got;
    }

    boolean recipeMatches(ArrayList recipe, ItemStack matching, boolean mustBeResult) {
        for (Object part : recipe) {
            if (!(part instanceof ItemWord)) continue;
            ItemWord iw = (ItemWord)part;
            if (iw.is != null && ItemUtil.swordSimilar(iw.is, matching)) {
                return true;
            }
            if (iw.entries != null) {
                for (ItemStack is : iw.entries) {
                    if (!ItemUtil.identical(is, matching) && !ItemUtil.wildcardSimilar(is, matching)) continue;
                    return true;
                }
            }
            if (!mustBeResult) continue;
            return false;
        }
        return false;
    }

    void writeRecipe(ITypesetter out, ArrayList parts) {
        if (parts.isEmpty()) {
            return;
        }
        try {
            out.write("\\seg");
            for (Object part : parts) {
                if (part instanceof String) {
                    out.write((String)part);
                    continue;
                }
                out.write((Word)part);
            }
            out.write("\\endseg\\nl");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void handleImc(FMLInterModComms.IMCMessage message) throws Throwable {
        if (message.key.equals("AddRecipeCategory")) {
            RecipeViewer.addRecipeCategory(message.getStringValue());
        } else if (message.key.equals("AddRecipeCategoryGuided")) {
            NBTTagCompound tag = message.getNBTValue();
            RecipeViewer.addRecipeCategory(tag.func_74779_i("category"));
            GuidedReflectionWriter.register(tag);
        }
    }

    static void addRecipeCategory(String msg) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        String[] cmd = msg.split("\\|");
        String key = cmd[0];
        String className = cmd[1];
        String fieldName = cmd[2];
        Class<?> kl = RecipeViewer.class.getClassLoader().loadClass(className);
        Field field = kl.getField(fieldName);
        Set obj = field.get(null);
        if (!(obj instanceof Iterable)) {
            String[] getter_names = new String[]{"getRecipes", "recipes", "allRecipes", "getAllRecipes"};
            Object found = null;
            Class<?> cl = obj.getClass();
            for (String name : getter_names) {
                try {
                    Method getter = cl.getMethod(name, new Class[0]);
                    found = getter.invoke(obj, new Object[0]);
                    if (found == null) continue;
                    break;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (found != null) {
                obj = found;
            }
        }
        if (obj instanceof Map) {
            obj = ((Map)((Object)obj)).entrySet();
        }
        if (obj instanceof Iterable) {
            DocReg.registerRecipeList(key, obj);
        } else {
            Core.logWarning("Unable to load recipe list provided by IMC message, obtained object is neither Iterable nor Map: " + msg, new Object[0]);
        }
    }

    void loadRecipes() {
        this.putCategory("Workbench", CraftingManager.func_77594_a().func_77592_b());
        this.putCategory("Furnace", FurnaceRecipes.func_77602_a().func_77599_b().entrySet());
        HashMap<String, ArrayList> ores = new HashMap<String, ArrayList>();
        for (String name : OreDictionary.getOreNames()) {
            ores.put("\"" + name + "\"", OreDictionary.getOres((String)name));
        }
        this.putCategory("Ore Dictionary", ores.entrySet());
        for (Map.Entry entry : DocReg.customRecipes.entrySet()) {
            this.putCategory((String)entry.getKey(), (Iterable)entry.getValue());
        }
    }

    void putCategory(String label, Iterable list) {
        try {
            RecipeViewer guide = this.guiders.get(label);
            if (guide == null) {
                guide = this;
            }
            this.recipeCategories.put(label, this.addAll(guide, list));
            this.categoryOrder.add(label);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private ArrayList<ArrayList> addAll(IObjectWriter<Object> guide, Iterable list) {
        ArrayList<ArrayList> generated = new ArrayList<ArrayList>();
        for (Object obj : list) {
            ArrayList entry = new ArrayList();
            this.recursion = 0;
            guide.writeObject(entry, obj, this);
            if (entry.isEmpty()) continue;
            generated.add(entry);
        }
        return generated;
    }

    public static String getDisplayName(ItemStack is) {
        if (is == null) {
            return "null";
        }
        try {
            return is.func_82833_r();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "ERROR";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(List out, Object val, IObjectWriter<Object> generic) {
        if (this.recursion > MAX_RECURSION) {
            return;
        }
        ++this.recursion;
        try {
            this.addRecipe(out, val);
        }
        finally {
            --this.recursion;
        }
    }

    public void addRecipe(List out, Object obj) {
        if (obj instanceof IRecipe) {
            RecipeViewer.genericRecipePrefix(out, (IRecipe)obj);
        }
        int origLen = out.size();
        IObjectWriter writer = IObjectWriter.adapter.cast(obj);
        writer.writeObject(out, obj, this);
        if (out.size() == origLen) {
            out.add(obj.toString());
        }
    }

    public static Object genericRecipePrefix(List sb, IRecipe recipe) {
        ItemStack output = recipe.func_77571_b();
        return RecipeViewer.genericRecipePrefix(sb, output);
    }

    public static ItemStack genericRecipePrefix(List sb, ItemStack output) {
        if (output == null) {
            return null;
        }
        if (output.func_77973_b() == null) {
            return null;
        }
        sb.add(new ItemWord(output));
        sb.add(" \\b{" + RecipeViewer.getDisplayName(output) + "}\\vpad{15}\\nl");
        return output;
    }

    static {
        MAX_RECURSION = 5;
    }
}

