/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth.gen.recipe;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

class ReflectionComponent {
    final Method method;
    final Field field;
    final String nbtKey;

    ReflectionComponent(Class head, String part) throws NoSuchMethodException, NoSuchFieldException {
        if (part.startsWith("'")) {
            this.method = null;
            this.field = null;
            this.nbtKey = part.replaceAll("'", "");
        } else if (part.endsWith("()")) {
            this.field = null;
            this.nbtKey = null;
            this.method = this.getInterfaceMethod(head, part.replace("()", ""));
            this.method.setAccessible(true);
        } else {
            this.method = null;
            this.nbtKey = null;
            this.field = head.getField(part);
            this.field.setAccessible(true);
        }
    }

    Method getInterfaceMethod(Class head, String part) throws NoSuchMethodException {
        for (Class<?> i : head.getInterfaces()) {
            try {
                return i.getMethod(part, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return head.getMethod(part, new Class[0]);
    }

    Class<?> getType() {
        if (this.nbtKey != null) {
            return NBTBase.class;
        }
        if (this.field != null) {
            return this.field.getType();
        }
        return this.method.getReturnType();
    }

    Object get(Object src) throws IllegalAccessException, InvocationTargetException {
        if (src == null) {
            return null;
        }
        if (this.nbtKey != null) {
            NBTTagCompound tag = (NBTTagCompound)src;
            NBTBase value = tag.func_74781_a(this.nbtKey);
            switch (value.func_74732_a()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return "" + ((NBTTagByte)value).func_150290_f();
                }
                case 2: {
                    return "" + ((NBTTagShort)value).func_150289_e();
                }
                case 3: {
                    return "" + ((NBTTagInt)value).func_150287_d();
                }
                case 4: {
                    return "" + ((NBTTagLong)value).func_150291_c();
                }
                case 5: {
                    return "" + ((NBTTagFloat)value).func_150288_h();
                }
                case 6: {
                    return "" + ((NBTTagDouble)value).func_150286_g();
                }
                case 7: {
                    return null;
                }
                case 8: {
                    return ((NBTTagString)value).func_150285_a_();
                }
                case 9: {
                    return null;
                }
                case 10: {
                    return value;
                }
                case 11: {
                    return null;
                }
            }
            return null;
        }
        if (this.field != null) {
            return this.field.get(src);
        }
        return this.method.invoke(src, new Object[0]);
    }
}

