/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth.gen.recipe;

import factorization.truth.api.IObjectWriter;
import factorization.truth.gen.recipe.RecipeViewer;
import factorization.truth.word.TextWord;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.minecraft.item.crafting.IRecipe;

public class ReflectionWriter
implements IObjectWriter<Object> {
    int recursion = 0;

    @Override
    public void writeObject(List out, Object val, IObjectWriter<Object> generic) {
        try {
            this.addRecipeWithReflection(out, val, generic);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    boolean writeDirect(List out, Object val, IObjectWriter<Object> generic) {
        IObjectWriter writer = IObjectWriter.adapter.cast(val);
        if (writer != this) {
            writer.writeObject(out, val, generic);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRecipeWithReflection(List out, Object val, IObjectWriter<Object> generic) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.recursion > 4) {
            out.add(new TextWord("\u2026"));
            return;
        }
        ++this.recursion;
        try {
            this.do_addRecipeWithReflection(out, val, generic);
        }
        finally {
            --this.recursion;
        }
    }

    void do_addRecipeWithReflection(List out, Object val, IObjectWriter<Object> generic) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Field[] fields;
        if (this.writeDirect(out, val, generic)) {
            return;
        }
        Object recipeOutput = this;
        if (val instanceof IRecipe) {
            recipeOutput = RecipeViewer.genericRecipePrefix(out, (IRecipe)val);
        }
        ArrayList<String> properties = new ArrayList<String>();
        HashSet<Object> seen = new HashSet<Object>();
        Class<?> valClass = val.getClass();
        if ((valClass.getModifiers() & 1) == 0) {
            return;
        }
        for (Method method : valClass.getMethods()) {
            Object v;
            Type[] canThrow;
            String name;
            if (method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE || (method.getModifiers() & 8) != 0 || (method.getModifiers() & 1) == 0 || method.getDeclaringClass() != valClass || "toString".equals(name = method.getName()) || "hashCode".equals(name) || "clone".equals(name)) continue;
            if (name.startsWith("get")) {
                name = name.replaceFirst("get", "").toLowerCase(Locale.ROOT);
                properties.add(name);
            }
            if ((canThrow = method.getGenericExceptionTypes()) != null && canThrow.length != 0 || (v = method.invoke(val, new Object[0])) == recipeOutput || v == null || !seen.add(v)) continue;
            this.put(out, generic, name, v);
        }
        for (Field f : fields = valClass.getDeclaredFields()) {
            Object v;
            if (f.getName().contains("$") || properties.contains(f.getName()) || (f.getModifiers() & 8) != 0) continue;
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            if ((v = f.get(val)) == recipeOutput || v == null || !seen.add(v)) continue;
            this.put(out, generic, f.getName(), v);
        }
    }

    private void put(List out, IObjectWriter<Object> generic, String name, Object v) throws IllegalAccessException, InvocationTargetException {
        ArrayList tmp = new ArrayList();
        if (this.writeDirect(tmp, v, generic)) {
            out.add(name + ": ");
            out.addAll(tmp);
            out.add("\\nl ");
        } else {
            this.addRecipeWithReflection(out, v, generic);
        }
    }
}

