/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth.gen.recipe;

import cpw.mods.fml.relauncher.ReflectionHelper;
import factorization.api.adapter.Adapter;
import factorization.api.adapter.GenericAdapter;
import factorization.common.FzConfig;
import factorization.truth.api.IObjectWriter;
import factorization.truth.gen.FluidViewer;
import factorization.truth.gen.recipe.ReflectionWriter;
import factorization.truth.word.ItemWord;
import factorization.truth.word.TextWord;
import factorization.truth.word.Word;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

class StandardObjectWriters {
    static boolean is_setup = false;

    StandardObjectWriters() {
    }

    private static void reg(Class<?> klass, IObjectWriter out) {
        IObjectWriter.adapter.register(klass, out);
    }

    static void setup() {
        if (is_setup) {
            return;
        }
        is_setup = true;
        StandardObjectWriters.reg(ItemStack.class, new WriteItemStack());
        StandardObjectWriters.reg(Item.class, new WriteItem());
        StandardObjectWriters.reg(Block.class, new WriteBlock());
        StandardObjectWriters.reg(String.class, new WriteStringOreDictionary());
        StandardObjectWriters.reg(Number.class, new WriteObjectToString());
        StandardObjectWriters.reg(NBTBase.class, new WriteObjectToString());
        StandardObjectWriters.reg(FluidStack.class, new WriteFluidStack());
        StandardObjectWriters.reg(Fluid.class, new WriteFluid());
        StandardObjectWriters.reg(Collection.class, new WriteCollection());
        StandardObjectWriters.reg(ShapedOreRecipe.class, new WriteShapedOreRecipe());
        StandardObjectWriters.reg(ShapedRecipes.class, new WriteShapedRecipe());
        StandardObjectWriters.reg(ShapelessOreRecipe.class, new WriteShapelessOreRecipe());
        StandardObjectWriters.reg(ShapelessRecipes.class, new WriteShapelessRecipe());
        StandardObjectWriters.reg(Map.Entry.class, new WriteEntry());
        IObjectWriter.adapter.register(new ArrayAdapter());
        if (FzConfig.enableRecipeReflection) {
            IObjectWriter.adapter.setFallbackAdapter(new GenericAdapter<Object, ReflectionWriter>(Object.class, new ReflectionWriter()));
        }
    }

    static ItemStack fixMojangRecipes(ItemStack is) {
        if (is == null) {
            return null;
        }
        if (is.field_77994_a > 1) {
            is = is.func_77946_l();
            is.field_77994_a = 1;
        }
        return is;
    }

    static Word stackOreDictionary(Object obj) {
        if (obj == null) {
            return new ItemWord((ItemStack)null);
        }
        if (obj instanceof ItemStack) {
            ItemStack is = (ItemStack)obj;
            return new ItemWord(StandardObjectWriters.fixMojangRecipes(is));
        }
        if (obj instanceof Collection) {
            Collection od = (Collection)obj;
            ItemStack[] is = new ItemStack[od.size()];
            return new ItemWord(od.toArray(is));
        }
        return new TextWord("?" + obj.toString());
    }

    private static class ArrayAdapter
    implements Adapter<Object, IObjectWriter>,
    IObjectWriter<Object> {
        private ArrayAdapter() {
        }

        @Override
        public IObjectWriter adapt(Object val) {
            return this;
        }

        @Override
        public boolean canAdapt(Class<?> valClass) {
            return valClass.isArray();
        }

        @Override
        public int priority() {
            return 10;
        }

        @Override
        public void writeObject(List out, Object val, IObjectWriter<Object> generic) {
            out.add("[");
            int len = Array.getLength(val);
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    out.add(", ");
                }
                Object v = Array.get(val, i);
                generic.writeObject(out, v, generic);
            }
            out.add("]");
        }
    }

    private static class WriteEntry
    implements IObjectWriter<Map.Entry> {
        private WriteEntry() {
        }

        @Override
        public void writeObject(List out, Map.Entry val, IObjectWriter<Object> generic) {
            generic.writeObject(out, val.getKey(), generic);
            out.add(" \u27a4 ");
            generic.writeObject(out, val.getValue(), generic);
        }
    }

    private static class WriteShapelessRecipe
    implements IObjectWriter<ShapelessRecipes> {
        private WriteShapelessRecipe() {
        }

        @Override
        public void writeObject(List out, ShapelessRecipes val, IObjectWriter<Object> generic) {
            if (val.field_77579_b == null) {
                return;
            }
            out.add("Shapeless: ");
            for (Object obj : val.field_77579_b) {
                out.add(new ItemWord((ItemStack)obj));
            }
        }
    }

    private static class WriteShapelessOreRecipe
    implements IObjectWriter<ShapelessOreRecipe> {
        private WriteShapelessOreRecipe() {
        }

        @Override
        public void writeObject(List out, ShapelessOreRecipe val, IObjectWriter<Object> generic) {
            ArrayList input = val.getInput();
            if (input == null) {
                return;
            }
            out.add("Shapeless: ");
            for (Object obj : input) {
                out.add(StandardObjectWriters.stackOreDictionary(obj));
            }
        }
    }

    private static class WriteShapedRecipe
    implements IObjectWriter<ShapedRecipes> {
        private WriteShapedRecipe() {
        }

        @Override
        public void writeObject(List out, ShapedRecipes val, IObjectWriter<Object> generic) {
            int width = val.field_77576_b;
            for (int i = 0; i < val.field_77574_d.length; ++i) {
                out.add(new ItemWord(StandardObjectWriters.fixMojangRecipes(val.field_77574_d[i])));
                if ((i + 1) % width != 0) continue;
                out.add("\\nl");
            }
        }
    }

    private static class WriteShapedOreRecipe
    implements IObjectWriter<ShapedOreRecipe> {
        private WriteShapedOreRecipe() {
        }

        @Override
        public void writeObject(List out, ShapedOreRecipe val, IObjectWriter<Object> generic) {
            int width = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)val, (String[])new String[]{"width"});
            Object[] input = val.getInput();
            int i = 0;
            for (Object in : input) {
                out.add(StandardObjectWriters.stackOreDictionary(in));
                if (++i % width != 0) continue;
                out.add("\\nl");
            }
        }
    }

    private static class WriteCollection
    implements IObjectWriter<Collection<Object>> {
        HashSet<Collection> reverseOD = new HashSet();

        private WriteCollection() {
            for (String name : OreDictionary.getOreNames()) {
                this.reverseOD.add(OreDictionary.getOres((String)name));
            }
        }

        @Override
        public void writeObject(List out, Collection<Object> val, IObjectWriter<Object> generic) {
            if (this.reverseOD.contains(val)) {
                ItemStack[] items = val.toArray(new ItemStack[val.size()]);
                out.add(new ItemWord(items));
                return;
            }
            for (Object o : val) {
                generic.writeObject(out, o, generic);
            }
        }
    }

    private static class WriteFluid
    implements IObjectWriter<Fluid> {
        private WriteFluid() {
        }

        @Override
        public void writeObject(List out, Fluid val, IObjectWriter<Object> generic) {
            out.add(FluidViewer.convert(val));
        }
    }

    private static class WriteFluidStack
    implements IObjectWriter<FluidStack> {
        private WriteFluidStack() {
        }

        @Override
        public void writeObject(List out, FluidStack val, IObjectWriter<Object> generic) {
            out.add(FluidViewer.convert(val.getFluid()));
            out.add(new TextWord(val.getLocalizedName()));
            if (val.amount == 0) {
                return;
            }
            if (val.amount % 1000 == 0) {
                out.add(new TextWord(" " + val.amount / 1000 + "B"));
            } else {
                out.add(new TextWord(" " + val.amount + "mB"));
            }
        }
    }

    private static class WriteObjectToString
    implements IObjectWriter<Object> {
        private WriteObjectToString() {
        }

        @Override
        public void writeObject(List out, Object val, IObjectWriter<Object> generic) {
            out.add(new TextWord(val.toString()));
        }
    }

    private static class WriteStringOreDictionary
    implements IObjectWriter<String> {
        final HashSet<String> knownOres = new HashSet();

        private WriteStringOreDictionary() {
            Collections.addAll(this.knownOres, OreDictionary.getOreNames());
        }

        @Override
        public void writeObject(List out, String val, IObjectWriter<Object> generic) {
            ArrayList ores;
            if (this.knownOres.contains(val) && !(ores = OreDictionary.getOres((String)val)).isEmpty()) {
                out.add(new ItemWord(ores.toArray(new ItemStack[ores.size()])));
                return;
            }
            out.add(new TextWord(val));
        }
    }

    private static class WriteBlock
    implements IObjectWriter<Block> {
        private WriteBlock() {
        }

        @Override
        public void writeObject(List out, Block val, IObjectWriter<Object> generic) {
            out.add(new ItemWord(new ItemStack(val)));
        }
    }

    private static class WriteItem
    implements IObjectWriter<Item> {
        private WriteItem() {
        }

        @Override
        public void writeObject(List out, Item val, IObjectWriter<Object> generic) {
            out.add(new ItemWord(new ItemStack(val)));
        }
    }

    private static class WriteItemStack
    implements IObjectWriter<ItemStack> {
        private WriteItemStack() {
        }

        @Override
        public void writeObject(List out, ItemStack val, IObjectWriter<Object> generic) {
            out.add(new ItemWord(val));
        }
    }
}

