/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth.minecraft;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.shared.Core;
import factorization.truth.api.DocReg;
import factorization.truth.api.IManwich;
import factorization.util.EvilUtil;
import factorization.util.ItemUtil;
import factorization.util.LangUtil;
import factorization.util.PlayerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S37PacketStatistics;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatisticsFile;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ItemManSandwich
extends ItemFood
implements IManwich {
    StatBase manwhichStatus;
    @SideOnly(value=Side.CLIENT)
    IIcon spicy;
    boolean given_recommendation;

    public ItemManSandwich(int healAmount, float saturationModifier, String itemName) {
        super(healAmount, saturationModifier, false);
        this.func_77844_a(Potion.field_76421_d.func_76396_c(), 12, 9, 1.0f);
        Core.loadBus(this);
        this.func_77655_b(itemName);
        this.func_111206_d(itemName.replaceFirst("item.", ""));
        String n = itemName + ".status";
        this.manwhichStatus = new StatBase(n, (IChatComponent)new ChatComponentTranslation(n, new Object[0])).func_75971_g();
        this.func_77625_d(1);
        this.func_77627_a(true);
        DocReg.registerManwich(this);
        Core.tab((Item)this, Core.TabType.TOOLS);
    }

    public int func_77626_a(ItemStack stack) {
        return super.func_77626_a(stack);
    }

    public float getDigSpeed(ItemStack itemstack, Block block, int metadata) {
        return super.getDigSpeed(itemstack, block, metadata);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (this.hasManual(player) > 0) {
            return stack;
        }
        return super.func_77659_a(stack, world, player);
    }

    protected void func_77849_c(ItemStack stack, World wrold, EntityPlayer player) {
        int saturationTime;
        if (player instanceof FakePlayer) {
            super.func_77849_c(stack, wrold, player);
            return;
        }
        boolean spicy = stack.func_77960_j() > 0;
        int nomage = spicy ? 7 : 1;
        StatisticsFile stats = PlayerUtil.getStatsFile(player);
        if (stats != null) {
            stats.func_150873_a(player, this.manwhichStatus, nomage);
            this.syncStat(player);
        }
        if (spicy) {
            player.func_70015_d(7);
            saturationTime = 6000;
        } else {
            player.func_70690_d(new PotionEffect(Potion.field_76431_k.func_76396_c(), 50, 1, false));
            saturationTime = 500;
        }
        player.func_70690_d(new PotionEffect(Potion.field_76443_y.func_76396_c(), saturationTime, 1, !Core.dev_environ));
        super.func_77849_c(stack, wrold, player);
    }

    @Override
    public int hasManual(EntityPlayer player) {
        if (PlayerUtil.isPlayerCreative(player)) {
            return 1;
        }
        StatisticsFile stats = PlayerUtil.getStatsFile(player);
        if (stats == null) {
            return 0;
        }
        return stats.func_77444_a(this.manwhichStatus);
    }

    @SubscribeEvent
    public void digestManwhich(PlayerEvent.Clone event) {
        if (!event.wasDeath) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        StatisticsFile stats = PlayerUtil.getStatsFile(player);
        if (stats == null) {
            return;
        }
        int sandwiches = stats.func_77444_a(this.manwhichStatus);
        if (sandwiches > 0) {
            stats.func_150873_a(player, this.manwhichStatus, sandwiches - 1);
            this.syncStat(player);
        }
    }

    @SubscribeEvent
    public void syncLoginManwhich(PlayerEvent.PlayerLoggedInEvent event) {
        this.syncStat(event.player);
    }

    public void func_77663_a(ItemStack stack, World world, Entity ent, int currentSlot, boolean isHeld) {
        if (!isHeld) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        if (ent instanceof EntityLivingBase) {
            EntityPlayer p;
            EntityLivingBase player = (EntityLivingBase)ent;
            if (ent instanceof EntityPlayer && (p = (EntityPlayer)ent).func_71039_bw()) {
                return;
            }
            if (player.field_70737_aN > 0) {
                EvilUtil.throwStack(player, stack, false);
                player.func_70062_b(0, null);
            }
        }
    }

    void syncStat(EntityPlayer _player) {
        if (!(_player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)_player;
        StatisticsFile stats = PlayerUtil.getStatsFile((EntityPlayer)player);
        if (stats == null) {
            return;
        }
        int sandwiches = stats.func_77444_a(this.manwhichStatus);
        HashMap<StatBase, Integer> statInfo = new HashMap<StatBase, Integer>();
        statInfo.put(this.manwhichStatus, sandwiches);
        player.field_71135_a.func_147359_a((Packet)new S37PacketStatistics(statInfo));
    }

    public String func_77667_c(ItemStack stack) {
        boolean spicy = stack != null && stack.func_77960_j() > 0;
        String name = super.func_77667_c(stack);
        if (spicy) {
            return name + ".spicy";
        }
        return name;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean verbose) {
        if (Core.dev_environ) {
            list.add("Sandwich level: " + this.hasManual(player));
        }
        if (PlayerUtil.isPlayerCreative(player)) {
            Core.brand(stack, player, list, verbose);
            return;
        }
        int nom = this.hasManual(player);
        String key = nom == 1 ? "item.factorization:mansandwich.nom.once" : (nom > 1 ? "item.factorization:mansandwich.nom.many" : "item.factorization:mansandwich.nom.delicious");
        String t = LangUtil.translateThis(key);
        Collections.addAll(list, t.split("\\\\n"));
        Core.brand(stack, player, list, verbose);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        if (damage > 0) {
            return this.spicy;
        }
        return super.func_77617_a(damage);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        this.field_77791_bV = reg.func_94245_a("factorization:mansandwich");
        this.spicy = reg.func_94245_a("factorization:mansandwich_spicy");
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        super.func_150895_a(item, tab, list);
        list.add(new ItemStack((Item)this, 1, 1));
    }

    @Override
    public String getManwichDomain(EntityPlayer player) {
        return "factorization";
    }

    @Override
    public void recommendManwich(EntityPlayer player) {
        if (this.given_recommendation) {
            return;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack is = player.field_71071_by.func_70301_a(i);
            if (!ItemUtil.is(is, (Item)this)) continue;
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("item.factorization:mansandwich.eatit", new Object[0]));
            return;
        }
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("item.factorization:mansandwich.hungry", new Object[0]));
        this.given_recommendation = true;
    }
}

