/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth.word;

import factorization.truth.api.IHtmlTypesetter;
import factorization.truth.word.Word;
import factorization.util.FzUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class ImgWord
extends Word {
    public final ResourceLocation resource;
    public int width = 12;
    public int height = 12;
    private static final HashMap<ResourceLocation, Pair<Integer, Integer>> size_cache = new HashMap();

    public ImgWord(ResourceLocation resource) {
        this.resource = resource;
        this.autosize();
    }

    public ImgWord(ResourceLocation resource, int width, int height) {
        this(resource);
        this.width = width;
        this.height = height;
    }

    public void scale(double scale) {
        this.width = (int)((double)this.width * scale);
        this.height = (int)((double)this.height * scale);
    }

    public String toString() {
        return this.resource + " ==> " + this.getLink();
    }

    @Override
    public int getWidth(FontRenderer font) {
        return this.width;
    }

    @Override
    public int getWordHeight() {
        return this.height - this.getPaddingAbove();
    }

    @Override
    public int draw(int x, int y, boolean hover, FontRenderer font) {
        boolean z = false;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.resource);
        Tessellator tess = new Tessellator();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tess.func_78382_b();
        tess.func_78374_a((double)(x + 0), (double)(y + 0), (double)z, 0.0, 0.0);
        tess.func_78374_a((double)(x + 0), (double)(y + this.height), (double)z, 0.0, 1.0);
        tess.func_78374_a((double)(x + this.width), (double)(y + this.height), (double)z, 1.0, 1.0);
        tess.func_78374_a((double)(x + this.width), (double)(y + 0), (double)z, 1.0, 0.0);
        tess.func_78381_a();
        return 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autosize() {
        Pair<Integer, Integer> cached = size_cache.get(this.resource);
        if (cached != null) {
            this.width = (Integer)cached.getLeft();
            this.height = (Integer)cached.getRight();
            return;
        }
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        IResource iresource = null;
        InputStream is = null;
        try {
            iresource = resourceManager.func_110536_a(this.resource);
            is = iresource.func_110527_b();
            BufferedImage bufferedimage = ImageIO.read(is);
            this.width = bufferedimage.getWidth();
            this.height = bufferedimage.getHeight();
            size_cache.put(this.resource, (Pair<Integer, Integer>)Pair.of((Object)this.width, (Object)this.height));
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FzUtil.closeNoisily("reading size of image", is);
                throw throwable;
            }
            FzUtil.closeNoisily("reading size of image", is);
        }
        FzUtil.closeNoisily("reading size of image", is);
    }

    public void fitToPage(int pageWidth, int pageHeight) {
        double h;
        double s = 1.0;
        if (this.width > pageWidth) {
            s = (double)pageWidth / (double)this.width;
        }
        if (this.height > pageHeight && (h = (double)pageHeight / (double)this.height) < s) {
            s = h;
        }
        this.scale(s);
    }

    @Override
    public void writeHtml(IHtmlTypesetter out) {
        String imgPath = out.img(this.resource.toString());
        out.html(String.format("<img width=%s height=%s src=\"%s\" />", this.width, this.height, imgPath));
    }
}

