/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth.word;

import factorization.truth.WordPage;
import factorization.truth.api.IHtmlTypesetter;
import factorization.truth.word.Word;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.EnumChatFormatting;

public class TextWord
extends Word {
    public final String text;
    private short width_cache = (short)-1;
    private static final String LINK_STYLE = "" + EnumChatFormatting.UNDERLINE;

    public TextWord(String text) {
        this.text = text;
    }

    public String toString() {
        return this.text + " ==> " + this.getLink();
    }

    @Override
    public void setLink(String link) {
        super.setLink(link);
        if (this.style.isEmpty()) {
            this.setStyle(LINK_STYLE);
        } else {
            this.setStyle(this.getStyle() + LINK_STYLE);
        }
    }

    @Override
    public int getWidth(FontRenderer font) {
        if (this.width_cache != -1) {
            return this.width_cache;
        }
        if (font == null) {
            return 0;
        }
        this.width_cache = (short)font.func_78256_a(this.style + this.text);
        return this.width_cache;
    }

    @Override
    public void setStyle(String style) {
        super.setStyle(style);
        this.width_cache = (short)-1;
    }

    @Override
    public int draw(int x, int y, boolean hover, FontRenderer font) {
        int color = this.getLinkColor(hover);
        font.func_78276_b(this.style + this.text, x, y, color);
        return this.getWidth(font);
    }

    @Override
    public void writeHtml(IHtmlTypesetter out) {
        out.html(this.text);
    }

    @Override
    public int getPaddingAbove() {
        return 2;
    }

    @Override
    public int getWordHeight() {
        return WordPage.TEXT_HEIGHT;
    }
}

