/*
 * Decompiled with CFR 0.152.
 */
package factorization.truth.word;

import factorization.shared.Core;
import factorization.truth.word.TextWord;
import java.awt.Desktop;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;

public class URIWord
extends TextWord
implements GuiYesNoCallback {
    final String uriString;
    private static final List<String> safeProtocolSchemes = Arrays.asList("http", "https");
    private GuiScreen origGui = null;
    private URI uri;

    public URIWord(String text, String uri) {
        super(text);
        this.uriString = uri;
    }

    @Override
    public boolean onClick() {
        try {
            this.uri = new URI(this.uriString);
            String scheme = this.uri.getScheme().toLowerCase(Locale.ROOT);
            if (!safeProtocolSchemes.contains(scheme)) {
                this.uri = null;
                throw new URISyntaxException(this.uriString, "Unsupported protocol: " + scheme);
            }
            Minecraft mc = Minecraft.func_71410_x();
            this.origGui = mc.field_71462_r;
            if (mc.field_71474_y.field_74358_q) {
                mc.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, this.uriString, 0, false));
            } else {
                URIWord.visitLink(this.uri);
            }
        }
        catch (URISyntaxException urisyntaxexception) {
            Core.logWarning("Can't open url for " + this.uriString, urisyntaxexception);
        }
        return true;
    }

    public void func_73878_a(boolean doOpen, int someWeirdNumber) {
        if (someWeirdNumber != 0) {
            return;
        }
        if (doOpen) {
            URIWord.visitLink(this.uri);
        }
        this.uri = null;
        Minecraft.func_71410_x().func_147108_a(this.origGui);
    }

    public static void visitLink(URI uri) {
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (Throwable throwable) {
            Core.logWarning("Couldn't open link", throwable);
        }
    }
}

