/*
 * Decompiled with CFR 0.152.
 */
package factorization.twistedblock;

import factorization.api.Coord;
import factorization.api.DeltaCoord;
import factorization.api.Quaternion;
import factorization.fzds.DeltaChunk;
import factorization.fzds.Hammer;
import factorization.fzds.interfaces.DeltaCapability;
import factorization.fzds.interfaces.IDeltaChunk;
import factorization.fzds.interfaces.Interpolation;
import factorization.shared.Core;
import factorization.shared.ItemBlockProxy;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemTwistedBlock
extends ItemBlockProxy {
    static final Block darkIron = Core.registry.resource_block;
    static final int darkIronMd = Core.registry.dark_iron_block_item.func_77960_j();
    final int channel = Hammer.hammerInfo.makeChannelFor("Factorization", "twistedBlocks", 10, 64, "Allows placement of blocks at angles");

    public ItemTwistedBlock() {
        super(Core.registry.dark_iron_block_item.func_77946_l(), "twistedBlock", Core.TabType.ART);
        DeltaChunk.assertEnabled();
    }

    @Override
    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (world.field_72995_K) {
            return false;
        }
        if (player instanceof FakePlayer) {
            return false;
        }
        Coord at = new Coord(world, x, y, z);
        if (world == DeltaChunk.getWorld(world)) {
            int d;
            IDeltaChunk[] found = DeltaChunk.getSlicesContainingPoint(at);
            if (found == null || found.length != 1) {
                return false;
            }
            IDeltaChunk idc = found[0];
            NBTTagCompound tag = idc.getEntityData();
            if (!tag.func_74767_n("isTwistedBlockIDC")) {
                return false;
            }
            if (idc.hasOrderedRotation()) {
                return false;
            }
            ForgeDirection orig = ForgeDirection.getOrientation((int)tag.func_74762_e("placedSide"));
            int turns = tag.func_74762_e("turns");
            int n = d = player.func_70093_af() ? -1 : 1;
            if ((turns += d) < 1) {
                turns = 3;
            }
            if (turns > 3) {
                turns = 1;
            }
            tag.func_74768_a("turns", turns);
            double angle = Math.PI * 2 * (double)turns / 16.0;
            Quaternion newRotation = Quaternion.getRotationQuaternionRadians(angle, orig);
            idc.orderTargetRotation(newRotation, 40, Interpolation.SMOOTH);
            return false;
        }
        DeltaCoord size = new DeltaCoord(16, 16, 16);
        IDeltaChunk idc = DeltaChunk.allocateSlice(world, this.channel, size);
        idc.setPartName("TwistedBlock placed by " + player.func_70005_c_());
        NBTTagCompound tag = idc.getEntityData();
        at.writeToNBT("placedAgainst", tag);
        tag.func_74757_a("isTwistedBlockIDC", true);
        tag.func_74778_a("placedByName", player.func_70005_c_());
        tag.func_74778_a("playerByUUID", player.func_110124_au().toString());
        tag.func_74768_a("placedSide", side);
        tag.func_74768_a("turns", 0);
        for (DeltaCapability forbidden : new DeltaCapability[]{}) {
            idc.forbid(forbidden);
        }
        for (DeltaCapability allowed : new DeltaCapability[]{DeltaCapability.BLOCK_MINE, DeltaCapability.BLOCK_PLACE, DeltaCapability.INTERACT, DeltaCapability.COLLIDE, DeltaCapability.ROTATE, DeltaCapability.DIE_WHEN_EMPTY, DeltaCapability.DRAG, DeltaCapability.ENTITY_PHYSICS}) {
            idc.permit(allowed);
        }
        ForgeDirection axis = ForgeDirection.getOrientation((int)side);
        double amount = Math.toRadians(45.0);
        idc.getCenter().setIdMd(darkIron, darkIronMd, true);
        idc.field_70165_t = (double)at.x + 0.5;
        idc.field_70163_u = (double)at.y + 0.5;
        idc.field_70161_v = (double)at.z + 0.5;
        Vec3 center = idc.getRotationalCenterOffset().func_72441_c(0.5, 0.5, 0.5);
        idc.setRotationalCenterOffset(center);
        idc.field_70170_p.func_72838_d((Entity)idc);
        Quaternion rotation = Quaternion.getRotationQuaternionRadians(amount, axis);
        idc.orderTargetRotation(rotation, 40, Interpolation.SMOOTH);
        at.add(ForgeDirection.getOrientation((int)side)).spawnItem(Core.registry.dark_iron_sprocket.func_77946_l());
        return true;
    }

    @Override
    public void func_150895_a(Item itemId, CreativeTabs tab, List list) {
        list.add(new ItemStack((Item)this));
    }

    public void func_94581_a(IIconRegister registry) {
    }
}

