/*
 * Decompiled with CFR 0.152.
 */
package factorization.util;

import factorization.api.Coord;
import factorization.util.PlayerUtil;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EvilUtil {
    public static int randNear(Random random, int range) {
        if (range <= 0) {
            return 0;
        }
        return random.nextInt(range * 2 + 1) - range;
    }

    public static boolean spawn(TileEntity te, Random random, int range, Entity ent) {
        EvilUtil.positionEntity(te, random, range, ent);
        return EvilUtil.trySpawn(te, ent);
    }

    public static boolean canSpawn(Entity ent) {
        if (ent instanceof EntityLiving) {
            EntityLiving alive = (EntityLiving)ent;
            return alive.func_70601_bi();
        }
        return true;
    }

    private static boolean trySpawn(TileEntity te, Entity ent) {
        if (EvilUtil.canSpawn(ent)) {
            EvilUtil.forceSpawn(te, ent);
            return true;
        }
        return false;
    }

    public static void forceSpawn(TileEntity te, Entity ent) {
        ent.field_70170_p.func_72838_d(ent);
        ent.field_70170_p.func_72926_e(2004, te.field_145851_c, te.field_145848_d, te.field_145849_e, 0);
        if (ent instanceof EntityLiving) {
            ((EntityLiving)ent).func_70656_aK();
        }
    }

    public static void positionEntity(TileEntity te, Random random, int range, Entity ent) {
        double x = te.field_145851_c + EvilUtil.randNear(random, range);
        double y = te.field_145848_d + EvilUtil.randNear(random, range);
        double z = te.field_145849_e + EvilUtil.randNear(random, range);
        ent.func_70012_b(x, y, z, random.nextFloat() * 360.0f, 0.0f);
    }

    public static void givePotion(EntityLiving ent, Potion potion, int level, boolean ambient) {
        ent.func_70690_d(new PotionEffect(potion.func_76396_c(), Short.MAX_VALUE, level, ambient));
    }

    public static EntityPlayer getClosestPlayer(Coord at, double maxRange) {
        maxRange *= maxRange;
        double bestDist = Double.POSITIVE_INFINITY;
        EntityPlayer best = null;
        for (EntityPlayer player : at.w.field_73010_i) {
            double dist;
            if (PlayerUtil.isPlayerCreative(player) || (dist = player.func_70092_e((double)at.x + 0.5, (double)at.y + 0.5, (double)at.z + 0.5)) > maxRange || !(dist < bestDist)) continue;
            bestDist = dist;
            best = player;
        }
        return best;
    }

    public static float getMoonPower(World worldObj) {
        float moon = worldObj.func_130001_d();
        if (worldObj.func_72935_r()) {
            moon = 0.0f;
        }
        if (worldObj.func_72911_I()) {
            moon = (float)((double)moon + 0.75);
        }
        if (worldObj.func_72896_J()) {
            moon *= 2.0f;
        }
        return moon;
    }

    public static EntityItem throwStack(EntityLivingBase player, ItemStack stack, boolean straightThrow) {
        if (stack == null) {
            return null;
        }
        if (stack.field_77994_a == 0) {
            return null;
        }
        Random rand = player.field_70170_p.field_73012_v;
        EntityItem entityitem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u - (double)0.3f + (double)player.func_70047_e(), player.field_70161_v, stack);
        entityitem.field_145804_b = 40;
        float f = 0.1f;
        if (straightThrow) {
            float f1 = rand.nextFloat() * 0.5f;
            float f2 = rand.nextFloat() * (float)Math.PI * 2.0f;
            entityitem.field_70159_w = -MathHelper.func_76126_a((float)f2) * f1;
            entityitem.field_70179_y = MathHelper.func_76134_b((float)f2) * f1;
            entityitem.field_70181_x = 0.2f;
        } else {
            f = 0.3f;
            entityitem.field_70159_w = -MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * f;
            entityitem.field_70179_y = MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * f;
            entityitem.field_70181_x = -MathHelper.func_76126_a((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * f + 0.1f;
            f = 0.02f;
            float f1 = rand.nextFloat() * (float)Math.PI * 2.0f;
            entityitem.field_70159_w += Math.cos(f1) * (double)(f *= rand.nextFloat());
            entityitem.field_70181_x += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
            entityitem.field_70179_y += Math.sin(f1) * (double)f;
        }
        player.field_70170_p.func_72838_d((Entity)entityitem);
        return entityitem;
    }
}

