/*
 * Decompiled with CFR 0.152.
 */
package factorization.util;

import factorization.api.Coord;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidTank;

public class FluidUtil {
    public static void spill(Coord where, FluidStack what) {
        if (what == null || what.amount < 0) {
            return;
        }
        FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidSpilledEvent(what, where.w, where.x, where.y, where.z));
    }

    public static FluidStack drainSpecificBlockFluid(World worldObj, int x, int y, int z, boolean doDrain, Fluid targetFluid) {
        Block b = worldObj.func_147439_a(x, y, z);
        if (!(b instanceof IFluidBlock)) {
            Fluid vanilla;
            if (b == Blocks.field_150355_j || b == Blocks.field_150358_i) {
                vanilla = FluidRegistry.WATER;
            } else if (b == Blocks.field_150353_l || b == Blocks.field_150356_k) {
                vanilla = FluidRegistry.LAVA;
            } else {
                return null;
            }
            if (worldObj.func_72805_g(x, y, z) != 0) {
                return null;
            }
            if (doDrain) {
                worldObj.func_147468_f(x, y, z);
            }
            return new FluidStack(vanilla, 1000);
        }
        IFluidBlock block = (IFluidBlock)b;
        if (!block.canDrain(worldObj, x, y, z)) {
            return null;
        }
        FluidStack fs = block.drain(worldObj, x, y, z, false);
        if (fs == null) {
            return null;
        }
        if (fs.getFluid() != targetFluid) {
            return null;
        }
        if (doDrain) {
            fs = block.drain(worldObj, x, y, z, true);
        }
        if (fs == null || fs.amount <= 0) {
            return null;
        }
        return fs;
    }

    public static int transfer(IFluidTank dst, IFluidTank src) {
        int free = dst.getCapacity() - dst.getFluidAmount();
        int use = dst.fill(src.drain(free, false), false);
        return dst.fill(src.drain(use, true), true);
    }
}

