/*
 * Decompiled with CFR 0.152.
 */
package factorization.util;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.shared.Core;
import factorization.util.LangUtil;
import factorization.weird.TileEntityDayBarrel;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.ServersideAttributeMap;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class FzUtil {
    public static UnitBase[] unit_time = new UnitBase[]{new UnitBase(630720000000000L, "time.eons"), new UnitBase(630720000000L, "time.millenia"), new UnitBase(63072000000L, "time.centuries"), new UnitBase(630720000L, "time.years"), new UnitBase(51840000L, "time.months"), new UnitBase(12096000L, "time.weeks"), new UnitBase(1728000L, "time.irldays"), new UnitBase(72000L, "time.hours"), new UnitBase(1200L, "time.minutes"), new UnitBase(20L, "time.seconds"), new UnitBase(1L, "time.ticks")};
    public static UnitBase[] unit_distance_px = new UnitBase[]{new UnitBase(16000L, "distance.kilometers"), new UnitBase(256L, "distance.chunks"), new UnitBase(16L, "distance.blocks"), new UnitBase(1L, "distance.pixels")};

    public static <E extends Enum> E shiftEnum(E current, E[] values, int delta) {
        int next = current.ordinal() + delta;
        if (next < 0) {
            return values[values.length - 1];
        }
        if (next >= values.length) {
            return values[0];
        }
        return values[next];
    }

    public static int getWorldDimension(World world) {
        return world.field_73011_w.field_76574_g;
    }

    public static World getWorld(int dimensionId) {
        return DimensionManager.getWorld((int)dimensionId);
    }

    @SideOnly(value=Side.CLIENT)
    public static void copyStringToClipboard(String text) {
        StringSelection stringselection = new StringSelection(text);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringselection, null);
    }

    public static <E> ArrayList<E> copyWithoutNull(Collection<E> orig) {
        ArrayList<E> ret = new ArrayList<E>();
        if (orig == null) {
            return ret;
        }
        for (E e : orig) {
            if (e == null) continue;
            ret.add(e);
        }
        return ret;
    }

    public static void closeNoisily(String msg, InputStream is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException e) {
            Core.logSevere(msg, new Object[0]);
            e.printStackTrace();
        }
    }

    public static boolean stringsEqual(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static void spawn(Entity ent) {
        if (ent == null) {
            return;
        }
        ent.field_70170_p.func_72838_d(ent);
    }

    public static double rateDamage(ItemStack is) {
        if (is == null) {
            return 0.0;
        }
        Multimap attrs = is.func_77973_b().getAttributeModifiers(is);
        if (attrs == null) {
            return 0.0;
        }
        ServersideAttributeMap test = new ServersideAttributeMap();
        test.func_111147_b(attrs);
        IAttributeInstance attr = test.func_111151_a(SharedMonsterAttributes.field_111264_e);
        if (attr == null) {
            return 0.0;
        }
        return attr.func_111126_e();
    }

    public static ItemStack getReifiedBarrel(Coord at) {
        if (at == null) {
            return null;
        }
        if (at.w == null) {
            return null;
        }
        TileEntityDayBarrel barrel = at.getTE(TileEntityDayBarrel.class);
        if (barrel == null) {
            return null;
        }
        return barrel.item;
    }

    public static String toRpm(double velocity) {
        return (int)(Math.toDegrees(velocity) * 10.0 / 3.0) + " RPM";
    }

    private static UnitBase best(UnitBase[] bases, long value) {
        boolean wasAbove = false;
        for (UnitBase base : bases) {
            if (base.ratio <= value && wasAbove) {
                return base;
            }
            if (base.ratio < value) continue;
            wasAbove = true;
        }
        return bases[bases.length - 1];
    }

    public static String unitify(String unitName, long value, int max_len) {
        UnitBase[] base = null;
        if (unitName.equals("time")) {
            base = unit_time;
        } else if (unitName.equals("distance")) {
            base = unit_distance_px;
        } else {
            return "Unknown unit " + unitName + "@" + value;
        }
        return FzUtil.unitify(base, value, max_len);
    }

    public static String unitify(UnitBase[] bases, long value, int max_len) {
        String r = "";
        while (max_len-- != 0) {
            UnitBase best = FzUtil.best(bases, value);
            long l = value / best.ratio;
            value -= best.ratio * l;
            if (l > 0L) {
                String unit;
                if (!r.isEmpty()) {
                    r = r + " ";
                }
                r = (unit = LangUtil.translateExact(best.unit + "." + l)) != null ? r + unit : r + l + " " + LangUtil.translateThis(best.unit);
            } else if (value == 0L && !r.isEmpty()) {
                return r;
            }
            if (best.ratio != 1L && max_len != 0) continue;
            break;
        }
        return r;
    }

    public static String unitTranslateTimeTicks(long value, int max_len) {
        return "\u00a7UNIT\u00a7 time " + max_len + " " + value;
    }

    public static String unitTranslateDistancePixels(long value, int max_len) {
        return "\u00a7UNIT\u00a7 distance " + max_len + " " + value;
    }

    public static void debugBytes(String header, byte[] d) {
        System.out.println(header + " #" + d.length);
        for (byte b : d) {
            System.out.print(" " + Integer.toString(b));
        }
        System.out.println();
    }

    public static void setCoreParent(FMLPreInitializationEvent event) {
        String FZ = "factorization";
        if (Loader.isModLoaded((String)"factorization")) {
            event.getModMetadata().parent = "factorization";
        }
    }

    private static class UnitBase {
        final long ratio;
        final String unit;

        private UnitBase(long ratio, String unit) {
            this.ratio = ratio;
            this.unit = "factorization.unit." + unit;
        }
    }
}

