/*
 * Decompiled with CFR 0.152.
 */
package factorization.util;

import factorization.api.Coord;
import factorization.util.DataUtil;
import factorization.util.SpaceUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public final class ItemUtil {
    public static final int WILDCARD_DAMAGE = Short.MAX_VALUE;

    public static ItemStack makeWildcard(Item item) {
        return new ItemStack(item, 1, Short.MAX_VALUE);
    }

    public static ItemStack makeWildcard(Block item) {
        return new ItemStack(item, 1, Short.MAX_VALUE);
    }

    public static boolean isWildcard(ItemStack is, boolean ifNull) {
        if (is == null) {
            return ifNull;
        }
        if (is.func_77973_b() == null) {
            return ifNull;
        }
        return is.func_77960_j() == Short.MAX_VALUE;
    }

    public static boolean identical(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return ItemUtil.couldMerge(a, b);
    }

    public static boolean couldMerge(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return true;
        }
        return a.func_77973_b() == b.func_77973_b() && a.func_77960_j() == b.func_77960_j() && ItemUtil.sameItemTags(a, b);
    }

    public static boolean sameItemTags(ItemStack a, ItemStack b) {
        if (a.field_77990_d == null || b.field_77990_d == null) {
            return a.field_77990_d == b.field_77990_d;
        }
        return a.field_77990_d.equals((Object)b.field_77990_d);
    }

    public static boolean similar(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.func_77973_b() == b.func_77973_b() && a.func_77960_j() == b.func_77960_j();
    }

    public static boolean swordSimilar(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (a.func_77973_b().func_77645_m()) {
            return true;
        }
        return a.func_77960_j() == b.func_77960_j();
    }

    public static boolean wildcardSimilar(ItemStack template, ItemStack stranger) {
        if (template == null || stranger == null) {
            return template == stranger;
        }
        if (template.func_77960_j() == Short.MAX_VALUE) {
            return template.func_77973_b() == stranger.func_77973_b();
        }
        return ItemUtil.similar(template, stranger);
    }

    public static boolean oreDictionarySimilarEfficient(List<ItemStack> oreEntries, ItemStack stranger) {
        for (ItemStack is : oreEntries) {
            if (!ItemUtil.wildcardSimilar(is, stranger)) continue;
            return true;
        }
        return false;
    }

    public static boolean oreDictionarySimilar(Object template, ItemStack stranger) {
        if (template instanceof String) {
            ArrayList ores = OreDictionary.getOres((String)((String)template));
            for (int i = 0; i < ores.size(); ++i) {
                if (!ItemUtil.wildcardSimilar((ItemStack)ores.get(i), stranger)) continue;
                return true;
            }
            return false;
        }
        if (template instanceof List) {
            for (Object o : (List)template) {
                if (!ItemUtil.oreDictionarySimilar(o, stranger)) continue;
                return true;
            }
            return false;
        }
        return ItemUtil.wildcardSimilar((ItemStack)template, stranger);
    }

    public static int stackSize(ItemStack is) {
        return is == null ? 0 : is.field_77994_a;
    }

    public static ItemStack normalDecr(ItemStack is) {
        if (is == null) {
            return null;
        }
        --is.field_77994_a;
        return is.field_77994_a <= 0 ? null : is;
    }

    public static NBTTagCompound getTag(ItemStack is) {
        NBTTagCompound ret = is.func_77978_p();
        if (ret == null) {
            ret = new NBTTagCompound();
            is.func_77982_d(ret);
        }
        return ret;
    }

    public static long getItemHash(ItemStack is) {
        if (is == null) {
            return Long.MIN_VALUE;
        }
        long ih = DataUtil.getId(is);
        long md = is.func_77960_j();
        long tg = 0L;
        if (is.func_77942_o()) {
            tg = is.func_77978_p().hashCode();
        }
        return (ih << 48) + (md << 32) + tg + (long)(is.field_77994_a * 100);
    }

    public static String getCustomItemName(ItemStack is) {
        if (is != null && is.func_82837_s()) {
            return is.func_82833_r();
        }
        return null;
    }

    public static boolean itemCanFire(World w, ItemStack is, int tickDelay) {
        NBTTagCompound tag = ItemUtil.getTag(is);
        long t = tag.func_74763_f("lf");
        if (t > w.func_82737_E()) {
            tag.func_74772_a("lf", w.func_82737_E());
            return true;
        }
        if (t + (long)tickDelay > w.func_82737_E()) {
            return false;
        }
        tag.func_74772_a("lf", w.func_82737_E());
        return true;
    }

    public static ItemStack normalize(ItemStack is) {
        if (is == null || is.field_77994_a <= 0) {
            return null;
        }
        return is;
    }

    public static int getStackSize(ItemStack is) {
        if (is == null) {
            return 0;
        }
        return is.field_77994_a;
    }

    public static ItemStack copyWithSize(ItemStack is, int size) {
        if (is == null) {
            return null;
        }
        ItemStack ret = is.func_77946_l();
        ret.field_77994_a = size;
        return ret;
    }

    public static int getFreeSpace(ItemStack is, int stackLimit) {
        int max = Math.min(is.func_77976_d(), stackLimit);
        return Math.max(0, max - is.field_77994_a);
    }

    public static ItemStack nameItemStack(ItemStack is, String name) {
        is = is.func_77946_l();
        is.func_151001_c(name);
        return is;
    }

    public static List<ItemStack> getSubItems(ItemStack is) {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>();
        is.func_77973_b().func_150895_a(is.func_77973_b(), is.func_77973_b().func_77640_w(), out);
        return out;
    }

    public static ItemStack parseBlock(String name) {
        Item item;
        int md = Short.MAX_VALUE;
        if (name.contains("#")) {
            String[] split = name.split("#");
            md = Short.parseShort(split[1]);
            name = split[0];
        }
        if ((item = DataUtil.getItemFromName(name)) == null) {
            return null;
        }
        return new ItemStack(item, 1, md);
    }

    public static ItemStack getFirstOre(String oreName) {
        ArrayList ores = OreDictionary.getOres((String)oreName);
        if (ores == null || ores.isEmpty()) {
            return null;
        }
        return (ItemStack)ores.get(0);
    }

    public static boolean is(ItemStack stack, Item item) {
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b() == item;
    }

    public static void setLore(ItemStack stack, String[] lore) {
        NBTTagCompound baseTag = ItemUtil.getTag(stack);
        NBTTagCompound displayTag = baseTag.func_74775_l("display");
        baseTag.func_74782_a("display", (NBTBase)displayTag);
        NBTTagList loreList = new NBTTagList();
        for (String n : lore) {
            loreList.func_74742_a((NBTBase)new NBTTagString(n));
        }
        displayTag.func_74782_a("Lore", (NBTBase)loreList);
    }

    public static Entity giveItem(EntityPlayer player, Coord at, ItemStack stack, ForgeDirection side) {
        Vec3 dir;
        if (null == ItemUtil.normalize(stack)) {
            return null;
        }
        if (at == null) {
            at = new Coord((Entity)player);
        }
        if (at.w.field_72995_K) {
            return null;
        }
        Entity ent = at.spawnItem(stack);
        if (ent == null) {
            player.func_71019_a(stack, false);
            return null;
        }
        if (ent instanceof EntityItem) {
            ((EntityItem)ent).field_145804_b = 0;
        }
        if (player != null) {
            ent.func_70100_b_(player);
            if (ent.field_70128_L) {
                return ent;
            }
        }
        if (side == ForgeDirection.UNKNOWN && player == null) {
            if (at.isAir()) {
                return ent;
            }
            side = ForgeDirection.UP;
            for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
                if (!at.add(fd).isAir()) continue;
                side = fd;
                break;
            }
        }
        if (side == ForgeDirection.UNKNOWN && player != null) {
            Vec3 me = at.toVector();
            Vec3 you = SpaceUtil.fromEntPos((Entity)player);
            dir = SpaceUtil.incrSubtract(you, me);
            SpaceUtil.normalize(dir);
        } else {
            dir = SpaceUtil.fromDirection(side);
        }
        Vec3 move = SpaceUtil.scale(dir, 0.5);
        Vec3 newSpot = SpaceUtil.incrAdd(SpaceUtil.fromEntPos(ent), move);
        SpaceUtil.toEntPos(ent, newSpot);
        return ent;
    }
}

