/*
 * Decompiled with CFR 0.152.
 */
package factorization.util;

import factorization.util.FzUtil;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class LangUtil {
    public static String getProperKey(ItemStack is) {
        String n = is.func_77977_a();
        if (n == null || n.length() == 0) {
            n = "???";
        }
        return n;
    }

    public static String getTranslationKey(ItemStack is) {
        if (is == null) {
            return "<null itemstack; bug?>";
        }
        try {
            String s = is.func_82833_r();
            if (s != null && s.length() > 0) {
                return s;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String key = LangUtil.getProperKey(is);
        if (LangUtil.canTranslate(key + ".name")) {
            return key + ".name";
        }
        if (LangUtil.canTranslate(key)) {
            return key;
        }
        return key + ".name";
    }

    static boolean canTranslate(String str) {
        String ret = StatCollector.func_74838_a((String)str);
        if (ret == null || ret.length() == 0) {
            return false;
        }
        return !ret.equals(str);
    }

    public static String getTranslationKey(Item i) {
        if (i == null) {
            return "<null item; bug?>";
        }
        return i.func_77658_a() + ".name";
    }

    public static String translate(String key) {
        return ("" + StatCollector.func_74838_a((String)(key + ".name"))).trim();
    }

    public static String translateThis(String key) {
        return ("" + StatCollector.func_74838_a((String)key)).trim();
    }

    public static String translateExact(String key) {
        if (key != null && key.startsWith("\u00a7UNIT\u00a7")) {
            String[] bits = key.split(" ");
            if (bits.length != 4) {
                return key;
            }
            String unit = bits[1];
            int maxParts = Integer.parseInt(bits[2]);
            Long val = Long.parseLong(bits[3]);
            return FzUtil.unitify(unit, (long)val, maxParts);
        }
        String ret = StatCollector.func_74838_a((String)key);
        if (ret == key) {
            return null;
        }
        return ret;
    }

    public static String tryTranslate(String key, String fallback) {
        String ret = LangUtil.translateExact(key);
        if (ret == null) {
            return fallback;
        }
        return ret;
    }

    public static boolean canTranslateExact(String key) {
        return LangUtil.translateExact(key) != null;
    }

    public static String translateWithCorrectableFormat(String key, Object ... params) {
        String format = LangUtil.translate(key);
        String ret = String.format(format, params);
        String correctedTranslation = LangUtil.translateExact("factorization.replace:" + ret);
        if (correctedTranslation != null) {
            return correctedTranslation;
        }
        return ret;
    }

    public static void sendChatMessage(boolean raw, ICommandSender sender, String msg) {
        sender.func_145747_a((IChatComponent)(raw ? new ChatComponentText(msg) : new ChatComponentTranslation(msg, new Object[0])));
    }

    public static void sendUnlocalizedChatMessage(ICommandSender sender, String format, Object ... params) {
        sender.func_145747_a((IChatComponent)new ChatComponentTranslation(format, params));
    }
}

