/*
 * Decompiled with CFR 0.152.
 */
package factorization.util;

import java.util.Random;
import net.minecraft.util.Vec3;

public final class NumUtil {
    public static Random rand = new Random();
    private static ThreadLocal<Random> random_cache = new ThreadLocal();

    public static boolean significantChange(double a, double b, double threshold) {
        if (a == b) {
            return false;
        }
        if (a == 0.0 || b == 0.0) {
            return true;
        }
        double thresh = Math.abs(a - b) / Math.max(a, b);
        return thresh > threshold;
    }

    public static boolean significantChange(double a, double b) {
        return NumUtil.significantChange(a, b, 0.05);
    }

    public static float interp(float oldValue, float newValue, float partial) {
        return oldValue * (1.0f - partial) + newValue * partial;
    }

    public static double interp(double oldValue, double newValue, double partial) {
        return oldValue * (1.0 - partial) + newValue * partial;
    }

    public static void interp(Vec3 oldVal, Vec3 newVal, float partial, Vec3 dest) {
        dest.field_72450_a = NumUtil.interp(oldVal.field_72450_a, newVal.field_72450_a, (double)partial);
        dest.field_72448_b = NumUtil.interp(oldVal.field_72448_b, newVal.field_72448_b, (double)partial);
        dest.field_72449_c = NumUtil.interp(oldVal.field_72449_c, newVal.field_72449_c, (double)partial);
    }

    public static float uninterp(float lowValue, float highValue, float currentValue) {
        if (currentValue < lowValue) {
            return 0.0f;
        }
        if (currentValue > highValue) {
            return 1.0f;
        }
        return (currentValue - lowValue) / (highValue - lowValue);
    }

    public static double uninterp(double lowValue, double highValue, double currentValue) {
        if (currentValue < lowValue) {
            return 0.0;
        }
        if (currentValue > highValue) {
            return 1.0;
        }
        return (currentValue - lowValue) / (highValue - lowValue);
    }

    public static double roundDown(double value, double units) {
        double scaled = value / units;
        return Math.floor(scaled) * units;
    }

    public static boolean intersect(double la, double ha, double lb, double hb) {
        return !(ha < lb) && !(hb < la);
    }

    public static Random dirtyRandomCache() {
        Random ret = random_cache.get();
        if (ret == null) {
            ret = new Random();
            random_cache.set(ret);
        }
        return ret;
    }

    public static double clip(double v, double min, double max) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    public static int clip(int v, int min, int max) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }
}

