/*
 * Decompiled with CFR 0.152.
 */
package factorization.util;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import factorization.api.Coord;
import factorization.shared.Core;
import factorization.util.ItemUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.stats.StatisticsFile;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.WorldEvent;

public final class PlayerUtil {
    private static final UUID FZ_UUID = UUID.fromString("f979c78a-f80d-46b1-9c49-0121ea8850e6");
    private static HashMap<String, WeakHashMap<World, FzFakePlayer>> usedPlayerCache = new HashMap();

    public static EntityPlayer makePlayer(Coord where, String use) {
        FzFakePlayer found;
        WeakHashMap<Object, FzFakePlayer> fakePlayerCache = usedPlayerCache.get(use);
        if (fakePlayerCache == null) {
            fakePlayerCache = new WeakHashMap();
            usedPlayerCache.put(use, fakePlayerCache);
        }
        if ((found = fakePlayerCache.get(where.w)) == null) {
            if (!(where.w instanceof WorldServer)) {
                throw new IllegalArgumentException("Can't construct fake players on the client");
            }
            found = new FzFakePlayer((WorldServer)where.w, "[FZ." + use + "]", where);
            fakePlayerCache.put(where.w, found);
        }
        found.func_70606_j(20.0f);
        found.field_70128_L = false;
        found.field_70170_p = where.w;
        found.where = where;
        where.setAsEntityLocation((Entity)found);
        Arrays.fill(found.field_71071_by.field_70460_b, null);
        Arrays.fill(found.field_71071_by.field_70462_a, null);
        return found;
    }

    public static void recycleFakePlayer(EntityPlayer player) {
        player.field_70128_L = true;
        player.func_70606_j(0.0f);
        if (player instanceof FzFakePlayer) {
            FzFakePlayer p = (FzFakePlayer)player;
            p.where = null;
        }
    }

    private static GameProfile makeProfile(String name) {
        if (StringUtils.func_151246_b((String)name)) {
            return new GameProfile(FZ_UUID, "[FZ]");
        }
        return new GameProfile(FZ_UUID, "[FZ:" + name + "]");
    }

    public static EntityPlayer fakeplayerToNull(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            if (player instanceof FakePlayer) {
                return null;
            }
            return player;
        }
        return null;
    }

    public static boolean isPlayerOpped(EntityPlayer player) {
        if ((player = PlayerUtil.fakeplayerToNull(player)) == null) {
            return false;
        }
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server == null) {
            return false;
        }
        return server.func_71203_ab().func_152596_g(player.func_146103_bH());
    }

    public static boolean isCommandSenderOpped(ICommandSender player) {
        if (player instanceof EntityPlayer) {
            return PlayerUtil.isPlayerOpped((EntityPlayer)player);
        }
        return player instanceof MinecraftServer || player instanceof RConConsoleSource;
    }

    public static boolean isPlayerCreative(EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d;
    }

    public static StatisticsFile getStatsFile(EntityPlayer player) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server == null) {
            return null;
        }
        ServerConfigurationManager cm = server.func_71203_ab();
        return cm.func_152602_a(player);
    }

    public static int getPuntStrengthOrWeakness(EntityPlayer player) {
        if (player == null) {
            return 1;
        }
        int strength = 0;
        PotionEffect p_str = player.func_70660_b(Potion.field_76420_g);
        PotionEffect p_wea = player.func_70660_b(Potion.field_76437_t);
        if (p_str != null) {
            strength += p_str.func_76458_c() + 1;
        }
        if (p_wea != null) {
            strength -= p_wea.func_76458_c() + 1;
        }
        int knockback = EnchantmentHelper.func_77507_b((EntityLivingBase)player, null);
        return strength * knockback;
    }

    public static int getPuntStrengthInt(EntityPlayer player) {
        int str = PlayerUtil.getPuntStrengthOrWeakness(player);
        return Math.min(1, str);
    }

    public static double getPuntStrengthMultiplier(EntityPlayer player) {
        int str = PlayerUtil.getPuntStrengthOrWeakness(player);
        if (str == 0) {
            return 1.0;
        }
        if (str < 1) {
            return 1.0 / (double)(-str);
        }
        return str;
    }

    public static MovingObjectPosition rayTrace(EntityPlayer player, double dist, float partial) {
        Vec3 pos = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)(player.func_70047_e() - player.getDefaultEyeHeight())), (double)player.field_70161_v);
        Vec3 look = player.func_70676_i(partial);
        Vec3 ray = pos.func_72441_c(look.field_72450_a * dist, look.field_72448_b * dist, look.field_72449_c * dist);
        return player.field_70170_p.func_147447_a(pos, ray, false, false, true);
    }

    public static ItemStack decr(EntityPlayer player, ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (!PlayerUtil.isPlayerCreative(player)) {
            --stack.field_77994_a;
        }
        return ItemUtil.normalize(stack);
    }

    public static void consumeHeldItem(EntityPlayer player) {
        if (PlayerUtil.isPlayerCreative(player)) {
            return;
        }
        ItemStack held = player.func_70694_bm();
        if (held == null) {
            return;
        }
        --held.field_77994_a;
        if (held.field_77994_a <= 0) {
            player.func_70062_b(0, null);
        }
    }

    static {
        Core.loadBus(new PlayerRecycler());
    }

    private static class FzFakePlayer
    extends FakePlayer {
        Coord where;

        private FzFakePlayer(WorldServer world, String name, Coord where) {
            super(world, PlayerUtil.makeProfile(name));
            this.where = where;
            this.field_71135_a = new FakeNetHandler((EntityPlayerMP)this);
        }

        public ChunkCoordinates func_82114_b() {
            return new ChunkCoordinates(this.where.x, this.where.y, this.where.z);
        }

        public boolean func_85032_ar() {
            return true;
        }
    }

    private static class FakeNetHandler
    extends NetHandlerPlayServer {
        public FakeNetHandler(EntityPlayerMP player) {
            super(MinecraftServer.func_71276_C(), (NetworkManager)new FakeNetManager(), player);
        }

        public void func_147359_a(Packet ignored) {
        }
    }

    private static class FakeNetManager
    extends NetworkManager {
        public FakeNetManager() {
            super(false);
            this.field_150746_k = new EmbeddedChannel(new ChannelHandler[]{new ChannelHandler(){

                public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                }

                public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
                }

                @Deprecated
                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                }
            }});
            this.field_150746_k.pipeline().addFirst("fz:null", (ChannelHandler)new ChannelOutboundHandlerAdapter(){

                public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                }
            });
        }
    }

    public static class PlayerRecycler {
        @SubscribeEvent
        public void clearOldPlayers(WorldEvent.Unload event) {
            for (WeakHashMap map : usedPlayerCache.values()) {
                map.remove(event.world);
            }
        }
    }
}

