/*
 * Decompiled with CFR 0.152.
 */
package factorization.utiligoo;

import factorization.api.Coord;
import factorization.notify.Notice;
import factorization.utiligoo.ItemGoo;
import java.io.File;
import java.util.ArrayList;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import org.apache.commons.lang3.ArrayUtils;

public class GooData
extends WorldSavedData {
    int dimensionId;
    int[] coords = new int[0];
    int change_counts = 0;
    WeakHashMap<Entity, Integer> player_updates = new WeakHashMap();
    int last_traced_index = -1;
    static final String fz_goo = "fz_goo";

    public GooData(String dataName) {
        super(dataName);
    }

    public void func_76184_a(NBTTagCompound tag) {
        if (!tag.func_74764_b("dimensionId")) {
            return;
        }
        this.dimensionId = tag.func_74762_e("dimensionId");
        this.coords = tag.func_74759_k("coordData");
    }

    public void func_76187_b(NBTTagCompound tag) {
        tag.func_74778_a("mapname", this.field_76190_i);
        tag.func_74768_a("dimensionId", this.dimensionId);
        tag.func_74783_a("coordData", this.coords);
    }

    public void func_76186_a(boolean dirty) {
        super.func_76186_a(dirty);
        if (dirty) {
            ++this.change_counts;
        }
    }

    boolean isPlayerOutOfDate(Entity player) {
        if (!(player instanceof EntityPlayer)) {
            return false;
        }
        Integer update_count = this.player_updates.get(player);
        if (update_count == null || update_count != this.change_counts) {
            this.player_updates.put(player, this.change_counts);
            return true;
        }
        return false;
    }

    void wipe(ItemStack is, World world) {
        this.coords = new int[0];
        this.dimensionId = 0;
        if (!is.func_82837_s()) {
            this.deleteDataFile(world);
            is.func_77964_b(0);
        } else {
            this.func_76185_a();
        }
    }

    static String getGooName(ItemStack is) {
        return "fz_goo_" + is.func_77960_j();
    }

    static GooData getGooData(ItemStack is, World world) {
        GooData data = (GooData)world.func_72943_a(GooData.class, GooData.getGooName(is));
        if (data == null && !world.field_72995_K) {
            int unique_id = world.func_72841_b(fz_goo);
            if (unique_id == 0) {
                unique_id = world.func_72841_b(fz_goo);
            }
            is.func_77964_b(unique_id);
            String name = GooData.getGooName(is);
            data = new GooData(name);
            data.func_76185_a();
            world.func_72823_a(name, (WorldSavedData)data);
        }
        return data;
    }

    static GooData getNullGooData(ItemStack is, World world) {
        if (is == null) {
            return null;
        }
        if (!(is.func_77973_b() instanceof ItemGoo)) {
            return null;
        }
        if (is.func_77960_j() == 0) {
            return null;
        }
        return (GooData)world.func_72943_a(GooData.class, GooData.getGooName(is));
    }

    private void deleteDataFile(World world) {
        File file = world.func_72860_G().func_75758_b(this.field_76190_i);
        if (file != null && file.exists()) {
            file.delete();
        }
        world.field_72988_C.field_75750_c.remove((Object)this);
        world.field_72988_C.field_75749_b.remove((Object)this);
    }

    void removeIndices(ArrayList<Integer> indices, ItemStack is, World world) {
        int[] all = new int[indices.size()];
        int i = 0;
        for (Integer index : indices) {
            all[i++] = index;
        }
        this.coords = ArrayUtils.removeAll((int[])this.coords, (int[])all);
        if (this.coords.length == 0) {
            this.wipe(is, world);
        } else {
            this.func_76185_a();
        }
    }

    boolean checkWorld(EntityPlayer player, Coord complainAt) {
        if (this.coords.length == 0) {
            return false;
        }
        if (this.dimensionId == player.field_70170_p.field_73011_w.field_76574_g) {
            return false;
        }
        if (complainAt != null) {
            new Notice(complainAt, "item.factorization:utiligoo.wrongDimension", new String[0]).send(player);
        }
        return true;
    }
}

