/*
 * Decompiled with CFR 0.152.
 */
package factorization.weird;

import factorization.api.FzOrientation;
import factorization.api.Quaternion;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.shared.BlockRenderHelper;
import factorization.shared.Core;
import factorization.shared.FactorizationBlockRender;
import factorization.util.DataUtil;
import factorization.weird.TileEntityDayBarrel;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class BlockRenderDayBarrel
extends FactorizationBlockRender {
    @Override
    public boolean render(RenderBlocks rb) {
        if (this.world_mode) {
            return this.doRender(rb, 0);
        }
        this.doRender(rb, 0);
        GL11.glPushAttrib((int)16384);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.doRender(rb, 1);
        GL11.glPopAttrib();
        return true;
    }

    @Override
    public boolean renderSecondPass(RenderBlocks rb) {
        return this.doRender(rb, 1);
    }

    boolean doRender(RenderBlocks rb, int pass) {
        TileEntityDayBarrel barrel;
        BlockRenderHelper block = Core.registry.blockRender;
        if (this.world_mode) {
            barrel = (TileEntityDayBarrel)this.te;
        } else {
            barrel = (TileEntityDayBarrel)FactoryType.DAYBARREL.getRepresentative();
            barrel.loadFromStack(this.is);
        }
        if (rb.func_147744_b()) {
            block.useTexture(rb.field_147840_d);
        } else if (pass == 0) {
            for (int i = 0; i < 6; ++i) {
                block.setTexture(i, barrel.getIcon(ForgeDirection.getOrientation((int)i)));
            }
        } else {
            BlockIcons.BarrelTextureset set;
            switch (barrel.type) {
                case HOPPING: {
                    set = BlockIcons.hopping;
                    break;
                }
                case SILKY: {
                    set = BlockIcons.silky;
                    break;
                }
                case STICKY: {
                    set = BlockIcons.sticky;
                    break;
                }
                default: {
                    set = BlockIcons.normal;
                }
            }
            block.useTexture(set.side);
            IIcon top = set.top;
            Block log = DataUtil.getBlock(barrel.woodLog);
            if (log != null && log.func_149688_o() != Material.field_151575_d) {
                top = set.top_metal;
            }
            block.setTexture(0, top);
            block.setTexture(1, top);
            block.setTexture(4, set.front);
        }
        float blockOffset = pass == 0 ? 0.0f : -0.001953125f;
        block.setBlockBoundsOffset(blockOffset, blockOffset, blockOffset);
        if (this.world_mode) {
            Tessellator.field_78398_a.func_78380_c(block.func_149677_c(this.w, this.x, this.y, this.z));
            FzOrientation fzo = barrel.orientation.getSwapped();
            Quaternion q = Quaternion.fromOrientation(fzo);
            if (barrel.notice_target == barrel) {
                block.simpleCull(fzo, this.w, this.x, this.y, this.z);
            }
            block.beginWithMirroredUVs();
            block.rotateMiddle(q);
            return block.renderRotated(Tessellator.field_78398_a, this.x, this.y, this.z);
        }
        block.renderForInventory(rb);
        float d = 0.015625f;
        block.setBlockBoundsOffset(0.015625f, 0.0f, 0.015625f);
        return true;
    }

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.DAYBARREL;
    }
}

