/*
 * Decompiled with CFR 0.152.
 */
package factorization.weird;

import factorization.common.Command;
import factorization.shared.Core;
import factorization.util.CraftUtil;
import factorization.util.InvUtil;
import factorization.util.ItemUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class ContainerPocket
extends Container {
    final EntityPlayer player;
    final InventoryPlayer playerInv;
    final IInventory inv;
    InventoryCrafting craftMatrix = new InventoryCrafting((Container)this, 3, 3);
    IInventory craftResult = new InventoryCraftResult();
    final World world;
    ArrayList<Slot> nonCraftingInventorySlots = new ArrayList();
    ArrayList<Slot> craftingSlots = new ArrayList();
    ArrayList<Slot> mainInvThenHotbarSlots = new ArrayList();
    Slot craftResultSlot;
    ItemStack fake_is;
    boolean isCrafting = false;
    boolean dirty = false;
    boolean isWorking = false;
    private static final int[] slots = new int[]{15, 16, 17, 26, 35, 34, 33, 24};
    private static final int[] slotsTwice = new int[]{15, 16, 17, 26, 35, 34, 33, 24, 15, 16, 17, 26, 35, 34, 33, 24};

    public ContainerPocket(EntityPlayer player) {
        this.player = player;
        this.world = player.field_70170_p;
        this.playerInv = player.field_71071_by;
        this.inv = new InventoryProxy((IInventory)this.playerInv);
        this.fake_is = new ItemStack((Item)Core.registry.pocket_table, 0);
        this.craftResultSlot = this.func_75146_a((Slot)new RedirectedSlotCrafting(player, (IInventory)this.craftMatrix, this.craftResult, 208, 28));
        this.addPlayerSlots(this.inv);
        this.func_75142_b();
        this.updateCraft();
    }

    void addPlayerSlots(IInventory inventoryplayer) {
        int invdx = 0;
        int invdy = 0;
        int y = 3;
        ArrayList<Slot> hotbarSlots = new ArrayList<Slot>();
        ArrayList<Slot> mainInvSlots = new ArrayList<Slot>();
        for (int x = 0; x < 9; ++x) {
            Slot slot = new Slot(inventoryplayer, x, invdx + 8 + x * 18, 4 + invdy + 8 + y * 18);
            this.func_75146_a(slot);
            hotbarSlots.add(slot);
        }
        int col_limit = 6;
        for (y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                Slot slot = new Slot(inventoryplayer, x + y * 9 + 9, invdx + 8 + x * 18, invdy + 8 + y * 18);
                this.func_75146_a(slot);
                if (x >= col_limit) {
                    this.craftingSlots.add(slot);
                    continue;
                }
                mainInvSlots.add(slot);
            }
        }
        this.nonCraftingInventorySlots.addAll(hotbarSlots);
        this.nonCraftingInventorySlots.addAll(mainInvSlots);
        this.mainInvThenHotbarSlots.addAll(mainInvSlots);
        this.mainInvThenHotbarSlots.addAll(hotbarSlots);
    }

    protected Slot func_75146_a(Slot slot) {
        return super.func_75146_a(slot);
    }

    void updateMatrix() {
        this.isWorking = true;
        int i = 0;
        for (Slot slot : this.craftingSlots) {
            this.craftMatrix.func_70299_a(i++, slot.func_75211_c());
        }
        this.isWorking = false;
    }

    public void updateCraft() {
        if (this.isWorking) {
            this.dirty = true;
            return;
        }
        this.updateMatrix();
        ItemStack result = null;
        IRecipe match = CraftUtil.findMatchingRecipe(this.craftMatrix, this.world);
        if (match != null) {
            result = match.func_77572_b(this.craftMatrix);
        }
        this.craftResult.func_70299_a(0, result);
        this.dirty = false;
    }

    public void func_75131_a(ItemStack[] stacks) {
        this.isWorking = true;
        super.func_75131_a(stacks);
        this.isWorking = false;
    }

    public void func_75130_a(IInventory inv) {
        super.func_75130_a(inv);
    }

    public void func_75142_b() {
        if (!this.isCrafting) {
            super.func_75142_b();
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return Core.registry.pocket_table.findPocket(player) != null;
    }

    public void executeCommand(Command cmd, int arg) {
        switch (cmd) {
            default: {
                return;
            }
            case craftBalance: {
                this.craftBalance();
                break;
            }
            case craftFill: {
                this.craftFill(arg);
                break;
            }
            case craftClear: {
                this.craftClear();
                break;
            }
            case craftSwirl: {
                this.craftSwirl();
            }
        }
        this.updateCraft();
    }

    protected void func_75133_b(int par1, int par2, boolean par3, EntityPlayer par4EntityPlayer) {
        super.func_75133_b(par1, par2, par3, par4EntityPlayer);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotId) {
        for (Slot slot : this.nonCraftingInventorySlots) {
            if (slot.field_75222_d != slotId) continue;
            return InvUtil.transferSlotToSlots(player, slot, this.craftingSlots);
        }
        for (Slot slot : this.craftingSlots) {
            if (slot.field_75222_d != slotId) continue;
            return InvUtil.transferSlotToSlots(player, slot, this.nonCraftingInventorySlots);
        }
        if (this.craftResultSlot.field_75222_d == slotId) {
            this.updateCraft();
            ItemStack res = this.craftResultSlot.func_75211_c();
            if (res == null) {
                return null;
            }
            ItemStack held = null;
            for (int count = this.getCraftCount(res); count > 0 && (held = InvUtil.tryTransferSlotToSlots(player, this.craftResultSlot, this.nonCraftingInventorySlots)) == null; --count) {
                this.updateCraft();
                ItemStack newRes = this.craftResultSlot.func_75211_c();
                if (newRes == null || !ItemUtil.couldMerge(res, newRes) || !ItemUtil.couldMerge(held, newRes) || this.getCraftCount(newRes) <= 0) break;
            }
            if (held != null) {
                ItemStack cursor = player.field_71071_by.func_70445_o();
                if (cursor == null) {
                    player.field_71071_by.func_70437_b(held);
                    if (player instanceof EntityPlayerMP && !player.field_70170_p.field_72995_K) {
                        EntityPlayerMP emp = (EntityPlayerMP)player;
                        emp.func_71113_k();
                    }
                    held = null;
                } else if (ItemUtil.couldMerge(cursor, held)) {
                    int avail = cursor.func_77976_d() - cursor.field_77994_a;
                    int delta = Math.min(avail, held.field_77994_a);
                    held.field_77994_a -= delta;
                    cursor.field_77994_a += delta;
                    if (held.field_77994_a >= 0) {
                        held = null;
                    }
                }
                if (held != null && held.field_77994_a > 0 && !player.field_70170_p.field_72995_K) {
                    player.func_71019_a(held, false);
                }
            }
            this.func_75142_b();
            return null;
        }
        return super.func_82846_b(player, slotId);
    }

    int getCraftCount(ItemStack res) {
        int ret;
        boolean hasEmpty = false;
        int space_to_fill = 0;
        for (Slot slot : this.nonCraftingInventorySlots) {
            ItemStack is = slot.func_75211_c();
            if (is == null) {
                hasEmpty = true;
                continue;
            }
            if (!ItemUtil.couldMerge(res, is)) continue;
            space_to_fill += is.func_77976_d() - is.field_77994_a;
        }
        if (space_to_fill > 64) {
            space_to_fill = 64;
        }
        if ((ret = space_to_fill / res.field_77994_a) == 0 && hasEmpty) {
            return 64 / res.field_77994_a;
        }
        return ret;
    }

    void craftClear() {
        for (Slot slot : this.craftingSlots) {
            InvUtil.transferSlotToSlots(this.player, slot, this.mainInvThenHotbarSlots);
        }
        this.updateMatrix();
    }

    void craftSwirl() {
        boolean anyAction = false;
        for (int n = 0; n < 8; ++n) {
            boolean any = false;
            block1: for (int slotIndexIndex = 0; slotIndexIndex < slots.length; ++slotIndexIndex) {
                ItemStack is = this.playerInv.func_70301_a(slots[slotIndexIndex]);
                if (is == null || is.field_77994_a <= 1) continue;
                for (int probidex = slotIndexIndex; probidex < slotsTwice.length && probidex < slotIndexIndex + slots.length; ++probidex) {
                    ItemStack empty = this.playerInv.func_70301_a(slotsTwice[probidex]);
                    if (empty != null) continue;
                    this.playerInv.func_70299_a(slotsTwice[probidex], is.func_77979_a(1));
                    any = true;
                    continue block1;
                }
            }
            if (!any) break;
            anyAction = true;
        }
        if (!anyAction) {
            ItemStack swapeh = this.playerInv.func_70301_a(slots[slots.length - 1]);
            for (int i = 0; i < slots.length; ++i) {
                ItemStack here = this.playerInv.func_70301_a(slotsTwice[i]);
                this.playerInv.func_70299_a(slotsTwice[i], swapeh);
                swapeh = here;
            }
            this.playerInv.func_70299_a(slots[0], swapeh);
        }
        this.updateMatrix();
    }

    void craftBalance() {
        class Accumulator {
            ItemStack toMatch;
            int stackCount = 0;
            ArrayList<Integer> matchingSlots = new ArrayList(9);

            public Accumulator(ItemStack toMatch, int slot) {
                this.toMatch = toMatch;
                this.stackCount = toMatch.field_77994_a;
                toMatch.field_77994_a = 0;
                this.matchingSlots.add(slot);
            }

            boolean add(ItemStack ta, int slot) {
                if (ItemUtil.couldMerge(this.toMatch, ta)) {
                    this.stackCount += ta.field_77994_a;
                    ta.field_77994_a = 0;
                    this.matchingSlots.add(slot);
                    return true;
                }
                return false;
            }
        }
        ArrayList<Accumulator> list = new ArrayList<Accumulator>(9);
        for (Slot s : this.craftingSlots) {
            int slot = s.getSlotIndex();
            ItemStack here = this.playerInv.func_70301_a(slot);
            if (here == null || here.field_77994_a == 0) continue;
            boolean found = false;
            for (Accumulator acc : list) {
                if (!acc.add(here, slot)) continue;
                found = true;
            }
            if (found) continue;
            list.add(new Accumulator(here, slot));
        }
        for (Accumulator acc : list) {
            int delta = acc.stackCount / acc.matchingSlots.size();
            delta = Math.min(delta, 1);
            for (int slot : acc.matchingSlots) {
                if (acc.stackCount <= 0) break;
                this.playerInv.func_70301_a((int)slot).field_77994_a = delta;
                acc.stackCount -= delta;
            }
            block4: while (acc.stackCount > 0) {
                for (int slot : acc.matchingSlots) {
                    if (acc.stackCount <= 0) continue block4;
                    ++this.playerInv.func_70301_a((int)slot).field_77994_a;
                    --acc.stackCount;
                }
            }
        }
        this.updateMatrix();
    }

    void craftFill(int slot) {
        ItemStack toMove = this.playerInv.func_70301_a(slot);
        if (toMove == null) {
            return;
        }
        for (Slot matrixSlot : this.craftingSlots) {
            if (toMove.field_77994_a <= 0) break;
            if (matrixSlot.func_75211_c() != null) continue;
            matrixSlot.func_75215_d(toMove.func_77979_a(1));
        }
        this.playerInv.func_70299_a(slot, ItemUtil.normalize(toMove));
        this.updateMatrix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_75144_a(int slotId, int clickedButton, int mode, EntityPlayer player) {
        Slot slot2;
        boolean bad_news = false;
        if (mode == 2 && clickedButton >= 0 && clickedButton < 9 && (slot2 = (Slot)this.field_75151_b.get(slotId)).func_82869_a(player)) {
            bad_news = true;
        }
        if (!bad_news) {
            ItemStack ret = super.func_75144_a(slotId, clickedButton, mode, player);
            if (this.dirty) {
                this.updateCraft();
            }
            return ret;
        }
        final InventoryPlayer realInventory = player.field_71071_by;
        try {
            player.field_71071_by = new InventoryPlayer(player){
                {
                    super(x0);
                    for (Field field : InventoryPlayer.class.getFields()) {
                        field.set((Object)this, field.get(realInventory));
                    }
                }

                public int func_70447_i() {
                    block0: for (int i = 0; i < this.field_70462_a.length; ++i) {
                        if (this.field_70462_a[i] != null) continue;
                        for (Slot slot : ContainerPocket.this.craftingSlots) {
                            if (i != slot.getSlotIndex()) continue;
                            continue block0;
                        }
                        return i;
                    }
                    return -1;
                }
            };
            ItemStack itemStack = super.func_75144_a(slotId, clickedButton, mode, player);
            return itemStack;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            ItemStack itemStack = null;
            return itemStack;
        }
        finally {
            player.field_71071_by = realInventory;
            if (this.dirty) {
                this.updateCraft();
            }
        }
    }

    class InventoryProxy
    implements IInventory {
        IInventory src;

        public InventoryProxy(IInventory src) {
            this.src = src;
        }

        int remapSlotId(int i) {
            return i;
        }

        boolean isCraftingArea(int slot) {
            if (slot < 8) {
                return false;
            }
            int col = slot % 9;
            return col < 6;
        }

        public int func_70302_i_() {
            return this.src.func_70302_i_();
        }

        public ItemStack func_70301_a(int var1) {
            return this.src.func_70301_a(this.remapSlotId(var1));
        }

        public ItemStack func_70298_a(int var1, int var2) {
            ItemStack ret = this.src.func_70298_a(this.remapSlotId(var1), var2);
            if (!ContainerPocket.this.isCrafting && this.isCraftingArea(var1)) {
                ContainerPocket.this.updateCraft();
            }
            return ret;
        }

        public ItemStack func_70304_b(int var1) {
            return this.src.func_70304_b(this.remapSlotId(var1));
        }

        public void func_70299_a(int var1, ItemStack var2) {
            this.src.func_70299_a(this.remapSlotId(var1), var2);
            if (!ContainerPocket.this.isCrafting && this.isCraftingArea(var1)) {
                ContainerPocket.this.updateCraft();
            }
        }

        public String func_145825_b() {
            return this.src.func_145825_b();
        }

        public int func_70297_j_() {
            return this.src.func_70297_j_();
        }

        public void func_70296_d() {
            this.src.func_70296_d();
            ContainerPocket.this.updateCraft();
        }

        public boolean func_70300_a(EntityPlayer var1) {
            return this.src.func_70300_a(var1);
        }

        public void func_70295_k_() {
            this.src.func_70295_k_();
        }

        public void func_70305_f() {
            this.src.func_70305_f();
        }

        public boolean func_145818_k_() {
            return false;
        }

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return true;
        }
    }

    class RedirectedSlotCrafting
    extends SlotCrafting {
        public RedirectedSlotCrafting(EntityPlayer player, IInventory craftMatrix, IInventory craftResult, int posX, int posY) {
            super(player, craftMatrix, craftResult, 0, posX, posY);
        }

        public void func_82870_a(EntityPlayer player, ItemStack grabbedStack) {
            ContainerPocket.this.isCrafting = true;
            ItemStack faker = new ItemStack((Item)Core.registry.pocket_table, 1, -1);
            for (Slot slot : ContainerPocket.this.craftingSlots) {
                ContainerPocket.this.playerInv.func_70299_a(slot.getSlotIndex(), faker);
            }
            super.func_82870_a(player, grabbedStack);
            int i = 0;
            for (Slot slot : ContainerPocket.this.craftingSlots) {
                ItemStack repl = ContainerPocket.this.craftMatrix.func_70301_a(i++);
                ContainerPocket.this.playerInv.func_70299_a(slot.getSlotIndex(), repl);
            }
            ContainerPocket.this.isCrafting = false;
            ContainerPocket.this.updateCraft();
        }
    }
}

