/*
 * Decompiled with CFR 0.152.
 */
package factorization.weird;

import cpw.mods.fml.common.eventhandler.Event;
import factorization.api.FzOrientation;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.DataInNBT;
import factorization.api.datahelpers.DataOutNBT;
import factorization.shared.Core;
import factorization.weird.TileEntityDayBarrel;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;

public class EntityMinecartDayBarrel
extends EntityMinecart
implements IInventory {
    protected TileEntityDayBarrel barrel;
    private int activatorRailTicks = 0;
    private boolean activatorRailPowered;

    public EntityMinecartDayBarrel(World world) {
        super(world);
    }

    public EntityMinecartDayBarrel(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public void func_94095_a(DamageSource damage) {
        this.func_70106_y();
        if (this.barrel != null) {
            this.barrel.dropContents();
        }
        ItemStack itemstack = this.getCartItem();
        if (this.func_95999_t() != null) {
            itemstack.func_151001_c(this.func_95999_t());
        }
        this.func_70099_a(itemstack, 0.0f);
    }

    public ItemStack getCartItem() {
        ItemStack stack = this.barrel.getDroppedBlock();
        ItemStack realStack = new ItemStack((Item)Core.registry.barrelCart, 1);
        realStack.func_77982_d(stack.func_77978_p());
        return realStack;
    }

    public int func_94087_l() {
        return 1;
    }

    public void initFromStack(ItemStack is) {
        this.barrel.loadFromStack(is);
        this.updateDataWatcher(true);
    }

    private void create_barrel() {
        if (this.barrel != null) {
            return;
        }
        this.barrel = new TileEntityDayBarrel();
        this.barrel.func_145834_a(this.field_70170_p);
        this.barrel.field_145849_e = 0;
        this.barrel.field_145848_d = 0;
        this.barrel.field_145851_c = 0;
        this.barrel.func_145829_t();
        this.barrel.orientation = FzOrientation.fromDirection(ForgeDirection.WEST).pointTopTo(ForgeDirection.UP);
        this.barrel.notice_target = this;
    }

    public void putData(DataHelper data) throws IOException {
        if (data.isReader() && this.barrel == null) {
            this.create_barrel();
        }
        if (this.barrel != null) {
            this.barrel.putData(data);
            if (data.isReader() && !this.field_70170_p.field_72995_K) {
                this.updateDataWatcher(true);
            }
        }
    }

    protected final void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        DataInNBT data = new DataInNBT(tag);
        try {
            this.putData(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected final void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        DataOutNBT data = new DataOutNBT(tag);
        try {
            this.putData(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.create_barrel();
        this.field_70180_af.func_82709_a(23, 5);
        this.field_70180_af.func_75692_b(23, (Object)this.barrel.item);
        this.field_70180_af.func_75682_a(24, (Object)this.barrel.getItemCount());
        this.field_70180_af.func_75682_a(25, (Object)this.barrel.woodLog);
        this.field_70180_af.func_75682_a(26, (Object)this.barrel.woodSlab);
        this.field_70180_af.func_75682_a(27, (Object)((byte)this.barrel.orientation.ordinal()));
        this.field_70180_af.func_75682_a(28, (Object)((byte)this.barrel.type.ordinal()));
    }

    private void updateDataWatcher(boolean full) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(23, (Object)this.barrel.item);
            this.field_70180_af.func_75692_b(24, (Object)this.barrel.getItemCount());
            if (full) {
                this.field_70180_af.func_75692_b(25, (Object)this.barrel.woodLog);
                this.field_70180_af.func_75692_b(26, (Object)this.barrel.woodSlab);
                this.field_70180_af.func_75692_b(27, (Object)((byte)this.barrel.orientation.ordinal()));
                this.field_70180_af.func_75692_b(28, (Object)((byte)this.barrel.type.ordinal()));
            }
        }
    }

    public void func_96095_a(int x, int y, int z, boolean powered) {
        if (powered) {
            this.activatorRailTicks = this.barrel.getLogicSpeed();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_75684_a()) {
            this.barrel.item = this.field_70180_af.func_82710_f(23);
            this.barrel.setItemCount(this.field_70180_af.func_75679_c(24));
            this.barrel.woodLog = this.field_70180_af.func_82710_f(25);
            this.barrel.woodSlab = this.field_70180_af.func_82710_f(26);
            this.barrel.orientation = FzOrientation.getOrientation(this.field_70180_af.func_75683_a(27));
            this.barrel.type = TileEntityDayBarrel.Type.values()[this.field_70180_af.func_75683_a(28)];
        }
        if (!this.field_70170_p.field_72995_K) {
            this.barrel.field_145851_c = MathHelper.func_76128_c((double)this.field_70165_t);
            this.barrel.field_145848_d = MathHelper.func_76128_c((double)this.field_70163_u);
            this.barrel.field_145849_e = MathHelper.func_76128_c((double)this.field_70161_v);
            if (this.activatorRailTicks > 0) {
                --this.activatorRailTicks;
            }
            if (this.barrel.canUpdate() && this.activatorRailTicks <= 0 && this.field_70170_p.func_82737_E() % (long)this.barrel.getLogicSpeed() == 0L) {
                this.barrel.doLogic();
                this.updateDataWatcher(false);
            }
        }
    }

    public Block func_145817_o() {
        return Core.registry.factory_block;
    }

    public boolean func_70097_a(DamageSource source, float f) {
        if (source.func_76346_g() instanceof EntityPlayer) {
            int oldItemCount = this.barrel.getItemCount();
            this.barrel.click((EntityPlayer)source.func_76346_g());
            this.updateDataWatcher(false);
            if (source.func_76346_g().func_70093_af()) {
                return super.func_70097_a(source, f);
            }
            if (this.barrel.type == TileEntityDayBarrel.Type.CREATIVE) {
                return false;
            }
            if (this.barrel.getItemCount() != oldItemCount) {
                return false;
            }
        }
        return super.func_70097_a(source, f);
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MinecartInteractEvent((EntityMinecart)this, player))) {
            return true;
        }
        boolean result = this.barrel.activate(player, ForgeDirection.UNKNOWN);
        this.updateDataWatcher(false);
        return result;
    }

    public int func_70302_i_() {
        return this.barrel.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.barrel.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack out = this.barrel.func_70298_a(slot, amount);
        this.updateDataWatcher(false);
        return out;
    }

    public ItemStack func_70304_b(int slot) {
        return this.barrel.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.barrel.func_70299_a(slot, stack);
        this.updateDataWatcher(false);
    }

    public String func_145825_b() {
        return this.barrel.func_145825_b();
    }

    public int func_70297_j_() {
        return this.barrel.func_70297_j_();
    }

    public void func_70296_d() {
        this.barrel.func_70296_d();
        this.updateDataWatcher(false);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.barrel.func_70300_a(player);
    }

    public void func_70295_k_() {
        this.barrel.func_70295_k_();
    }

    public void func_70305_f() {
        this.barrel.func_70305_f();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.barrel.func_94041_b(slot, stack);
    }
}

