/*
 * Decompiled with CFR 0.152.
 */
package factorization.weird;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.common.Command;
import factorization.common.FactorizationKeyHandler;
import factorization.common.FactoryType;
import factorization.common.FzConfig;
import factorization.common.ItemIcons;
import factorization.coremodhooks.UnhandledGuiKeyEvent;
import factorization.shared.Core;
import factorization.shared.FactorizationTextureLoader;
import factorization.shared.ItemFactorization;
import factorization.weird.ContainerPocket;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemPocketTable
extends ItemFactorization {
    public ItemPocketTable() {
        super("tool/pocket_crafting_table", Core.TabType.TOOLS);
        this.func_77625_d(1);
        this.func_77664_n();
        Core.loadBus((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        super.func_94581_a(reg);
        FactorizationTextureLoader.register(reg, ItemIcons.class, null, "factorization:");
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        return this.activateTable(stack, world, player);
    }

    ItemStack activateTable(ItemStack stack, World world, EntityPlayer player) {
        ItemStack save = player.field_71071_by.func_70445_o();
        if (save != null) {
            player.field_71071_by.func_70437_b(null);
        }
        if (!world.field_72995_K) {
            player.openGui((Object)Core.instance, FactoryType.POCKETCRAFTGUI.gui, player.field_70170_p, 0, 0, 0);
        }
        if (save != null) {
            player.field_71071_by.func_70437_b(save);
            if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).func_71113_k();
            }
        }
        return stack;
    }

    public ItemStack findPocket(EntityPlayer player) {
        InventoryPlayer inv = player.field_71071_by;
        int need_to_move = -1;
        int a_free_space = -1;
        for (int i = 0; i < inv.field_70462_a.length; ++i) {
            boolean in_crafting_area = i % 9 >= 6 && i > 9;
            ItemStack is = inv.field_70462_a[i];
            if (is == null) {
                if (in_crafting_area || a_free_space != -1 && a_free_space >= 9) continue;
                a_free_space = i;
                continue;
            }
            if (is.func_77973_b() != this) continue;
            if (in_crafting_area) {
                need_to_move = i;
                continue;
            }
            return is;
        }
        ItemStack mouse_item = player.field_71071_by.func_70445_o();
        if (mouse_item != null && mouse_item.func_77973_b() == this && player.field_71070_bA instanceof ContainerPocket) {
            return mouse_item;
        }
        if (need_to_move != -1 && a_free_space != -1) {
            ItemStack pocket = inv.func_70301_a(need_to_move);
            inv.func_70299_a(need_to_move, null);
            inv.func_70299_a(a_free_space, pocket);
            return pocket;
        }
        return null;
    }

    public boolean tryOpen(EntityPlayer player) {
        ItemStack is = this.findPocket(player);
        if (is == null) {
            return false;
        }
        this.activateTable(is, player.field_70170_p, player);
        return true;
    }

    @Override
    public void addExtraInformation(ItemStack is, EntityPlayer player, List infoList, boolean verbose) {
        String key;
        if (player.field_70170_p.field_72995_K && (key = Core.proxy.getPocketCraftingTableKey()) != null && key != "") {
            String prefix = "item.factorization:tool/pocket_crafting_table.";
            infoList.add(StatCollector.func_74837_a((String)"item.factorization:tool/pocket_crafting_table.yesNEI", (Object[])new Object[]{key}));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void craftingTableKey(UnhandledGuiKeyEvent event) {
        if (!FzConfig.pocket_craft_anywhere) {
            return;
        }
        if (!(event.gui instanceof GuiContainer)) {
            return;
        }
        if (FactorizationKeyHandler.pocket_key.func_151463_i() == event.keysym) {
            Command.craftOpen.call(event.player);
        }
    }
}

