/*
 * Decompiled with CFR 0.152.
 */
package factorization.weird;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.common.FactoryType;
import factorization.notify.Notice;
import factorization.notify.NoticeUpdater;
import factorization.rendersorting.ISortableRenderer;
import factorization.rendersorting.RenderSorter;
import factorization.shared.BlockClass;
import factorization.shared.Core;
import factorization.shared.NetworkFactorization;
import factorization.shared.Sound;
import factorization.shared.TileEntityFactorization;
import factorization.util.DataUtil;
import factorization.util.InvUtil;
import factorization.util.ItemUtil;
import factorization.util.LangUtil;
import factorization.util.PlayerUtil;
import factorization.util.SpaceUtil;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkEvent;
import org.lwjgl.opengl.GL11;

public class TileEntityDayBarrel
extends TileEntityFactorization
implements ISortableRenderer<TileEntityDayBarrel> {
    public ItemStack item;
    private ItemStack topStack;
    private int middleCount;
    private ItemStack bottomStack;
    private static final ItemStack DEFAULT_LOG = new ItemStack(Blocks.field_150364_r);
    private static final ItemStack DEFAULT_SLAB = new ItemStack(Blocks.field_150344_f);
    public ItemStack woodLog = DEFAULT_LOG.func_77946_l();
    public ItemStack woodSlab = DEFAULT_SLAB.func_77946_l();
    int display_list = 0;
    byte warmup_time = 0;
    boolean should_use_display_list = true;
    public FzOrientation orientation = FzOrientation.FACE_UP_POINT_NORTH;
    public Type type = Type.NORMAL;
    Object notice_target = this;
    private static final int maxStackDrop = 8192;
    private int last_mentioned_count = -1;
    private boolean spammed = false;
    private static final int[] top_slot = new int[]{0};
    private static final int[] bottom_slot = new int[]{1};
    private static final int[] no_slots = new int[0];
    long lastClick = -1000L;
    private static int last_hit_side = -1;
    public static ArrayList<ItemStack> barrel_items = new ArrayList();
    boolean broken_with_silk_touch = false;
    static final TIntSet finalizedDisplayLists;
    private static int iterateDelay;

    @Override
    public FactoryType getFactoryType() {
        return FactoryType.DAYBARREL;
    }

    @Override
    public BlockClass getBlockClass() {
        return BlockClass.Barrel;
    }

    @Override
    public void putData(DataHelper data) throws IOException {
        int count;
        this.item = data.as(Share.VISIBLE, "item").putItemStack(this.item);
        try {
            count = data.as(Share.VISIBLE, "count").putInt(this.getItemCount());
        }
        catch (Throwable t) {
            t.printStackTrace();
            count = 0;
        }
        this.orientation = data.as(Share.VISIBLE, "dir").putFzOrientation(this.orientation);
        if (data.isReader()) {
            this.setItemCount(count);
        }
        this.woodLog = data.as(Share.VISIBLE, "log").putItemStack(this.woodLog);
        this.woodSlab = data.as(Share.VISIBLE, "slab").putItemStack(this.woodSlab);
        this.type = data.as(Share.VISIBLE, "type").putEnum(this.type);
        if (this.woodLog == null) {
            this.woodLog = DEFAULT_LOG;
        }
        if (this.woodSlab == null) {
            this.woodSlab = DEFAULT_SLAB;
        }
        if (data.isReader() && data.isNBT()) {
            this.last_mentioned_count = this.getItemCount();
        }
    }

    public boolean canUpdate() {
        return this.type == Type.HOPPING;
    }

    @Override
    protected void doLogic() {
        Coord here;
        if (this.type != Type.HOPPING) {
            return;
        }
        this.needLogic();
        if (this.orientation == FzOrientation.UNKNOWN) {
            return;
        }
        if (this.notice_target == this && this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0) {
            return;
        }
        boolean youve_changed_jim = false;
        int itemCount = this.getItemCount();
        if (itemCount < this.getMaxSize()) {
            ItemStack got;
            here = this.getCoord();
            here.adjust(this.orientation.top);
            IInventory upi = here.getTE(IInventory.class);
            InvUtil.FzInv upinv = InvUtil.openInventory(upi, this.orientation.top.getOpposite());
            if (upinv != null && (got = upinv.pull(this.item, 1, true)) != null) {
                upi.func_70296_d();
                this.taint(got);
                this.changeItemCount(1);
                this.updateStacks();
                youve_changed_jim = true;
            }
        }
        if (itemCount > 0) {
            ItemStack bottom_item;
            here = this.getCoord();
            here.adjust(this.orientation.top.getOpposite());
            IInventory downi = here.getTE(IInventory.class);
            InvUtil.FzInv downinv = InvUtil.openInventory(downi, this.orientation.top);
            if (downinv != null && (bottom_item = this.func_70301_a(1)) != null) {
                ItemStack toPush = bottom_item.func_77979_a(1);
                ItemStack got = downinv.push(toPush);
                if (got == null) {
                    downi.func_70296_d();
                    this.updateStacks();
                    this.cleanBarrel();
                    youve_changed_jim = true;
                } else {
                    ++bottom_item.field_77994_a;
                }
            }
        }
        if (youve_changed_jim) {
            this.func_70296_d();
        }
    }

    @Override
    protected int getLogicSpeed() {
        return 8;
    }

    @Override
    public void neighborChanged() {
        super.neighborChanged();
        if (this.type == Type.HOPPING) {
            this.needLogic();
        }
    }

    public int getItemCount() {
        if (this.item == null) {
            return 0;
        }
        if (this.type == Type.CREATIVE) {
            return 32 * this.item.func_77976_d();
        }
        if (this.topStack == null || !this.itemMatch(this.topStack)) {
            this.topStack = this.item.func_77946_l();
            this.topStack.field_77994_a = 0;
        }
        if (this.bottomStack == null || !this.itemMatch(this.bottomStack)) {
            this.bottomStack = this.item.func_77946_l();
            this.bottomStack.field_77994_a = 0;
        }
        int ret = this.bottomStack.field_77994_a + this.middleCount + this.topStack.field_77994_a;
        return ret;
    }

    public int getItemCountSticky() {
        int count = this.getItemCount();
        if (this.type == Type.STICKY) {
            return Math.max(0, --count);
        }
        return count;
    }

    public int getMaxSize() {
        int size = 4096;
        if (this.item != null) {
            size = this.item.func_77976_d() * 64;
        }
        if (this.type == Type.LARGER) {
            size *= 2;
        }
        return size;
    }

    public boolean itemMatch(ItemStack is) {
        if (is == null || this.item == null) {
            return false;
        }
        return ItemUtil.couldMerge(this.item, is);
    }

    boolean taint(ItemStack is) {
        if (is == null && this.item == null) {
            return true;
        }
        if (is == null) {
            return false;
        }
        if (this.item == null) {
            this.item = is.func_77946_l();
            this.item.field_77994_a = 0;
            return true;
        }
        return ItemUtil.couldMerge(this.item, is);
    }

    boolean isTop(ForgeDirection d) {
        return d == this.orientation.top;
    }

    boolean isTopOrBack(ForgeDirection d) {
        return d == this.orientation.top || d == this.orientation.facing.getOpposite();
    }

    boolean isBottom(ForgeDirection d) {
        return d == this.orientation.top.getOpposite();
    }

    boolean isBack(ForgeDirection d) {
        return d == this.orientation.facing.getOpposite();
    }

    public void setItemCount(int val) {
        this.bottomStack = null;
        this.topStack = null;
        this.middleCount = val;
        this.changeItemCount(0);
    }

    public void changeItemCount(int delta) {
        this.middleCount = this.getItemCount() + delta;
        if (this.middleCount < 0) {
            if (!this.spammed) {
                Core.logSevere("Tried to set the item count to negative value " + this.middleCount + " at " + this.getCoord(), new Object[0]);
                Thread.dumpStack();
                this.spammed = true;
            }
            this.middleCount = 0;
            this.item = null;
        }
        if (this.middleCount == 0) {
            this.item = null;
            this.bottomStack = null;
            this.topStack = null;
            this.updateClients(NetworkFactorization.MessageType.BarrelCount);
            this.func_70296_d();
            return;
        }
        if (this.topStack == null) {
            this.topStack = this.item.func_77946_l();
        }
        if (this.bottomStack == null) {
            this.bottomStack = this.item.func_77946_l();
        }
        this.bottomStack.field_77994_a = 0;
        this.topStack.field_77994_a = 0;
        this.updateStacks();
        this.updateClients(NetworkFactorization.MessageType.BarrelCount);
        this.func_70296_d();
    }

    @Override
    public void onPlacedBy(EntityPlayer player, ItemStack is, int side, float hitX, float hitY, float hitZ) {
        this.orientation = SpaceUtil.getOrientation(player, side, hitX, hitY, hitZ);
        this.loadFromStack(is);
        this.needLogic();
    }

    @Override
    public void loadFromStack(ItemStack is) {
        ItemStack loadItem;
        NBTTagCompound tag;
        int loadCount;
        super.loadFromStack(is);
        this.woodLog = TileEntityDayBarrel.getLog(is);
        this.woodSlab = TileEntityDayBarrel.getSlab(is);
        this.type = TileEntityDayBarrel.getUpgrade(is);
        if (this.type == Type.SILKY && is.func_77942_o() && (loadCount = (tag = is.func_77978_p()).func_74762_e("SilkCount")) != 0 && (loadItem = TileEntityDayBarrel.getSilkedItem(is)) != null) {
            this.item = loadItem;
            this.setItemCount(loadCount);
        }
    }

    public static ItemStack getSilkedItem(ItemStack is) {
        if (is == null || !is.func_77942_o()) {
            return null;
        }
        NBTTagCompound tag = is.func_77978_p();
        if (tag.func_74764_b("SilkItem")) {
            return ItemStack.func_77949_a((NBTTagCompound)is.func_77978_p().func_74775_l("SilkItem"));
        }
        return null;
    }

    public static boolean isNested(ItemStack is) {
        return TileEntityDayBarrel.getSilkedItem(is) != null;
    }

    FMLProxyPacket getPacket(NetworkFactorization.MessageType messageType) {
        if (messageType == NetworkFactorization.MessageType.BarrelItem) {
            return Core.network.TEmessagePacket(this.getCoord(), messageType, NetworkFactorization.nullItem(this.item), this.getItemCount());
        }
        if (messageType == NetworkFactorization.MessageType.BarrelCount) {
            return Core.network.TEmessagePacket(this.getCoord(), messageType, this.getItemCount());
        }
        new IllegalArgumentException("bad MessageType: " + (Object)((Object)messageType)).printStackTrace();
        return null;
    }

    void updateClients(NetworkFactorization.MessageType messageType) {
        if (this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
            return;
        }
        this.broadcastMessage(null, this.getPacket(messageType));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean handleMessageFromServer(NetworkFactorization.MessageType messageType, ByteBuf input) throws IOException {
        if (super.handleMessageFromServer(messageType, input)) {
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.BarrelDescription) {
            this.item = DataUtil.readStack(input);
            this.setItemCount(input.readInt());
            this.woodLog = DataUtil.readStack(input);
            this.woodSlab = DataUtil.readStack(input);
            this.orientation = FzOrientation.getOrientation(input.readByte());
            this.type = Type.valueOf(input.readByte());
            this.freeDisplayList();
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.BarrelCount) {
            this.setItemCount(input.readInt());
            this.freeDisplayList();
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.BarrelItem) {
            this.item = DataUtil.readStack(input);
            this.setItemCount(input.readInt());
            this.freeDisplayList();
            return true;
        }
        if (messageType == NetworkFactorization.MessageType.BarrelDoubleClickHack) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71442_b.field_85183_f = mc.field_71439_g.func_70694_bm();
            return true;
        }
        return false;
    }

    void cleanBarrel() {
        if (this.getItemCount() == 0) {
            this.item = null;
            this.bottomStack = null;
            this.topStack = null;
            this.middleCount = 0;
        }
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        this.cleanBarrel();
        this.updateStacks();
        int c = this.getItemCount();
        if (c != this.last_mentioned_count) {
            if (this.last_mentioned_count * c <= 0) {
                this.updateClients(NetworkFactorization.MessageType.BarrelItem);
            } else {
                this.updateClients(NetworkFactorization.MessageType.BarrelCount);
            }
            this.last_mentioned_count = c;
        }
        if (this.type == Type.HOPPING) {
            this.needLogic();
        }
    }

    public int func_70302_i_() {
        return 2;
    }

    private void updateStacks() {
        if (this.item == null) {
            this.bottomStack = null;
            this.topStack = null;
            this.middleCount = 0;
            return;
        }
        int count = this.getItemCount();
        if (count == 0) {
            this.bottomStack = null;
            this.topStack = null;
            this.middleCount = 0;
            return;
        }
        if (this.bottomStack == null) {
            this.bottomStack = this.item.func_77946_l();
            this.bottomStack.field_77994_a = 0;
        }
        int upperLine = this.getMaxSize() - this.item.func_77976_d();
        if (this.type == Type.STICKY) {
            if (--count < 0) {
                return;
            }
            --upperLine;
        }
        if (this.topStack == null) {
            this.topStack = this.item.func_77946_l();
        }
        if (count > upperLine) {
            this.topStack.field_77994_a = count - upperLine;
            count -= this.topStack.field_77994_a;
        } else {
            this.topStack.field_77994_a = 0;
        }
        this.bottomStack.field_77994_a = Math.min(this.item.func_77976_d(), count);
        this.middleCount = count -= this.bottomStack.field_77994_a;
        if (this.type == Type.STICKY) {
            ++this.middleCount;
        }
    }

    public ItemStack func_70301_a(int i) {
        this.updateStacks();
        if (i == 0) {
            return this.topStack;
        }
        if (i == 1) {
            return this.bottomStack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack is) {
        if (is != null && !this.taint(is)) {
            if (!this.spammed) {
                Core.logWarning("Bye bye, %s", is);
                Thread.dumpStack();
                this.spammed = true;
            }
            return;
        }
        if (slot == 0) {
            this.topStack = is;
        } else if (slot == 1) {
            this.bottomStack = is;
        } else if (!this.spammed) {
            Core.logSevere("Say goodbye, %s !", is);
            Thread.dumpStack();
            this.spammed = true;
        }
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
    }

    public String func_145825_b() {
        return "Barrel";
    }

    public boolean func_94041_b(int i, ItemStack is) {
        if (i != 0) {
            return false;
        }
        if (this.item == null) {
            return !TileEntityDayBarrel.isNested(is);
        }
        return this.itemMatch(is);
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        ForgeDirection d = ForgeDirection.getOrientation((int)side);
        return this.isTop(d.getOpposite());
    }

    public int[] func_94128_d(int i) {
        ForgeDirection d = ForgeDirection.getOrientation((int)i);
        if (this.isTopOrBack(d)) {
            return top_slot;
        }
        if (this.isBottom(d)) {
            return bottom_slot;
        }
        return no_slots;
    }

    @Override
    public boolean activate(EntityPlayer entityplayer, ForgeDirection side) {
        if (entityplayer.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.field_145850_b.func_82737_E() - this.lastClick < 10L && this.item != null) {
            this.addAllItems(entityplayer);
            return true;
        }
        this.lastClick = this.field_145850_b.func_82737_E();
        ItemStack held = entityplayer.func_70694_bm();
        if (held == null) {
            this.info(entityplayer);
            return true;
        }
        if (!this.field_145850_b.field_72995_K && TileEntityDayBarrel.isNested(held) && (this.item == null || this.itemMatch(held))) {
            new Notice(this.notice_target, "No.", new String[0]).send(entityplayer);
            return true;
        }
        NBTTagCompound tag = held.func_77978_p();
        if (tag != null && tag.func_74764_b("noFzBarrel")) {
            return false;
        }
        boolean veryNew = this.taint(held);
        if (!this.itemMatch(held)) {
            if (LangUtil.getTranslationKey(held.func_77973_b()).equals(LangUtil.getTranslationKey(this.item))) {
                new Notice(this.notice_target, "That item is different", new String[0]).send(entityplayer);
            } else {
                this.info(entityplayer);
            }
            return true;
        }
        int free = this.getMaxSize() - this.getItemCount();
        if (free <= 0) {
            this.info(entityplayer);
            return true;
        }
        int take = Math.min(free, held.field_77994_a);
        held.field_77994_a -= take;
        this.changeItemCount(take);
        if (veryNew) {
            this.updateClients(NetworkFactorization.MessageType.BarrelItem);
        }
        if (held.field_77994_a == 0) {
            entityplayer.func_70062_b(0, null);
        }
        return true;
    }

    void addAllItems(EntityPlayer entityplayer) {
        int free_space;
        ItemStack held = entityplayer.func_70694_bm();
        if (held != null) {
            this.taint(held);
        }
        InventoryPlayer inv = entityplayer.field_71071_by;
        int total_delta = 0;
        for (int i = 0; i < inv.func_70302_i_() && (free_space = this.getMaxSize() - (this.getItemCount() + total_delta)) > 0; ++i) {
            ItemStack is = inv.func_70301_a(i);
            if (is == null || is.field_77994_a <= 0 || !this.itemMatch(is)) continue;
            int toAdd = Math.min(is.field_77994_a, free_space);
            if (is == held && toAdd > 1) {
                --toAdd;
            }
            total_delta += toAdd;
            is.field_77994_a -= toAdd;
            if (is.field_77994_a > 0) continue;
            inv.func_70299_a(i, null);
        }
        this.changeItemCount(total_delta);
        if (total_delta > 0) {
            Core.proxy.updatePlayerInventory(entityplayer);
        }
    }

    @SubscribeEvent
    public void clickEvent(PlayerInteractEvent event) {
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        last_hit_side = event.face;
    }

    static boolean isStairish(Coord c) {
        Block b = c.getBlock();
        if (b == null) {
            return false;
        }
        if (b instanceof BlockRailBase) {
            return true;
        }
        AxisAlignedBB ab = c.getCollisionBoundingBoxFromPool();
        ArrayList list = new ArrayList();
        b.func_149743_a(c.w, c.x, c.y, c.z, ab, list, null);
        for (AxisAlignedBB bb : list) {
            if (!(bb.field_72337_e - (double)c.y <= 0.51)) continue;
            return true;
        }
        return false;
    }

    boolean punt(EntityPlayer player) {
        Coord src;
        int distance = PlayerUtil.getPuntStrengthInt(player);
        if (distance <= 0) {
            return false;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)last_hit_side).getOpposite();
        if (dir == ForgeDirection.UNKNOWN) {
            return false;
        }
        Coord next = src = this.getCoord();
        FzOrientation newOrientation = this.orientation;
        boolean doRotation = dir.offsetY == 0;
        ForgeDirection rotationAxis = ForgeDirection.UNKNOWN;
        if (doRotation) {
            rotationAxis = dir.getRotation(ForgeDirection.UP);
        }
        if (player.func_70093_af() && distance > 1) {
            distance = 1;
        }
        int spillage = distance;
        int doubleRolls = 0;
        for (int i = 0; i < distance && i <= 6; ++i) {
            boolean must_rise_or_fail = false;
            Coord peek = next.add(dir);
            if (!peek.blockExists()) break;
            Coord below = peek.add(ForgeDirection.DOWN);
            int rotateCount = 1;
            if (!peek.isReplacable()) {
                Coord above;
                if (!TileEntityDayBarrel.isStairish(peek) || !(above = peek.add(ForgeDirection.UP)).isAir()) break;
                next = above;
                spillage += 3;
                ++rotateCount;
                ++doubleRolls;
            } else if (below.isReplacable() && i != distance - 1) {
                next = below;
                ++spillage;
            } else {
                next = peek;
            }
            if (!doRotation) {
                rotateCount = 0;
            }
            for (int r = rotateCount; r > 0; --r) {
                ForgeDirection nTop = newOrientation.top.getRotation(rotationAxis);
                ForgeDirection nFace = newOrientation.facing.getRotation(rotationAxis);
                newOrientation = FzOrientation.fromDirection(nFace).pointTopTo(nTop);
            }
        }
        if (src.equals(next)) {
            return false;
        }
        if (!doRotation && this.orientation.top == ForgeDirection.UP && dir == ForgeDirection.UP) {
            spillage = 0;
        }
        if (doubleRolls % 2 == 1) {
            Sound.barrelPunt2.playAt(src);
        } else {
            Sound.barrelPunt.playAt(src);
        }
        src.rmTE();
        src.setAir();
        if (newOrientation != FzOrientation.UNKNOWN) {
            this.orientation = newOrientation;
        }
        this.func_145829_t();
        next.setId(this.getBlockClass().block);
        next.setTE(this);
        last_hit_side = -1;
        player.func_71020_j(0.5f);
        ItemStack is = player.func_70694_bm();
        if (is != null && is.func_77984_f() && this.field_145850_b.field_73012_v.nextInt(4) == 0) {
            is.func_77972_a(distance, (EntityLivingBase)player);
            if (is.field_77994_a <= 0) {
                player.func_71028_bD();
            }
        }
        return true;
    }

    @Override
    public void click(EntityPlayer entityplayer) {
        ItemStack newHeld;
        Entity ent;
        if (entityplayer.field_70170_p.field_72995_K) {
            return;
        }
        if (this.punt(entityplayer)) {
            return;
        }
        if (this.getItemCount() == 0 || this.item == null) {
            this.info(entityplayer);
            return;
        }
        ItemStack origHeldItem = entityplayer.func_70694_bm();
        if (ForgeHooks.canToolHarvestBlock((Block)Blocks.field_150364_r, (int)0, (ItemStack)origHeldItem)) {
            return;
        }
        int to_remove = Math.min(this.item.func_77976_d(), this.getItemCount());
        if (entityplayer.func_70093_af() && to_remove >= 1) {
            to_remove = 1;
        }
        if (to_remove > 1 && to_remove == this.getItemCount()) {
            --to_remove;
        }
        if ((ent = ItemUtil.giveItem(entityplayer, new Coord(this), this.makeStack(to_remove), ForgeDirection.getOrientation((int)last_hit_side))) != null && ent.field_70128_L && !(entityplayer instanceof FakePlayer) && (newHeld = entityplayer.func_70694_bm()) != origHeldItem) {
            this.broadcastMessage(entityplayer, NetworkFactorization.MessageType.BarrelDoubleClickHack, new Object[0]);
        }
        this.changeItemCount(-to_remove);
        this.cleanBarrel();
        last_hit_side = -1;
    }

    void info(EntityPlayer entityplayer) {
        new Notice(this.notice_target, new NoticeUpdater(){

            @Override
            public void update(Notice msg) {
                int itemCount = TileEntityDayBarrel.this.getItemCount();
                if (TileEntityDayBarrel.this.item == null && TileEntityDayBarrel.this.getItemCount() == 0) {
                    msg.setMessage("Empty", new String[0]);
                } else if (TileEntityDayBarrel.this.getItemCount() >= TileEntityDayBarrel.this.getMaxSize()) {
                    msg.withItem(TileEntityDayBarrel.this.item).setMessage("Full of {ITEM_NAME}{ITEM_INFOS_NEWLINE}", new String[0]);
                } else {
                    String count = "" + TileEntityDayBarrel.this.getItemCount();
                    if (TileEntityDayBarrel.this.type == Type.CREATIVE) {
                        count = "Infinite";
                    }
                    msg.withItem(TileEntityDayBarrel.this.item).setMessage("%s {ITEM_NAME}{ITEM_INFOS_NEWLINE}", count);
                }
            }
        }).send(entityplayer);
    }

    private ItemStack makeStack(int count) {
        if (this.item == null) {
            return null;
        }
        ItemStack ret = this.item.func_77946_l();
        ret.field_77994_a = count;
        assert (ret.field_77994_a > 0 && ret.field_77994_a <= this.item.func_77976_d());
        return ret;
    }

    @Override
    public int getComparatorValue(ForgeDirection side) {
        int count = this.getItemCount();
        if (count == 0) {
            return 0;
        }
        int max = this.getMaxSize();
        if (count == max) {
            return 15;
        }
        float v = (float)count / (float)max;
        return (int)Math.max(1.0f, v * 14.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ForgeDirection dir) {
        if (dir.offsetY != 0) {
            Block ws = DataUtil.getBlock(this.woodSlab);
            if (ws != null) {
                return ws.func_149691_a(0, this.woodSlab.func_77960_j());
            }
            return this.woodSlab.func_77973_b().getIcon(this.woodSlab, 0);
        }
        Block wl = DataUtil.getBlock(this.woodLog);
        if (wl != null) {
            return wl.func_149691_a(2, this.woodLog.func_77960_j());
        }
        return this.woodLog.func_77973_b().getIcon(this.woodLog, 0);
    }

    @Override
    public void dropContents() {
        if (this.type == Type.CREATIVE || this.type == Type.SILKY && this.broken_with_silk_touch) {
            return;
        }
        if (this.item == null || this.getItemCount() <= 0) {
            return;
        }
        int count = this.getItemCount();
        for (int i = 0; i < 8192; ++i) {
            int to_drop = Math.min(this.item.func_77976_d(), count);
            ItemUtil.giveItem(null, new Coord(this), this.makeStack(to_drop), ForgeDirection.UNKNOWN);
            if ((count -= to_drop) <= 0) break;
        }
        this.topStack = null;
        this.middleCount = 0;
        this.bottomStack = null;
    }

    public boolean canLose() {
        return this.item != null && this.getItemCount() > 8192 * this.item.func_77976_d();
    }

    public static ItemStack makeBarrel(Type type, ItemStack log, ItemStack slab) {
        ItemStack barrel_item = new ItemStack((Item)Core.registry.daybarrel);
        barrel_item = TileEntityDayBarrel.addUpgrade(barrel_item, type);
        NBTTagCompound tag = ItemUtil.getTag(barrel_item);
        tag.func_74782_a("log", (NBTBase)DataUtil.item2tag(log));
        tag.func_74782_a("slab", (NBTBase)DataUtil.item2tag(slab));
        int dmg = DataUtil.getName(log).hashCode() * 16 + log.func_77960_j();
        dmg %= 1000;
        dmg *= 10;
        barrel_item.func_77964_b(dmg += type.ordinal());
        return barrel_item;
    }

    private static ItemStack make(Type type, ItemStack log, ItemStack slab) {
        ItemStack ret = TileEntityDayBarrel.makeBarrel(type, log, slab);
        barrel_items.add(ret);
        return ret;
    }

    public static void makeRecipe(Object objLog, Object objSlab) {
        ItemStack slab;
        ItemStack log;
        if (objLog instanceof ItemStack) {
            log = (ItemStack)objLog;
        } else {
            log = ItemUtil.getFirstOre((String)objLog);
            if (log == null) {
                return;
            }
        }
        if (objSlab instanceof ItemStack) {
            slab = (ItemStack)objSlab;
        } else {
            slab = ItemUtil.getFirstOre((String)objSlab);
            if (slab == null) {
                return;
            }
        }
        ItemStack normal = TileEntityDayBarrel.make(Type.NORMAL, log, slab);
        Core.registry.oreRecipe(normal, "W-W", "W W", "WWW", Character.valueOf('W'), objLog, Character.valueOf('-'), objSlab);
    }

    public static Type getUpgrade(ItemStack is) {
        if (is == null) {
            return Type.NORMAL;
        }
        NBTTagCompound tag = is.func_77978_p();
        if (tag == null) {
            return Type.NORMAL;
        }
        String name = tag.func_74779_i("type");
        if (name == null || name.equals("")) {
            return Type.NORMAL;
        }
        try {
            return Type.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            Core.logWarning("%s has invalid barrel Type %s. Resetting it.", is, name);
            e.printStackTrace();
            tag.func_82580_o("type");
            return Type.NORMAL;
        }
    }

    public static ItemStack getLog(ItemStack is) {
        return TileEntityDayBarrel.get(is, "log", DEFAULT_LOG);
    }

    public static ItemStack getSlab(ItemStack is) {
        return TileEntityDayBarrel.get(is, "slab", DEFAULT_SLAB);
    }

    private static ItemStack get(ItemStack is, String name, ItemStack default_) {
        NBTTagCompound tag = is.func_77978_p();
        if (tag == null) {
            return default_.func_77946_l();
        }
        if ((tag = tag.func_74775_l(name)) == null) {
            return default_.func_77946_l();
        }
        return DataUtil.tag2item(tag, default_);
    }

    static ItemStack addUpgrade(ItemStack barrel, Type upgrade) {
        if (upgrade == Type.NORMAL) {
            return barrel;
        }
        barrel = barrel.func_77946_l();
        NBTTagCompound tag = ItemUtil.getTag(barrel);
        tag.func_74778_a("type", upgrade.toString());
        return barrel;
    }

    @Override
    public boolean rotate(ForgeDirection axis) {
        if (axis == ForgeDirection.UNKNOWN) {
            return false;
        }
        if (axis == this.orientation.facing || axis.getOpposite() == this.orientation.facing) {
            this.orientation = this.orientation.getNextRotationOnFace();
            return true;
        }
        if (axis == this.orientation.top || axis.getOpposite() == this.orientation.top) {
            this.orientation = this.orientation.getNextRotationOnTop();
            return true;
        }
        this.orientation = FzOrientation.fromDirection(axis);
        return true;
    }

    @Override
    public ItemStack getDroppedBlock() {
        ItemStack is = TileEntityDayBarrel.makeBarrel(this.type, this.woodLog, this.woodSlab);
        if (this.type == Type.SILKY && this.item != null && this.getItemCount() > 0) {
            NBTTagCompound tag = ItemUtil.getTag(is);
            tag.func_74768_a("SilkCount", this.getItemCount());
            NBTTagCompound si = new NBTTagCompound();
            this.item.func_77955_b(si);
            tag.func_74782_a("SilkItem", (NBTBase)si);
            tag.func_74772_a("rnd", (long)this.hashCode() + this.field_145850_b.func_82737_E());
        }
        return is;
    }

    @Override
    protected boolean removedByPlayer(EntityPlayer player, boolean willHarvest) {
        if (this.cancelRemovedByPlayer(player)) {
            return false;
        }
        this.broken_with_silk_touch = EnchantmentHelper.func_77502_d((EntityLivingBase)player);
        return super.removedByPlayer(player, willHarvest);
    }

    private boolean cancelRemovedByPlayer(EntityPlayer player) {
        if (this.item == null) {
            return false;
        }
        if (player == null) {
            return false;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (player.func_70093_af()) {
            return false;
        }
        if (player.field_70170_p.field_72995_K) {
            Core.proxy.sendBlockClickPacket();
        } else {
            this.click(player);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFinalizedDisplayList(int display_list) {
        if (display_list == 0) {
            return;
        }
        TIntSet tIntSet = finalizedDisplayLists;
        synchronized (tIntSet) {
            finalizedDisplayLists.add(display_list);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void finalize() throws Throwable {
        super.finalize();
        if (this.display_list != 0) {
            if (Core.dev_environ) {
                Core.logFine("Barrel display list released via finalization", new Object[0]);
            }
            TileEntityDayBarrel.addFinalizedDisplayList(this.display_list);
            this.display_list = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    final void freeDisplayList() {
        if (this.display_list != 0) {
            GLAllocation.func_74523_b((int)this.display_list);
            this.display_list = 0;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void removeUnloadedDisplayLists(ChunkEvent.Unload event) {
        if (!event.world.field_72995_K) {
            return;
        }
        for (TileEntity te : event.getChunk().field_150816_i.values()) {
            if (!(te instanceof TileEntityDayBarrel)) continue;
            TileEntityDayBarrel me = (TileEntityDayBarrel)te;
            me.freeDisplayList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void iterateForFinalizedBarrels(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (iterateDelay > 0) {
            --iterateDelay;
            return;
        }
        iterateDelay = 1200;
        TIntSet tIntSet = finalizedDisplayLists;
        synchronized (tIntSet) {
            TIntIterator iterator = finalizedDisplayLists.iterator();
            while (iterator.hasNext()) {
                try {
                    GLAllocation.func_74523_b((int)iterator.next());
                }
                catch (Exception e) {
                    Core.logWarning("Freeing display list failed! Was the display list attempted to be freed twice?", new Object[0]);
                    e.printStackTrace();
                }
            }
            finalizedDisplayLists.clear();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderHilightArrow(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        if (!Minecraft.func_71382_s()) {
            return;
        }
        ItemStack is = player.func_70694_bm();
        if (is == null) {
            return;
        }
        if (is.func_77973_b() != Core.registry.daybarrel) {
            return;
        }
        MovingObjectPosition mop = mc.field_71476_x;
        if (mop == null || mop.field_72307_f == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        Vec3 vec = mop.field_72307_f;
        FzOrientation orientation = SpaceUtil.getOrientation((EntityPlayer)player, mop.field_72310_e, (float)(vec.field_72450_a - (double)mop.field_72311_b), (float)(vec.field_72448_b - (double)mop.field_72312_c), (float)(vec.field_72449_c - (double)mop.field_72309_d));
        if (orientation.top.offsetY == 1) {
            return;
        }
        GL11.glPushMatrix();
        EntityLivingBase camera = Minecraft.func_71410_x().field_71451_h;
        double cx = camera.field_70142_S + (camera.field_70165_t - camera.field_70142_S) * (double)event.partialTicks;
        double cy = camera.field_70137_T + (camera.field_70163_u - camera.field_70137_T) * (double)event.partialTicks;
        double cz = camera.field_70136_U + (camera.field_70161_v - camera.field_70136_U) * (double)event.partialTicks;
        GL11.glTranslated((double)(-cx), (double)(-cy), (double)(-cz));
        ForgeDirection fd = ForgeDirection.getOrientation((int)mop.field_72310_e);
        GL11.glTranslatef((float)(mop.field_72311_b + fd.offsetX), (float)(mop.field_72312_c + fd.offsetY), (float)(mop.field_72309_d + fd.offsetZ));
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glLineWidth((float)2.0f);
        ForgeDirection face = orientation.facing;
        if (SpaceUtil.sign(face) == 1) {
            GL11.glTranslated((double)face.offsetX, (double)face.offsetY, (double)face.offsetZ);
        }
        float d = -2.0f;
        GL11.glTranslatef((float)(d * (float)fd.offsetX), (float)(d * (float)fd.offsetY), (float)(d * (float)fd.offsetZ));
        GL11.glTranslated((double)(0.5 * (double)(1 - Math.abs(face.offsetX))), (double)(0.5 * (double)(1 - Math.abs(face.offsetY))), (double)(0.5 * (double)(1 - Math.abs(face.offsetZ))));
        GL11.glBegin((int)2);
        float mid_x = orientation.facing.offsetX;
        float mid_y = orientation.facing.offsetY;
        float mid_z = orientation.facing.offsetZ;
        float top_x = mid_x + (float)orientation.top.offsetX / 2.0f;
        float top_y = mid_y + (float)orientation.top.offsetY / 2.0f;
        float top_z = mid_z + (float)orientation.top.offsetZ / 2.0f;
        float bot_x = mid_x - (float)orientation.top.offsetX / 2.0f;
        float bot_y = mid_y - (float)orientation.top.offsetY / 2.0f;
        float bot_z = mid_z - (float)orientation.top.offsetZ / 2.0f;
        ForgeDirection r = orientation.facing.getRotation(orientation.top);
        float right_x = (float)r.offsetX / 2.0f;
        float right_y = (float)r.offsetY / 2.0f;
        float right_z = (float)r.offsetZ / 2.0f;
        GL11.glVertex3f((float)top_x, (float)top_y, (float)top_z);
        GL11.glVertex3f((float)(mid_x + right_x), (float)(mid_y + right_y), (float)(mid_z + right_z));
        d = 0.25f;
        GL11.glVertex3f((float)(mid_x + right_x * d), (float)(mid_y + right_y * d), (float)(mid_z + right_z * d));
        GL11.glVertex3f((float)(bot_x + right_x * d), (float)(bot_y + right_y * d), (float)(bot_z + right_z * d));
        d = -0.25f;
        GL11.glVertex3f((float)(bot_x + right_x * d), (float)(bot_y + right_y * d), (float)(bot_z + right_z * d));
        GL11.glVertex3f((float)(mid_x + right_x * d), (float)(mid_y + right_y * d), (float)(mid_z + right_z * d));
        GL11.glVertex3f((float)(mid_x - right_x), (float)(mid_y - right_y), (float)(mid_z - right_z));
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
    }

    public boolean isWooden() {
        Block log = DataUtil.getBlock(this.woodLog);
        return log != null && log.func_149688_o() == Material.field_151575_d;
    }

    public int getFlamability() {
        return this.isWooden() ? 20 : 0;
    }

    @Override
    public int compareRenderer(TileEntityDayBarrel other) {
        return RenderSorter.compareItemRender(this.item, other.item, IItemRenderer.ItemRenderType.INVENTORY);
    }

    static {
        TileEntityDayBarrel.make(Type.CREATIVE, new ItemStack(Blocks.field_150357_h), new ItemStack(Blocks.field_150484_ah));
        finalizedDisplayLists = new TIntHashSet();
        iterateDelay = 0;
    }

    public static enum Type {
        NORMAL,
        SILKY,
        HOPPING,
        LARGER,
        STICKY,
        CREATIVE;

        private static Type[] value_list;
        public static final int TYPE_COUNT;

        public static Type valueOf(int ordinal) {
            if (ordinal < 0 || ordinal >= value_list.length) {
                return NORMAL;
            }
            return value_list[ordinal];
        }

        static {
            value_list = Type.values();
            TYPE_COUNT = Type.values().length;
        }
    }
}

