/*
 * Decompiled with CFR 0.152.
 */
package factorization.weird;

import factorization.api.Coord;
import factorization.api.FzOrientation;
import factorization.api.Quaternion;
import factorization.common.BlockIcons;
import factorization.common.FactoryType;
import factorization.common.FzConfig;
import factorization.common.ItemIcons;
import factorization.shared.Core;
import factorization.shared.NetworkFactorization;
import factorization.util.DataUtil;
import factorization.util.RenderUtil;
import factorization.util.SpaceUtil;
import factorization.weird.TileEntityDayBarrel;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class TileEntityDayBarrelRenderer
extends TileEntitySpecialRenderer {
    final String[] fontIdx = new String[]{"0123", "4567", "89*+", "i!  "};
    Tessellator voidTessellator = new Tessellator(){

        public void func_78377_a(double par1, double par3, double par5) {
        }

        public void func_78371_b(int par1) {
        }

        public int func_78381_a() {
            return 0;
        }
    };
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    final RenderItem renderItem = new RenderItem();
    TextureManager interception = null;
    EntityItem entityitem;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doDraw(TileEntityDayBarrel barrel, ItemStack is) {
        double time;
        FzOrientation bo = barrel.orientation;
        ForgeDirection face = bo.facing;
        if (SpaceUtil.sign(face) == 1) {
            GL11.glTranslated((double)face.offsetX, (double)face.offsetY, (double)face.offsetZ);
        }
        GL11.glTranslated((double)(0.5 * (double)(1 - Math.abs(face.offsetX))), (double)(0.5 * (double)(1 - Math.abs(face.offsetY))), (double)(0.5 * (double)(1 - Math.abs(face.offsetZ))));
        Quaternion quat = Quaternion.fromOrientation(bo.getSwapped());
        quat.glRotate();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslated((double)0.25, (double)0.1875, (double)-0.0078125);
        if (barrel.type == TileEntityDayBarrel.Type.HOPPING && Math.sin((time = (double)barrel.func_145831_w().func_82737_E()) / 20.0) > 0.0) {
            double delta = Math.max(0.0, Math.sin(time / 2.0) / 16.0);
            GL11.glTranslated((double)0.0, (double)delta, (double)0.0);
        }
        GL11.glPushAttrib((int)24576);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)2896);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        boolean hasLabel = this.renderItemCount(is, barrel);
        try {
            this.handleRenderItem(is, barrel, hasLabel);
        }
        finally {
            GL11.glPopAttrib();
            GL11.glEnable((int)2896);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float partial) {
        if (!(tileentity instanceof TileEntityDayBarrel)) {
            return;
        }
        TileEntityDayBarrel barrel = (TileEntityDayBarrel)tileentity;
        ItemStack is = barrel.item;
        if (is == null || barrel.getItemCount() <= 0) {
            return;
        }
        Item item = is.func_77973_b();
        if (item == null) {
            return;
        }
        RenderUtil.checkGLError("A previous renderer is broken.");
        Core.profileStart("barrel");
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        try {
            if (FzConfig.render_barrel_use_displaylists && barrel.type != TileEntityDayBarrel.Type.HOPPING && barrel.should_use_display_list && barrel != FactoryType.DAYBARREL.getRepresentative()) {
                if (barrel.warmup_time < 20) {
                    barrel.warmup_time = (byte)(barrel.warmup_time + 1);
                    this.doDraw(barrel, is);
                    if (RenderUtil.checkGLError("FZ -- Item found to have broken renderer during warmup period")) {
                        Core.logSevere("The item is: " + is, new Object[0]);
                        Core.logSevere("At: " + new Coord(barrel), new Object[0]);
                        barrel.should_use_display_list = false;
                    }
                } else if (barrel.display_list == 0) {
                    boolean crazyItem = this.itemHasCustomRender(is);
                    if (crazyItem) {
                        barrel.should_use_display_list = false;
                        this.doDraw(barrel, is);
                        return;
                    }
                    RenderUtil.checkGLError("FZ -- before barrel display list update.");
                    if (barrel.display_list == 0) {
                        barrel.display_list = GLAllocation.func_74526_a((int)1);
                    }
                    GL11.glNewList((int)barrel.display_list, (int)4864);
                    this.doDraw(barrel, is);
                    GL11.glEndList();
                    if (RenderUtil.checkGLError("FZ -- after barrel display list; does the item have an advanced renderer?")) {
                        Core.logSevere("The item is: " + is, new Object[0]);
                        Core.logSevere("At: " + new Coord(barrel), new Object[0]);
                        barrel.should_use_display_list = false;
                        this.doDraw(barrel, is);
                    } else {
                        GL11.glCallList((int)barrel.display_list);
                    }
                } else {
                    GL11.glCallList((int)barrel.display_list);
                }
            } else {
                this.doDraw(barrel, is);
            }
        }
        finally {
            GL11.glPopMatrix();
            Core.profileEnd();
        }
    }

    private boolean itemHasCustomRender(ItemStack is) {
        Item item = is.func_77973_b();
        if (item == null) {
            return true;
        }
        if (item.hasEffect(is, 0) && item.func_77623_v()) {
            return true;
        }
        if (MinecraftForgeClient.getItemRenderer((ItemStack)is, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.INVENTORY) != null) {
            return true;
        }
        Block block = DataUtil.getBlock(is.func_77973_b());
        return block.func_149645_b() > 38;
    }

    String getCountLabel(ItemStack item, TileEntityDayBarrel barrel) {
        int ms = item.func_77976_d();
        int count = barrel.getItemCount();
        if (count == 1) {
            return "";
        }
        String t = "";
        if (ms == 1 || count == ms) {
            t = t + count;
        } else {
            int r;
            int q = count / ms;
            if (q > 0) {
                t = t + count / ms + "*" + ms;
            }
            if ((r = count % ms) != 0) {
                if (q > 0) {
                    t = t + "+";
                }
                t = t + r;
            }
        }
        if (barrel.canLose()) {
            t = "!" + t + "!";
        }
        if (barrel.type == TileEntityDayBarrel.Type.CREATIVE) {
            t = "i";
        }
        return t;
    }

    boolean renderItemCount(ItemStack item, TileEntityDayBarrel barrel) {
        IIcon font;
        if (!FzConfig.render_barrel_text) {
            return false;
        }
        String t = this.getCountLabel(item, barrel);
        if (t.isEmpty()) {
            return false;
        }
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        Minecraft mc = Minecraft.func_71410_x();
        if (item.func_94608_d() == 1) {
            font = BlockIcons.barrel_font;
            mc.field_71446_o.func_110577_a(Core.blockAtlas);
        } else {
            font = ItemIcons.barrel_font;
            mc.field_71446_o.func_110577_a(Core.itemAtlas);
        }
        int len = t.length();
        double char_width = 0.1;
        double char_height = 0.1;
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78373_b(-0.1 * (double)len / 2.0 + 0.25, -0.13125, 0.0);
        tess.func_78382_b();
        double du = (font.func_94212_f() - font.func_94209_e()) / 4.0f;
        double dv = (font.func_94210_h() - font.func_94206_g()) / 4.0f;
        double u = font.func_94209_e();
        double v = font.func_94206_g();
        for (int i = 0; i < len; ++i) {
            char c = t.charAt(i);
            int x = 0;
            int y = 0;
            boolean found = false;
            block1: for (y = 0; y < this.fontIdx.length; ++y) {
                String idx = this.fontIdx[y];
                for (x = 0; x < idx.length(); ++x) {
                    if (c != idx.charAt(x)) continue;
                    found = true;
                    break block1;
                }
            }
            if (!found) continue;
            double IX = (double)i * 0.1;
            double dy = 0.99609375;
            tess.func_78374_a(IX + 0.1, 0.0, 0.0, u + (double)(x + 1) * du, v + (double)y * dv);
            tess.func_78374_a(IX, 0.0, 0.0, u + (double)x * du, v + (double)y * dv);
            tess.func_78374_a(IX, 0.1, 0.0, u + (double)x * du, v + ((double)y + 0.99609375) * dv);
            tess.func_78374_a(IX + 0.1, 0.1, 0.0, u + (double)(x + 1) * du, v + ((double)y + 0.99609375) * dv);
        }
        tess.func_78381_a();
        tess.func_78373_b(0.0, 0.0, 0.0);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        return true;
    }

    public void handleRenderItem(ItemStack is, TileEntityDayBarrel barrel, boolean hasLabel) {
        if (!FzConfig.render_barrel_item) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float labelD = hasLabel ? 0.0f : -0.0625f;
        boolean useEntityRenderer = is.func_77973_b().func_77623_v();
        boolean useInterceptionRenderer = is.hasEffect(0);
        if (FzConfig.render_barrel_force_entity_render) {
            useEntityRenderer = true;
        }
        if (FzConfig.render_barrel_force_no_intercept) {
            useInterceptionRenderer = false;
        }
        if (useEntityRenderer) {
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.75f, (float)(-0.421875f - labelD), (float)0.0f);
            if (this.entityitem == null) {
                this.entityitem = new EntityItem(null, 0.0, 0.0, 0.0, NetworkFactorization.EMPTY_ITEMSTACK.func_77946_l());
            }
            this.entityitem.func_92058_a(is);
            this.entityitem.field_70290_d = 0.0f;
            GameSettings gs = Minecraft.func_71410_x().field_71474_y;
            boolean fancy = gs.field_74347_j;
            gs.field_74347_j = false;
            RenderItem.field_82407_g = true;
            RenderManager.field_78727_a.func_147940_a((Entity)this.entityitem, 1.0, 0.0, 0.0, 0.0f, 0.0f);
            RenderItem.field_82407_g = false;
            gs.field_74347_j = fancy;
        } else {
            GL11.glTranslatef((float)0.0f, (float)labelD, (float)0.03125f);
            float scale = 0.03125f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-0.02f);
            TextureManager re = Minecraft.func_71410_x().field_71446_o;
            FontRenderer fr = this.func_147498_b();
            if (useInterceptionRenderer) {
                if (this.interception == null) {
                    this.interception = new Intercepter(Minecraft.func_71410_x().func_110442_L());
                }
                Tessellator orig = Tessellator.field_78398_a;
                this.renderItem.func_82406_b(fr, this.interception, is, 0, 0);
                Tessellator.field_78398_a = orig;
            } else {
                this.renderItem.func_82406_b(fr, re, is, 0, 0);
            }
        }
        GL11.glPopMatrix();
    }

    class Intercepter
    extends TextureManager {
        final TextureManager realGuy;

        public Intercepter(IResourceManager par1ResourceManager) {
            super(par1ResourceManager);
            this.realGuy = Minecraft.func_71410_x().field_71446_o;
        }

        public ResourceLocation func_130087_a(int par1) {
            return this.realGuy.func_130087_a(par1);
        }

        public void func_110577_a(ResourceLocation res) {
            if (RES_ITEM_GLINT.equals((Object)res)) {
                Tessellator.field_78398_a = TileEntityDayBarrelRenderer.this.voidTessellator;
            } else {
                this.realGuy.func_110577_a(res);
            }
        }
    }
}

