/*
 * Decompiled with CFR 0.152.
 */
package factorization.weird.poster;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import factorization.api.Coord;
import factorization.api.Quaternion;
import factorization.api.datahelpers.DataHelper;
import factorization.api.datahelpers.Share;
import factorization.rendersorting.ISortableRenderer;
import factorization.rendersorting.RenderSorter;
import factorization.shared.Core;
import factorization.shared.EntityFz;
import factorization.util.ItemUtil;
import factorization.util.NumUtil;
import factorization.util.PlayerUtil;
import factorization.util.SpaceUtil;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityPoster
extends EntityFz
implements ISortableRenderer<EntityPoster> {
    public ItemStack inv;
    public Quaternion rot;
    public double scale;
    public boolean locked;
    Quaternion base_rotation;
    double base_scale;
    public short spin_normal;
    public short spin_vertical;
    public short spin_tilt;
    byte delta_scale;
    ForgeDirection norm;
    ForgeDirection top;
    ForgeDirection tilt;
    private static final double SCALE_INCR = 1.125;
    private static final double SPIN_PER_CLICK = 0.19634954084936207;

    public EntityPoster(World w) {
        super(w);
        this.inv = new ItemStack((Item)Core.registry.spawnPoster);
        this.rot = new Quaternion();
        this.scale = 1.0;
        this.locked = false;
        this.base_rotation = new Quaternion();
        this.base_scale = 1.0;
        this.spin_normal = 0;
        this.spin_vertical = 0;
        this.spin_tilt = 0;
        this.delta_scale = 0;
        this.norm = ForgeDirection.NORTH;
        this.top = ForgeDirection.UP;
        this.tilt = ForgeDirection.EAST;
        this.field_70129_M = 0.0f;
        this.func_70105_a(0.5f, 0.5f);
    }

    void updateSize() {
        Vec3 here = SpaceUtil.fromEntPos(this);
        SpaceUtil.setAABB(this.field_70121_D, here, here);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (dir == this.norm) continue;
            float s = (float)this.scale;
            s = dir == this.norm.getOpposite() ? (s /= 16.0f) : (s /= 2.0f);
            Vec3 d = SpaceUtil.fromDirection(dir);
            SpaceUtil.incrScale(d, s);
            this.rot.applyRotation(d);
            SpaceUtil.incrAdd(d, here);
            SpaceUtil.include(this.field_70121_D, d);
        }
    }

    public void setItem(ItemStack item) {
        if (item == null) {
            item = new ItemStack((Item)Core.registry.spawnPoster);
        }
        this.inv = item;
    }

    public ItemStack getItem() {
        if (ItemUtil.is(this.inv, Core.registry.spawnPoster)) {
            return null;
        }
        return this.inv;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean func_145770_h(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return super.func_145770_h(p_145770_1_, p_145770_3_, p_145770_5_);
    }

    public void setBase(double baseScale, Quaternion baseRotation, ForgeDirection norm, ForgeDirection top, AxisAlignedBB bounds) {
        this.scale = this.base_scale = baseScale;
        this.base_rotation = baseRotation;
        this.rot = new Quaternion(this.base_rotation);
        this.spin_normal = 0;
        this.spin_vertical = 0;
        this.delta_scale = 0;
        this.norm = norm;
        this.top = top;
        Vec3 tiltV = SpaceUtil.fromDirection(norm).func_72431_c(SpaceUtil.fromDirection(top));
        this.tilt = SpaceUtil.round(tiltV, norm);
        this.updateSize();
        SpaceUtil.copyTo(this.field_70121_D, bounds);
    }

    public void updateValues() {
        this.delta_scale = (byte)NumUtil.clip(this.delta_scale, -8, 6);
        this.scale = this.base_scale * Math.pow(1.125, this.delta_scale);
        Quaternion rNorm = Quaternion.getRotationQuaternionRadians((double)this.spin_normal * 0.19634954084936207, this.norm);
        Quaternion rVert = Quaternion.getRotationQuaternionRadians((double)this.spin_vertical * 0.19634954084936207, this.top);
        Quaternion rTilt = Quaternion.getRotationQuaternionRadians((double)this.spin_tilt * 0.19634954084936207, this.tilt);
        this.rot = rVert.multiply(rNorm).multiply(rTilt).multiply(this.base_rotation);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70067_L() {
        if (!this.field_70170_p.field_72995_K) {
            return false;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return false;
        }
        if (this.locked && !PlayerUtil.isPlayerCreative((EntityPlayer)player)) {
            return false;
        }
        if (player.func_70093_af()) {
            return true;
        }
        if (this.inv.func_77973_b() == Core.registry.spawnPoster) {
            return true;
        }
        ItemStack held = player.func_70694_bm();
        if (held == null) {
            return false;
        }
        Item it = held.func_77973_b();
        return it == Core.registry.spawnPoster || it == Core.registry.logicMatrixProgrammer || ItemUtil.swordSimilar(this.inv, held);
    }

    public boolean func_85031_j(Entity ent) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (!(ent instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)ent;
        if (this.locked && !PlayerUtil.isPlayerCreative(player)) {
            return false;
        }
        Coord at = new Coord(this);
        if (this.spin_normal != 0 || this.spin_vertical != 0 || this.spin_tilt != 0) {
            this.spin_tilt = 0;
            this.spin_vertical = 0;
            this.spin_normal = 0;
        } else if (this.delta_scale != 0) {
            this.delta_scale = 0;
        } else {
            ItemStack droppedItem = this.inv;
            this.inv = new ItemStack((Item)Core.registry.spawnPoster);
            if (droppedItem.func_77973_b() == Core.registry.spawnPoster) {
                this.func_70106_y();
            } else {
                this.syncData();
            }
            if (player.field_71075_bZ.field_75098_d) {
                return false;
            }
            Entity newItem = at.spawnItem(droppedItem);
            if (newItem instanceof EntityItem) {
                EntityItem ei = (EntityItem)newItem;
                ei.field_145804_b = 0;
            }
            newItem.func_70100_b_(player);
            return true;
        }
        this.updateValues();
        this.syncData();
        return true;
    }

    @Override
    protected void putData(DataHelper data) throws IOException {
        this.inv = data.as(Share.VISIBLE, "inv").putItemStack(this.inv);
        this.rot = data.as(Share.VISIBLE, "rot").putIDS(this.rot);
        this.scale = data.as(Share.VISIBLE, "scale").putDouble(this.scale);
        this.base_rotation = data.as(Share.PRIVATE, "baseRot").putIDS(this.base_rotation);
        this.base_scale = data.as(Share.PRIVATE, "baseScale").putDouble(this.base_scale);
        this.spin_normal = data.as(Share.PRIVATE, "spinNormal").putShort(this.spin_normal);
        this.spin_vertical = data.as(Share.PRIVATE, "spinVertical").putShort(this.spin_vertical);
        this.spin_tilt = data.as(Share.PRIVATE, "spinTilt").putShort(this.spin_tilt);
        this.delta_scale = data.as(Share.PRIVATE, "deltaScale").putByte(this.delta_scale);
        this.norm = data.as(Share.PRIVATE, "norm").putEnum(this.norm);
        this.top = data.as(Share.PRIVATE, "top").putEnum(this.top);
        this.tilt = data.as(Share.PRIVATE, "tilt").putEnum(this.tilt);
        if (data.isReader()) {
            this.updateSize();
            if (this.inv == null) {
                this.inv = new ItemStack((Item)Core.registry.spawnPoster);
            }
        }
        this.locked = data.as(Share.PRIVATE, "locked").putBoolean(this.locked);
    }

    protected void func_70088_a() {
    }

    public boolean func_130002_c(EntityPlayer player) {
        boolean hasLmp;
        int d;
        if (this.locked) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        ItemStack held = player.func_70694_bm();
        if (held == null) {
            return false;
        }
        if (this.inv.func_77973_b() == Core.registry.spawnPoster) {
            if (held.func_77973_b() == Core.registry.spawnPoster) {
                return true;
            }
            this.inv = player.func_70694_bm().func_77979_a(1);
            this.syncData();
            return true;
        }
        int n = d = player.func_70093_af() ? -1 : 1;
        if (ItemUtil.swordSimilar(this.inv, held)) {
            this.delta_scale = (byte)(this.delta_scale + d);
            this.updateValues();
            this.syncData();
            return true;
        }
        boolean hasPoster = held.func_77973_b() == Core.registry.spawnPoster;
        boolean bl = hasLmp = held.func_77973_b() == Core.registry.logicMatrixProgrammer;
        if (hasPoster || hasLmp) {
            ForgeDirection clickDir = ForgeDirection.getOrientation((int)SpaceUtil.determineOrientation(player));
            if (hasPoster) {
                if (clickDir == this.norm || clickDir == this.norm.getOpposite()) {
                    this.spin_normal = (short)(this.spin_normal - d);
                } else {
                    this.spin_vertical = (short)(this.spin_vertical + d);
                }
            } else if (clickDir == this.norm || clickDir == this.norm.getOpposite()) {
                this.spin_tilt = (short)(this.spin_tilt + d);
            } else {
                this.spin_vertical = (short)(this.spin_vertical + d);
            }
            this.updateValues();
            this.syncData();
            return true;
        }
        return super.func_130002_c(player);
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return this.inv.func_77946_l();
    }

    public int func_70070_b(float partial) {
        int z;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        if (!this.field_70170_p.func_72899_e(x, 0, z = MathHelper.func_76128_c((double)this.field_70161_v))) {
            return 0;
        }
        double d = -0.5;
        if (ForgeDirection.UP == this.top) {
            d = 0.0;
        }
        return this.field_70170_p.func_72802_i(x, MathHelper.func_76128_c((double)(this.field_70163_u + d)), z, 0);
    }

    public boolean func_70112_a(double dist) {
        return dist < 1024.0;
    }

    @Override
    public int compareRenderer(EntityPoster other) {
        return RenderSorter.compareItemRender(this.inv, other.inv, IItemRenderer.ItemRenderType.ENTITY);
    }
}

