/*
 * Decompiled with CFR 0.152.
 */
package factorization.weird.poster;

import factorization.api.Coord;
import factorization.api.Quaternion;
import factorization.shared.Core;
import factorization.shared.ItemFactorization;
import factorization.util.ItemUtil;
import factorization.util.SpaceUtil;
import factorization.weird.poster.EntityPoster;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemSpawnPoster
extends ItemFactorization {
    public ItemSpawnPoster() {
        super("spawnPoster", Core.TabType.ART);
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer player, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (w.field_72995_K) {
            return false;
        }
        PosterPlacer placer = new PosterPlacer(is, player, w, x, y, z, side);
        if (placer.invoke()) {
            return false;
        }
        placer.spawn();
        return true;
    }

    public static class PosterPlacer {
        private boolean myResult;
        private ItemStack is;
        private EntityPlayer player;
        private World w;
        private int x;
        private int y;
        private int z;
        private int side;
        final ForgeDirection dir;
        final Coord at;
        AxisAlignedBB blockBox = null;
        public EntityPoster result;
        double bestWidth;
        AxisAlignedBB bounds;
        AxisAlignedBB plane;
        Quaternion rot;
        ForgeDirection top;

        public PosterPlacer(ItemStack is, EntityPlayer player, World w, int x, int y, int z, int side) {
            this.is = is;
            this.player = player;
            this.w = w;
            this.x = x;
            this.y = y;
            this.z = z;
            this.side = side;
            this.at = new Coord(w, x, y, z);
            this.dir = ForgeDirection.getOrientation((int)side);
        }

        boolean is() {
            return this.myResult;
        }

        public boolean invoke() {
            if (this.determineBoundingBox()) {
                return true;
            }
            if (this.determineSize()) {
                return true;
            }
            this.determineOrientation();
            EntityPoster poster = new EntityPoster(this.w);
            poster.setBase(this.bestWidth, this.rot, this.dir, this.top, this.bounds);
            Vec3 spot = SpaceUtil.getMiddle(this.plane);
            if (SpaceUtil.sign(this.dir) == -1) {
                SpaceUtil.incrAdd(spot, SpaceUtil.scale(SpaceUtil.fromDirection(this.dir), 3.90625E-4));
            }
            SpaceUtil.toEntPos(poster, spot);
            this.result = poster;
            return false;
        }

        private void determineOrientation() {
            double rotationAngle = 0.0;
            if (this.dir.offsetY == 0) {
                this.top = ForgeDirection.UP;
                if (this.dir == ForgeDirection.WEST) {
                    rotationAngle = 1.0;
                }
                if (this.dir == ForgeDirection.SOUTH) {
                    rotationAngle = 2.0;
                }
                if (this.dir == ForgeDirection.EAST) {
                    rotationAngle = 3.0;
                }
            } else {
                this.top = ForgeDirection.WEST;
                rotationAngle = -this.dir.offsetY;
            }
            this.rot = Quaternion.getRotationQuaternionRadians(rotationAngle * Math.PI / 2.0, this.top);
        }

        private boolean determineSize() {
            this.plane = SpaceUtil.flatten(this.blockBox, this.dir);
            double pix = 0.0625;
            this.bounds = this.plane.func_72321_a((double)this.dir.offsetX * 0.0625, (double)this.dir.offsetY * 0.0625, (double)this.dir.offsetZ * 0.0625);
            for (Object ent : this.w.func_72872_a(EntityPoster.class, this.bounds)) {
                if (ent instanceof EntityPoster) {
                    EntityPoster poster = (EntityPoster)ent;
                    if (!ItemUtil.is(poster.inv, Core.registry.spawnPoster)) continue;
                    return true;
                }
                return true;
            }
            double xwidth = this.plane.field_72336_d - this.plane.field_72340_a;
            double ywidth = this.plane.field_72337_e - this.plane.field_72338_b;
            double zwidth = this.plane.field_72334_f - this.plane.field_72339_c;
            this.bestWidth = SpaceUtil.getDiagonalLength(this.plane);
            if (xwidth != 0.0) {
                this.bestWidth = xwidth;
            }
            if (ywidth != 0.0 && ywidth < this.bestWidth) {
                this.bestWidth = ywidth;
            }
            if (zwidth != 0.0 && zwidth < this.bestWidth) {
                this.bestWidth = zwidth;
            }
            return this.bestWidth <= 0.125;
        }

        private boolean determineBoundingBox() {
            MovingObjectPosition mop;
            ArrayList boxes = new ArrayList();
            AxisAlignedBB query = SpaceUtil.createAABB(this.at.add(-9, -9, -9), this.at.add(9, 9, 9));
            this.at.getBlock().func_149743_a(this.at.w, this.at.x, this.at.y, this.at.z, query, boxes, (Entity)this.player);
            Vec3 playerEye = SpaceUtil.fromPlayerEyePos(this.player);
            Vec3 look = this.player.func_70040_Z();
            SpaceUtil.incrScale(look, 8.0);
            Vec3 reachEnd = SpaceUtil.add(look, playerEye);
            double minDist = Double.POSITIVE_INFINITY;
            for (AxisAlignedBB box : boxes) {
                double vecLen;
                MovingObjectPosition mop2 = box.func_72327_a(playerEye, reachEnd);
                if (mop2 == null || mop2.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK || mop2.field_72307_f == null || (vecLen = mop2.field_72307_f.func_72433_c()) > minDist) continue;
                minDist = vecLen;
                this.side = mop2.field_72310_e;
                this.blockBox = box;
            }
            if (this.blockBox == null) {
                this.blockBox = this.at.getCollisionBoundingBoxFromPool();
            }
            if (this.blockBox == null && (mop = this.at.getBlock().func_149731_a(this.at.w, this.at.x, this.at.y, this.at.z, playerEye, reachEnd)) != null) {
                this.blockBox = this.at.getBlockBounds();
            }
            return this.blockBox == null;
        }

        public void spawn() {
            this.w.func_72838_d((Entity)this.result);
            if (!this.player.field_71075_bZ.field_75098_d) {
                --this.is.field_77994_a;
            }
        }
    }
}

