/*
 * Decompiled with CFR 0.152.
 */
package neresources.compatibility.cofh;

import cofh.api.world.IFeatureGenerator;
import cofh.core.world.WorldHandler;
import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenBoulder;
import cofh.lib.world.WorldGenDecoration;
import cofh.lib.world.WorldGenGeode;
import cofh.lib.world.WorldGenMinableCluster;
import cofh.lib.world.WorldGenMinableLargeVein;
import cofh.lib.world.WorldGenSparseMinableCluster;
import cofh.lib.world.feature.FeatureBase;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import neresources.api.distributions.DistributionBase;
import neresources.api.distributions.DistributionCustom;
import neresources.api.messages.RegisterOreMessage;
import neresources.api.utils.DistributionHelpers;
import neresources.compatibility.CompatBase;
import neresources.utils.LoaderHelper;
import neresources.utils.ReflectionHelper;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.gen.feature.WorldGenerator;

public class CoFHCompat
extends CompatBase {
    private static List<IFeatureGenerator> features;
    public static boolean cofhReplace;
    private static Class featureGenUniform;
    private static Class featureGenNormal;
    private static Class featureGenSurface;
    private static Class featureGenLargeVein;
    private static Class featureGenTopBlock;
    private static Class featureGenUnderFluid;
    public static boolean isVersionB6;

    public CoFHCompat() {
        if (Loader.isModLoaded((String)"CoFHCore")) {
            if (LoaderHelper.isModVersion("CoFHCore", "1.7.10R3.0.0B6")) {
                featureGenUniform = ReflectionHelper.findClass("cofh.lib.world.feature.FeatureOreGenUniform");
                featureGenNormal = ReflectionHelper.findClass("cofh.lib.world.feature.FeatureOreGenNormal");
                featureGenSurface = ReflectionHelper.findClass("cofh.lib.world.feature.FeatureOreGenSurface");
                isVersionB6 = true;
            } else {
                featureGenUniform = ReflectionHelper.findClass("cofh.lib.world.feature.FeatureGenUniform");
                featureGenNormal = ReflectionHelper.findClass("cofh.lib.world.feature.FeatureGenNormal");
                featureGenSurface = ReflectionHelper.findClass("cofh.lib.world.feature.FeatureGenSurface");
                featureGenLargeVein = ReflectionHelper.findClass("cofh.lib.world.feature.FeatureGenLargeVein");
                featureGenTopBlock = ReflectionHelper.findClass("cofh.lib.world.feature.FeatureGenTopBlock");
                featureGenUnderFluid = ReflectionHelper.findClass("cofh.lib.world.feature.FeatureGenUnderfluid");
                isVersionB6 = false;
            }
            Class worldHandler = ReflectionHelper.findClass("cofh.core.world.WorldHandler");
            if (worldHandler != null) {
                cofhReplace = ReflectionHelper.getBoolean(worldHandler, "genReplaceVanilla", null);
            }
        }
    }

    @Override
    public void init() {
        cofhReplace = WorldHandler.genReplaceVanilla;
        features = (ArrayList)ReflectionHelper.getObject(WorldHandler.class, "features", null);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.registerOres();
        }
    }

    private void registerOres() {
        for (IFeatureGenerator feature : features) {
            boolean water;
            int count;
            CoFHWorldGen oreGen;
            if (feature instanceof FeatureBase) {
                FeatureBase.GenRestriction dimensionRestriction = (FeatureBase.GenRestriction)ReflectionHelper.getObject(FeatureBase.class, "dimensionRestriction", feature);
                FeatureBase.GenRestriction genRestriction = (FeatureBase.GenRestriction)ReflectionHelper.getObject(FeatureBase.class, "biomeRestriction", feature);
            }
            if (feature.getClass() == featureGenUniform) {
                int maxY = ReflectionHelper.getInt(featureGenUniform, "maxY", feature);
                int minY = ReflectionHelper.getInt(featureGenUniform, "minY", feature);
                int count2 = ReflectionHelper.getInt(featureGenUniform, "count", feature);
                WorldGenerator worldGen = (WorldGenerator)ReflectionHelper.getObject(featureGenUniform, "worldGen", feature);
                oreGen = this.getCoFHWorldGen(worldGen);
                if (oreGen.ores == null) continue;
                this.registerOreEntries(oreGen.ores, this.getChancesForUniform(minY, maxY, oreGen.veinSize, count2));
                continue;
            }
            if (feature.getClass() == featureGenNormal) {
                int maxVar = ReflectionHelper.getInt(featureGenNormal, "maxVar", feature);
                int meanY = ReflectionHelper.getInt(featureGenNormal, "meanY", feature);
                int count3 = ReflectionHelper.getInt(featureGenNormal, "count", feature);
                WorldGenerator worldGen = (WorldGenerator)ReflectionHelper.getObject(featureGenNormal, "worldGen", feature);
                oreGen = this.getCoFHWorldGen(worldGen);
                if (oreGen.ores == null) continue;
                this.registerOreEntries(oreGen.ores, this.getChancesForNormal(meanY, maxVar, oreGen.veinSize, count3));
                continue;
            }
            if (feature.getClass() == featureGenSurface) {
                count = ReflectionHelper.getInt(featureGenSurface, "count", feature);
                WorldGenerator worldGen = (WorldGenerator)ReflectionHelper.getObject(featureGenSurface, "worldGen", feature);
                CoFHWorldGen oreGen2 = this.getCoFHWorldGen(worldGen);
                if (oreGen2.ores == null) continue;
                int diameter = (int)Math.pow(oreGen2.veinSize, 0.333333);
                this.registerOreEntries(oreGen2.ores, DistributionHelpers.multiplyArray(DistributionHelpers.getOverworldSurfaceDistribution(diameter), count));
                continue;
            }
            if (feature.getClass() == featureGenLargeVein) {
                count = ReflectionHelper.getInt(featureGenLargeVein, "count", feature);
                int minY = ReflectionHelper.getInt(featureGenLargeVein, "minY", feature);
                int veinHeight = ReflectionHelper.getInt(featureGenLargeVein, "veinHeight", feature);
                float[] verticalDistribution = DistributionHelpers.getRoundedSquareDistribution((int)((double)minY + 0.125 * (double)veinHeight), (int)((double)minY + 0.25 * (double)veinHeight), (int)((double)minY + 0.75 * (double)veinHeight), (int)((double)minY + 0.875 * (double)veinHeight), 1.0f);
                verticalDistribution = DistributionHelpers.divideArray(verticalDistribution, DistributionHelpers.sum(verticalDistribution));
                float[] oreDistribution = new float[256];
                for (int i = 0; i < oreDistribution.length; ++i) {
                    float midY = verticalDistribution[i] / (float)(veinHeight / 2);
                    if (midY == 0.0f) continue;
                    DistributionHelpers.addDistribution(oreDistribution, DistributionHelpers.getTriangularDistribution(i, veinHeight / 2, midY));
                }
                WorldGenerator worldGen = (WorldGenerator)ReflectionHelper.getObject(featureGenLargeVein, "worldGen", feature);
                CoFHWorldGen oreGen3 = this.getCoFHWorldGen(worldGen);
                if (oreGen3.ores == null) continue;
                this.registerOreEntries(oreGen3.ores, DistributionHelpers.multiplyArray(oreDistribution, (float)count * (float)oreGen3.veinSize / 256.0f));
                continue;
            }
            if (feature.getClass() == featureGenTopBlock) {
                count = ReflectionHelper.getInt(featureGenTopBlock, "count", feature);
                WorldGenerator worldGen = (WorldGenerator)ReflectionHelper.getObject(featureGenTopBlock, "worldGen", feature);
                CoFHWorldGen oreGen4 = this.getCoFHWorldGen(worldGen);
                if (oreGen4.ores == null) continue;
                this.registerOreEntries(oreGen4.ores, DistributionHelpers.multiplyArray(DistributionHelpers.getOverworldSurface(), count * oreGen4.veinSize));
                continue;
            }
            if (feature.getClass() != featureGenUnderFluid || !(water = ReflectionHelper.getBoolean(featureGenUnderFluid, "water", feature))) continue;
            int count4 = ReflectionHelper.getInt(featureGenUnderFluid, "count", feature);
            WorldGenerator worldGen = (WorldGenerator)ReflectionHelper.getObject(featureGenUnderFluid, "worldGen", feature);
            CoFHWorldGen oreGen5 = this.getCoFHWorldGen(worldGen);
            if (oreGen5.ores == null) continue;
            this.registerOreEntries(oreGen5.ores, this.getChancesForUnderwater(oreGen5.veinSize, count4));
        }
    }

    private float[] getChancesForUnderwater(int veinSize, int numVeins) {
        float chance = 0.6f * ((float)veinSize * (float)numVeins) / 256.0f;
        return DistributionHelpers.getUnderwaterDistribution(chance);
    }

    private float[] getChancesForUniform(int minY, int maxY, int veinSize, int numVeins) {
        int safeMinY = Math.max(minY, 0);
        int safeMaxY = Math.min(maxY, 255);
        float chance = (float)numVeins / (float)(safeMaxY - safeMinY + 1) * (float)veinSize / 256.0f;
        return DistributionHelpers.getRoundedSquareDistribution(Math.max(0, minY - veinSize / 2), safeMinY, safeMaxY, Math.min(maxY + veinSize / 2, 255), chance);
    }

    private float[] getChancesForNormal(int meanY, int maxVar, int veinSize, int numVeins) {
        float[] normalDistribution = DistributionHelpers.getTriangularDistribution(meanY, maxVar + veinSize / 2, 1.0f);
        float total = DistributionHelpers.sum(normalDistribution);
        float chance = (float)numVeins / total * (float)veinSize / 256.0f;
        return DistributionHelpers.multiplyArray(normalDistribution, chance);
    }

    private void registerOreEntries(List<WeightedRandomBlock> ores, float[] baseChance) {
        float totalWeight = 0.0f;
        for (WeightedRandomBlock ore : ores) {
            totalWeight += (float)ore.field_76292_a;
        }
        for (WeightedRandomBlock ore : ores) {
            if (ore.block == Blocks.field_150351_n || ore.block == Blocks.field_150346_d) {
                return;
            }
            this.registerOre(new RegisterOreMessage(new ItemStack(ore.block, 1, ore.metadata), (DistributionBase)new DistributionCustom(DistributionHelpers.multiplyArray(baseChance, (float)ore.field_76292_a / totalWeight)), new ItemStack[0]));
        }
    }

    public CoFHWorldGen getCoFHWorldGen(WorldGenerator worldGen) {
        CoFHWorldGen oreGen = new CoFHWorldGen();
        if (worldGen instanceof WorldGenMinableCluster) {
            oreGen = new CoFHWorldGen((WorldGenMinableCluster)worldGen);
        } else if (worldGen instanceof WorldGenSparseMinableCluster) {
            oreGen = new CoFHWorldGen((WorldGenSparseMinableCluster)worldGen);
        } else if (!isVersionB6 && worldGen instanceof WorldGenMinableLargeVein) {
            oreGen = new CoFHWorldGen((WorldGenMinableLargeVein)worldGen);
        } else if (!isVersionB6 && worldGen instanceof WorldGenGeode) {
            oreGen = new CoFHWorldGen((WorldGenGeode)worldGen);
        } else if (!isVersionB6 && worldGen instanceof WorldGenDecoration) {
            oreGen = new CoFHWorldGen((WorldGenDecoration)worldGen);
        } else if (!isVersionB6 && worldGen instanceof WorldGenBoulder) {
            oreGen = new CoFHWorldGen((WorldGenBoulder)worldGen);
        }
        return oreGen;
    }

    static {
        cofhReplace = false;
    }

    private class CoFHWorldGen {
        int veinSize;
        ArrayList<WeightedRandomBlock> ores;
        WeightedRandomBlock[] genBlock;

        public CoFHWorldGen() {
        }

        public CoFHWorldGen(WorldGenMinableCluster worldGen) {
            this.ores = (ArrayList)ReflectionHelper.getObject(WorldGenMinableCluster.class, "cluster", worldGen);
            this.veinSize = ReflectionHelper.getInt(WorldGenMinableCluster.class, "genClusterSize", worldGen);
            this.genBlock = (WeightedRandomBlock[])ReflectionHelper.getObject(WorldGenMinableCluster.class, "genBlock", worldGen);
        }

        public CoFHWorldGen(WorldGenMinableLargeVein worldGen) {
            this.ores = (ArrayList)ReflectionHelper.getObject(WorldGenMinableLargeVein.class, "cluster", worldGen);
            this.veinSize = ReflectionHelper.getInt(WorldGenMinableLargeVein.class, "genVeinSize", worldGen);
            this.genBlock = (WeightedRandomBlock[])ReflectionHelper.getObject(WorldGenMinableLargeVein.class, "genBlock", worldGen);
        }

        public CoFHWorldGen(WorldGenSparseMinableCluster worldGen) {
            this.ores = (ArrayList)ReflectionHelper.getObject(WorldGenSparseMinableCluster.class, "cluster", worldGen);
            this.veinSize = ReflectionHelper.getInt(WorldGenSparseMinableCluster.class, "genClusterSize", worldGen);
            this.genBlock = (WeightedRandomBlock[])ReflectionHelper.getObject(WorldGenSparseMinableCluster.class, "genBlock", worldGen);
        }

        public CoFHWorldGen(WorldGenGeode worldGen) {
        }

        public CoFHWorldGen(WorldGenDecoration worldGen) {
        }

        public CoFHWorldGen(WorldGenBoulder worldGen) {
            this.ores = (ArrayList)ReflectionHelper.getObject(WorldGenBoulder.class, "cluster", worldGen);
            this.genBlock = (WeightedRandomBlock[])ReflectionHelper.getObject(WorldGenBoulder.class, "genBlock", worldGen);
            int minSize = ReflectionHelper.getInt(WorldGenBoulder.class, "size", worldGen);
            int count = worldGen.clusters;
            int var = worldGen.sizeVariance;
            float radius = (float)minSize + (float)(var - 1) * 0.5f + 0.5f;
            this.veinSize = (int)(4.188790321350098 * (double)radius * (double)radius * (double)radius) * count;
        }
    }
}

