/*
 * Decompiled with CFR 0.152.
 */
package k4unl.minecraft.colorchat.lib;

import java.util.ArrayList;
import java.util.Random;
import k4unl.minecraft.colorchat.commands.CommandColor;
import k4unl.minecraft.colorchat.lib.Group;
import k4unl.minecraft.colorchat.lib.SpecialChars;
import k4unl.minecraft.colorchat.lib.config.Config;

public class User {
    private SpecialChars userColor;
    private String nick;
    private String realUserName;
    private boolean hasNick;
    private Group group;

    public User(String _username, SpecialChars _userColor, String _nick) {
        this.realUserName = _username;
        this.userColor = _userColor;
        this.nick = _nick;
    }

    public User(String _username) {
        this.realUserName = _username;
        ArrayList<String> keysAsArray = new ArrayList<String>(CommandColor.colors.keySet());
        String newClr = (String)keysAsArray.get(new Random().nextInt(keysAsArray.size()));
        while (Config.isColorBlackListed(newClr)) {
            newClr = (String)keysAsArray.get(new Random().nextInt(keysAsArray.size()));
        }
        this.userColor = CommandColor.colors.get(newClr);
    }

    public String getUserName() {
        return this.realUserName;
    }

    public String getNick() {
        if (this.hasNick) {
            return this.nick;
        }
        return this.realUserName;
    }

    public SpecialChars getColor() {
        return this.userColor;
    }

    public void setNick(String newNick) {
        this.nick = newNick;
        this.hasNick = true;
    }

    public void resetNick() {
        this.hasNick = false;
    }

    public void setUserColor(SpecialChars newColor) {
        this.userColor = newColor;
    }

    public boolean hasNick() {
        return this.hasNick;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group newGroup) {
        this.group = newGroup;
    }
}

