/*
 * Decompiled with CFR 0.152.
 */
package k4unl.minecraft.colorchat.lib.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;

public class Config {
    private static final List<configOption> configOptions = new ArrayList<configOption>();
    private static String[] blacklistedColors;
    private static String[] blacklistedNicks;
    private static String[] blacklistedSymbols;

    public static void loadConfigOptions(Configuration c) {
        blacklistedColors = c.get("general", "blacklistColors", new String[]{"darkblue", "black"}).getStringList();
        blacklistedNicks = c.get("general", "blacklistNicks", new String[]{"K4Unl", "Direwolf20", "Quetzi", "Krystal_Raven"}).getStringList();
        for (configOption config : configOptions) {
            config.loadFromConfig(c);
        }
    }

    public static boolean getBool(String key) {
        for (configOption config : configOptions) {
            if (config.getKey() != key) continue;
            return config.getBool();
        }
        return false;
    }

    public static int getInt(String key) {
        for (configOption config : configOptions) {
            if (config.getKey() != key) continue;
            return config.getInt();
        }
        return 0;
    }

    public static String getString(String key) {
        for (configOption config : configOptions) {
            if (config.getKey() != key) continue;
            return config.getString();
        }
        return "";
    }

    public static char getChar(String key) {
        for (configOption config : configOptions) {
            if (config.getKey() != key) continue;
            return config.getChar();
        }
        return '\u0000';
    }

    public static boolean isColorBlackListed(String color) {
        for (String blackListed : blacklistedColors) {
            if (!blackListed.equals(color)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNickBlackListed(String nick) {
        for (String blackListed : blacklistedNicks) {
            if (!blackListed.equalsIgnoreCase(nick)) continue;
            return true;
        }
        return false;
    }

    static {
        configOptions.add(new configOption("minimumNickLength", 4));
        configOptions.add(new configOption("announceNickChanges", true));
        configOptions.add(new configOption("nickChangeOPOnly", false));
        configOptions.add(new configOption("leadingSymbolOnNick", '~'));
    }

    private static class configOption {
        private String key;
        private boolean isBool;
        private boolean isInt;
        private boolean isString;
        private boolean isChar;
        private boolean val;
        private boolean def;
        private int valInt;
        private int defInt;
        private String valString;
        private String defString;
        private char valChar;
        private char defChar;
        private String category = "general";

        public configOption(String _key, boolean _def) {
            this.key = _key;
            this.val = _def;
            this.def = _def;
            this.isBool = true;
            this.isInt = false;
            this.isString = false;
        }

        public configOption(String _key, int _def) {
            this.key = _key;
            this.valInt = _def;
            this.defInt = _def;
            this.isBool = false;
            this.isInt = true;
            this.isString = false;
        }

        public configOption(String _key, String _def) {
            this.key = _key;
            this.valString = _def;
            this.defString = _def;
            this.isBool = false;
            this.isInt = false;
            this.isString = true;
        }

        public configOption(String _key, char _def) {
            this.key = _key;
            this.valChar = _def;
            this.defChar = _def;
            this.isBool = false;
            this.isInt = false;
            this.isString = false;
            this.isChar = true;
        }

        public configOption setCategory(String newCat) {
            this.category = newCat;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public boolean getBool() {
            return this.val;
        }

        public int getInt() {
            return this.valInt;
        }

        public String getString() {
            return this.valString;
        }

        public char getChar() {
            return this.valChar;
        }

        public void loadFromConfig(Configuration config) {
            String t;
            if (this.isBool) {
                this.val = config.get(this.category, this.key, this.def).getBoolean(this.def);
            } else if (this.isInt) {
                this.valInt = config.get(this.category, this.key, this.defInt).getInt(this.defInt);
            } else if (this.isString) {
                this.valString = config.get(this.category, this.key, this.defString).getString();
            } else if (this.isChar && (t = config.get(this.category, this.key, this.defChar + "").getString()).length() > 0) {
                this.valChar = t.charAt(0);
            }
        }
    }
}

